package org.ow2.easywsdl.tooling.java2wsdl.ant;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.ow2.easywsdl.tooling.java2wsdl.Main;
import org.apache.tools.ant.Task;

public class Java2WSDLTask extends Task {

	private String output;
	private String serviceClass;
	private String nsMapping;
	private boolean verbose;
	private boolean polymorph = false;
	//polyClasses is a list of classes separated by ";" or ","
	private String polyclasses = "";
	
	public String getNsMapping() {
		return nsMapping;
	}

	public void setNsMapping(String nsMapping) {
		this.nsMapping = nsMapping;
	}

	public String getOutput() {
		return output;
	}

	public void setOutput(String output) {
		this.output = output;
	}

	public boolean isVerbose() {
		return verbose;
	}

	public void setVerbose(boolean verbose) {
		this.verbose = verbose;
	}

	public String getServiceClass() {
		return serviceClass;
	}

	public void setServiceClass(String serviceClass) {
		this.serviceClass = serviceClass;
	}
	
	public boolean isPolymorph() {
		return polymorph;
	}

	public void setPolymorph(boolean polymorph) {
		this.polymorph = polymorph;
	}

	public String getPolyclasses() {
		return polyclasses;
	}

	public void setPolyclasses(String polyclasses) {
		this.polyclasses = polyclasses;
	}
	
	// TODO : use a nested element to have multiple classes as input instead of
	// serviceClass
	public void execute() {
		
		System.out.println("Generating wsdl for class " + serviceClass+ ".");
		
		Main java2EasyWsdl = new Main();
		java2EasyWsdl.setVerbose(this.verbose);
		java2EasyWsdl.setWSDL(this.output);
		java2EasyWsdl.setServiceClass(this.serviceClass);
		java2EasyWsdl.setPolymorph(this.polymorph);
		
		if (nsMapping != null && !"".equals(nsMapping)){
			java2EasyWsdl.setCustomNS(true);
			java2EasyWsdl.setTargetMapping(this.nsMapping);
		}
 
		if (this.polymorph && (! "".equals(this.polyclasses)))
		{
			List<String> res = new ArrayList<String>();
			for (StringTokenizer tok = new StringTokenizer(this.polyclasses,",;"); tok.hasMoreTokens();){
				res.add(tok.nextToken());
			}
			java2EasyWsdl.setPolymorphClasses(res);
		}
		
		java2EasyWsdl.generateWSDL();

	}
	
	public static void main(String[] args) {
		
		System.out.println("starting...");
		Java2WSDLTask task = new Java2WSDLTask();
		task.setVerbose(true);
		task.setOutput("testejb.wsdl");
		task.setServiceClass("fr.mbe.test.ComplexTestEJBImpl");
		
		task.execute();
	}

}
