/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.console.jmxbrowser.service;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easybeans.console.jmxbrowser.service.JMXAttributes;
import org.ow2.easybeans.console.jmxbrowser.service.JMXOperation;
import org.ow2.easybeans.console.jmxbrowser.service.JMXParameterOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXBrowserService
implements Serializable {
    private static final long serialVersionUID = -876338222735762564L;
    private int counter = 0;

    public int getCounter() {
        return ++this.counter;
    }

    public Document getXML() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document document = builder.newDocument();
        Element root = document.createElement("root");
        document.appendChild(root);
        TreeMap mBeansMap = new TreeMap();
        Set<ObjectName> names = null;
        try {
            names = this.getMBeanServerConnection().queryNames(null, null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        for (ObjectName objectName : names) {
            ArrayList<ObjectName> lst;
            String j2eeType = objectName.getKeyProperty("j2eeType");
            String standardtype = objectName.getKeyProperty("type");
            String key = null;
            String keyValue = null;
            if (j2eeType != null) {
                key = "Java EE";
                keyValue = j2eeType;
            } else if (standardtype != null) {
                key = "Standard";
                keyValue = standardtype;
            } else {
                key = "Others";
                keyValue = "other";
            }
            TreeMap<String, ArrayList<ObjectName>> typeList = (TreeMap<String, ArrayList<ObjectName>>)mBeansMap.get(key);
            if (typeList == null) {
                typeList = new TreeMap<String, ArrayList<ObjectName>>();
                mBeansMap.put(key, typeList);
            }
            if ((lst = (ArrayList<ObjectName>)typeList.get(keyValue)) == null) {
                lst = new ArrayList<ObjectName>();
                typeList.put(keyValue, lst);
            }
            lst.add(objectName);
        }
        for (String keyMBean : mBeansMap.keySet()) {
            Element domainElement = document.createElement("node");
            domainElement.setAttribute("label", keyMBean);
            domainElement.setAttribute("isBranch", "true");
            root.appendChild(domainElement);
            Map subTypeMap = (Map)mBeansMap.get(keyMBean);
            for (String type : subTypeMap.keySet()) {
                Element subElement = document.createElement("node");
                subElement.setAttribute("label", type);
                subElement.setAttribute("isBranch", "true");
                domainElement.appendChild(subElement);
                List oNames = (List)subTypeMap.get(type);
                for (ObjectName oName : oNames) {
                    Element txtElement = document.createElement("mbean");
                    txtElement.setAttribute("isBranch", "false");
                    txtElement.appendChild(document.createTextNode(oName.toString()));
                    subElement.appendChild(txtElement);
                }
            }
        }
        DOMSource source = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return document;
    }

    public String[] getAttributes(String oName) {
        ArrayList<String> lst = new ArrayList<String>();
        MBeanServerConnection mBeanServerConnection = null;
        try {
            mBeanServerConnection = this.getMBeanServerConnection();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        MBeanInfo info = null;
        try {
            info = mBeanServerConnection.getMBeanInfo(new ObjectName(oName));
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MBeanAttributeInfo[] attributeArray = info.getAttributes();
        for (int x = 0; x < attributeArray.length; ++x) {
            String attributeName = attributeArray[x].getName();
            lst.add(attributeName);
        }
        Object[] array = lst.toArray(new String[lst.size()]);
        Arrays.sort(array);
        return array;
    }

    public void updateAttributeValue(String oNameStr, String name, Object value) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, Exception {
        ObjectName oName = this.getObjectName(oNameStr);
        Attribute attribute = new Attribute(name, value);
        this.getMBeanServerConnection().setAttribute(oName, attribute);
    }

    public Object callOperation(String oNameStr, String operationName, Object[] signatureObj, Object[] params) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, Exception {
        ObjectName oName = this.getObjectName(oNameStr);
        String[] signature = null;
        if (signatureObj != null) {
            signature = new String[signatureObj.length];
            int i = 0;
            for (Object o : signatureObj) {
                signature[i++] = o.toString();
            }
        }
        return this.getMBeanServerConnection().invoke(oName, operationName, params, signature);
    }

    protected ObjectName getObjectName(String oNameStr) {
        ObjectName oName = null;
        try {
            oName = new ObjectName(oNameStr);
        }
        catch (MalformedObjectNameException e1) {
            e1.printStackTrace();
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
        }
        return oName;
    }

    public List<JMXAttributes> getJMXAttributes(String oNameStr) {
        MBeanAttributeData mBeanAttributeData;
        TreeMap<String, MBeanAttributeData> attributesMap = new TreeMap<String, MBeanAttributeData>();
        MBeanInfo info = null;
        ObjectName oName = this.getObjectName(oNameStr);
        try {
            info = this.getMBeanServerConnection().getMBeanInfo(oName);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MBeanAttributeInfo[] attributeArray = info.getAttributes();
        for (int x = 0; x < attributeArray.length; ++x) {
            MBeanAttributeInfo mBeanAttributeInfo = attributeArray[x];
            String attributeName = mBeanAttributeInfo.getName();
            mBeanAttributeData = new MBeanAttributeData();
            mBeanAttributeData.mBeanAttributeInfo = mBeanAttributeInfo;
            Object objectValue = null;
            try {
                objectValue = this.getMBeanServerConnection().getAttribute(oName, attributeName);
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mBeanAttributeData.value = "null";
            if (objectValue != null) {
                boolean b = objectValue.getClass().isArray();
                mBeanAttributeData.value = b ? Arrays.asList((Object[])objectValue).toString() : objectValue.toString();
            }
            attributesMap.put(attributeName, mBeanAttributeData);
        }
        ArrayList<JMXAttributes> list = new ArrayList<JMXAttributes>();
        for (String attributeName : attributesMap.keySet()) {
            mBeanAttributeData = (MBeanAttributeData)attributesMap.get(attributeName);
            JMXAttributes jmxAttributes = new JMXAttributes();
            list.add(jmxAttributes);
            jmxAttributes.setName(attributeName);
            jmxAttributes.setDesc(mBeanAttributeData.mBeanAttributeInfo.getDescription());
            jmxAttributes.setType(mBeanAttributeData.mBeanAttributeInfo.getType());
            jmxAttributes.setValue(mBeanAttributeData.value);
            jmxAttributes.setReadable(mBeanAttributeData.mBeanAttributeInfo.isReadable());
            jmxAttributes.setWritable(mBeanAttributeData.mBeanAttributeInfo.isWritable());
        }
        return list;
    }

    public List<JMXOperation> getJMXOperations(String oNameStr) {
        MBeanOperationInfo[] mBeanOperationInfos;
        ArrayList<JMXOperation> jmxOperations = new ArrayList<JMXOperation>();
        ObjectName oName = this.getObjectName(oNameStr);
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.getMBeanServerConnection().getMBeanInfo(oName);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (MBeanOperationInfo mBeanOperationInfo : mBeanOperationInfos = mBeanInfo.getOperations()) {
            MBeanParameterInfo[] mBeanParameterInfos;
            JMXOperation jmxOperation = new JMXOperation();
            jmxOperations.add(jmxOperation);
            jmxOperation.setName(mBeanOperationInfo.getName());
            jmxOperation.setDesc(mBeanOperationInfo.getDescription());
            jmxOperation.setReturnType(mBeanOperationInfo.getReturnType());
            for (MBeanParameterInfo mBeanParameterInfo : mBeanParameterInfos = mBeanOperationInfo.getSignature()) {
                JMXParameterOperation jmxParameterOperation = new JMXParameterOperation();
                jmxOperation.addParameter(jmxParameterOperation);
                jmxParameterOperation.setName(mBeanParameterInfo.getName());
                jmxParameterOperation.setDesc(mBeanParameterInfo.getDescription());
                jmxParameterOperation.setType(mBeanParameterInfo.getType());
            }
        }
        Collections.sort(jmxOperations);
        return jmxOperations;
    }

    public List<String> getProtocols() {
        Set<ObjectName> oNames = null;
        StringBuffer sb = new StringBuffer();
        sb.append(":j2eeType=JNDIResource");
        sb.append(",*");
        ObjectName oName = null;
        try {
            oName = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        try {
            oNames = this.getMBeanServerConnection().queryNames(oName, null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ArrayList<String> protocolNames = new ArrayList<String>();
        for (ObjectName objectName : oNames) {
            protocolNames.add(objectName.getKeyProperty("name"));
        }
        return protocolNames;
    }

    private MBeanServerConnection getMBeanServerConnection() throws Exception {
        MBeanServer mBeanServer = (MBeanServer)MBeanServer.class.cast(MBeanServerFactory.findMBeanServer(null).get(0));
        return mBeanServer;
    }

    class MBeanAttributeData {
        public MBeanAttributeInfo mBeanAttributeInfo = null;
        public String value = null;

        MBeanAttributeData() {
        }
    }
}

