/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.compass;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager;
import org.osmdroid.library.R;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.compass.IOrientationConsumer;
import org.osmdroid.views.overlay.compass.IOrientationProvider;
import org.osmdroid.views.overlay.compass.InternalCompassOrientationProvider;

public class CompassOverlay
extends Overlay
implements IOverlayMenuProvider,
IOrientationConsumer {
    private Paint sSmoothPaint = new Paint(2);
    protected MapView mMapView;
    private final Display mDisplay;
    public IOrientationProvider mOrientationProvider;
    protected Bitmap mCompassFrameBitmap;
    protected Bitmap mCompassRoseBitmap;
    private final Matrix mCompassMatrix = new Matrix();
    private boolean mIsCompassEnabled;
    private boolean wasEnabledOnPause = false;
    private int mMode = 1;
    private float mAzimuth = Float.NaN;
    private float mAzimuthOffset = 0.0f;
    private boolean mInCenter = false;
    private float mCompassCenterX = 35.0f;
    private float mCompassCenterY = 35.0f;
    private final float mCompassRadius = 20.0f;
    protected final float mCompassFrameCenterX;
    protected final float mCompassFrameCenterY;
    protected final float mCompassRoseCenterX;
    protected final float mCompassRoseCenterY;
    protected long mLastRender = 0L;
    public static final int MENU_COMPASS = CompassOverlay.getSafeMenuId();
    private boolean mOptionsMenuEnabled = true;
    protected final float mScale;
    private int mLastRenderLag = 500;
    private float mAzimuthPrecision = 0.0f;

    public CompassOverlay(Context context, MapView mapView) {
        this(context, new InternalCompassOrientationProvider(context), mapView);
    }

    public CompassOverlay(Context context, IOrientationProvider orientationProvider, MapView mapView) {
        this.mScale = context.getResources().getDisplayMetrics().density;
        this.mMapView = mapView;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.mDisplay = windowManager.getDefaultDisplay();
        this.createCompassFramePicture();
        if (this.mMode > 0) {
            this.createCompassRosePicture();
        } else {
            this.createPointerPicture();
        }
        this.mCompassFrameCenterX = (float)this.mCompassFrameBitmap.getWidth() / 2.0f - 0.5f;
        this.mCompassFrameCenterY = (float)this.mCompassFrameBitmap.getHeight() / 2.0f - 0.5f;
        this.mCompassRoseCenterX = (float)this.mCompassRoseBitmap.getWidth() / 2.0f - 0.5f;
        this.mCompassRoseCenterY = (float)this.mCompassRoseBitmap.getHeight() / 2.0f - 0.5f;
        this.setOrientationProvider(orientationProvider);
    }

    @Override
    public void onPause() {
        this.wasEnabledOnPause = this.mIsCompassEnabled;
        if (this.mOrientationProvider != null) {
            this.mOrientationProvider.stopOrientationProvider();
        }
        super.onPause();
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.wasEnabledOnPause) {
            this.enableCompass();
        }
    }

    @Override
    public void onDetach(MapView mapView) {
        this.mMapView = null;
        this.sSmoothPaint = null;
        this.disableCompass();
        this.mOrientationProvider = null;
        this.mCompassFrameBitmap.recycle();
        this.mCompassRoseBitmap.recycle();
        super.onDetach(mapView);
    }

    public void setLastRenderLag(int pLastRenderLag) {
        this.mLastRenderLag = pLastRenderLag;
    }

    public void setAzimuthPrecision(float pAzimuthPrecision) {
        this.mAzimuthPrecision = pAzimuthPrecision;
    }

    private void invalidateCompass() {
        int frameBottom;
        int frameRight;
        int frameTop;
        int frameLeft;
        if (this.mLastRender + (long)this.mLastRenderLag > System.currentTimeMillis()) {
            return;
        }
        this.mLastRender = System.currentTimeMillis();
        Rect screenRect = this.mMapView.getProjection().getScreenRect();
        if (this.mInCenter) {
            frameLeft = screenRect.left + (int)Math.ceil(screenRect.exactCenterX() - this.mCompassFrameCenterX);
            frameTop = screenRect.top + (int)Math.ceil(screenRect.exactCenterY() - this.mCompassFrameCenterY);
            frameRight = screenRect.left + (int)Math.ceil(screenRect.exactCenterX() + this.mCompassFrameCenterX);
            frameBottom = screenRect.top + (int)Math.ceil(screenRect.exactCenterY() + this.mCompassFrameCenterY);
        } else {
            frameLeft = screenRect.left + (int)Math.ceil(this.mCompassCenterX * this.mScale - this.mCompassFrameCenterX);
            frameTop = screenRect.top + (int)Math.ceil(this.mCompassCenterY * this.mScale - this.mCompassFrameCenterY);
            frameRight = screenRect.left + (int)Math.ceil(this.mCompassCenterX * this.mScale + this.mCompassFrameCenterX);
            frameBottom = screenRect.top + (int)Math.ceil(this.mCompassCenterY * this.mScale + this.mCompassFrameCenterY);
        }
        this.mMapView.postInvalidateMapCoordinates(frameLeft - 2, frameTop - 2, frameRight + 2, frameBottom + 2);
    }

    public void setCompassCenter(float x, float y) {
        this.mCompassCenterX = x;
        this.mCompassCenterY = y;
    }

    public void setCompassInCenter(boolean b) {
        this.mInCenter = b;
    }

    public boolean isCompassInCenter() {
        return this.mInCenter;
    }

    public void setAzimuthOffset(float f) {
        this.mAzimuthOffset = f;
    }

    public float getAzimuthOffset() {
        return this.mAzimuthOffset;
    }

    public IOrientationProvider getOrientationProvider() {
        return this.mOrientationProvider;
    }

    public void setOrientationProvider(IOrientationProvider orientationProvider) throws RuntimeException {
        if (orientationProvider == null) {
            throw new RuntimeException("You must pass an IOrientationProvider to setOrientationProvider()");
        }
        if (this.isCompassEnabled()) {
            this.mOrientationProvider.stopOrientationProvider();
        }
        this.mOrientationProvider = orientationProvider;
    }

    protected void drawCompass(Canvas canvas, float bearing, Rect screenRect) {
        float centerY;
        float centerX;
        Projection proj = this.mMapView.getProjection();
        if (this.mInCenter) {
            Rect rect = proj.getScreenRect();
            centerX = rect.exactCenterX();
            centerY = rect.exactCenterY();
        } else {
            centerX = this.mCompassCenterX * this.mScale;
            centerY = this.mCompassCenterY * this.mScale;
        }
        this.mCompassMatrix.setTranslate(-this.mCompassFrameCenterX, -this.mCompassFrameCenterY);
        this.mCompassMatrix.postTranslate(centerX, centerY);
        proj.save(canvas, false, true);
        canvas.concat(this.mCompassMatrix);
        canvas.drawBitmap(this.mCompassFrameBitmap, 0.0f, 0.0f, this.sSmoothPaint);
        proj.restore(canvas, true);
        this.mCompassMatrix.setRotate(-bearing, this.mCompassRoseCenterX, this.mCompassRoseCenterY);
        this.mCompassMatrix.postTranslate(-this.mCompassRoseCenterX, -this.mCompassRoseCenterY);
        this.mCompassMatrix.postTranslate(centerX, centerY);
        proj.save(canvas, false, true);
        canvas.concat(this.mCompassMatrix);
        canvas.drawBitmap(this.mCompassRoseBitmap, 0.0f, 0.0f, this.sSmoothPaint);
        proj.restore(canvas, true);
    }

    @Override
    public void draw(Canvas c, Projection pProjection) {
        if (this.isCompassEnabled() && !Float.isNaN(this.mAzimuth)) {
            this.drawCompass(c, (float)this.mMode * (this.mAzimuth + this.mAzimuthOffset + (float)this.getDisplayOrientation()), pProjection.getScreenRect());
        }
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.add(0, MENU_COMPASS + pMenuIdOffset, 0, (CharSequence)pMapView.getContext().getResources().getString(R.string.compass)).setIcon(pMapView.getContext().getResources().getDrawable(R.drawable.ic_menu_compass)).setCheckable(true);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.findItem(MENU_COMPASS + pMenuIdOffset).setChecked(this.isCompassEnabled());
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId == MENU_COMPASS) {
            if (this.isCompassEnabled()) {
                this.disableCompass();
            } else {
                this.enableCompass();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onOrientationChanged(float orientation, IOrientationProvider source) {
        if (Float.isNaN(this.mAzimuth) || Math.abs(this.mAzimuth - orientation) >= this.mAzimuthPrecision) {
            this.mAzimuth = orientation;
            this.invalidateCompass();
        }
    }

    public boolean enableCompass(IOrientationProvider orientationProvider) {
        boolean success;
        this.setOrientationProvider(orientationProvider);
        this.mIsCompassEnabled = success = this.mOrientationProvider.startOrientationProvider(this);
        if (this.mMapView != null) {
            this.invalidateCompass();
        }
        return success;
    }

    public boolean enableCompass() {
        return this.enableCompass(this.mOrientationProvider);
    }

    public void disableCompass() {
        this.mIsCompassEnabled = false;
        if (this.mOrientationProvider != null) {
            this.mOrientationProvider.stopOrientationProvider();
        }
        this.mAzimuth = Float.NaN;
        if (this.mMapView != null) {
            this.invalidateCompass();
        }
    }

    public boolean isCompassEnabled() {
        return this.mIsCompassEnabled;
    }

    public float getOrientation() {
        return this.mAzimuth;
    }

    public void setPointerMode(boolean usePointArrow) {
        if (usePointArrow) {
            this.mMode = -1;
            this.createPointerPicture();
        } else {
            this.mMode = 1;
            this.createCompassRosePicture();
        }
    }

    public boolean isPointerMode() {
        return this.mMode < 0;
    }

    private Point calculatePointOnCircle(float centerX, float centerY, float radius, float degrees) {
        double dblRadians = Math.toRadians(-degrees + 90.0f);
        int intX = (int)((double)radius * Math.cos(dblRadians));
        int intY = (int)((double)radius * Math.sin(dblRadians));
        return new Point((int)centerX + intX, (int)centerY - intY);
    }

    private void drawTriangle(Canvas canvas, float x, float y, float radius, float degrees, Paint paint) {
        canvas.save();
        Point point = this.calculatePointOnCircle(x, y, radius, degrees);
        canvas.rotate(degrees, (float)point.x, (float)point.y);
        Path p = new Path();
        p.moveTo((float)point.x - 2.0f * this.mScale, (float)point.y);
        p.lineTo((float)point.x + 2.0f * this.mScale, (float)point.y);
        p.lineTo((float)point.x, (float)point.y - 5.0f * this.mScale);
        p.close();
        canvas.drawPath(p, paint);
        canvas.restore();
    }

    private int getDisplayOrientation() {
        switch (this.mDisplay.getRotation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    private void createCompassFramePicture() {
        Paint innerPaint = new Paint();
        innerPaint.setColor(-1);
        innerPaint.setAntiAlias(true);
        innerPaint.setStyle(Paint.Style.FILL);
        innerPaint.setAlpha(200);
        Paint outerPaint = new Paint();
        outerPaint.setColor(-7829368);
        outerPaint.setAntiAlias(true);
        outerPaint.setStyle(Paint.Style.STROKE);
        outerPaint.setStrokeWidth(2.0f);
        outerPaint.setAlpha(200);
        int picBorderWidthAndHeight = (int)(50.0f * this.mScale);
        int center = picBorderWidthAndHeight / 2;
        if (this.mCompassFrameBitmap != null) {
            this.mCompassFrameBitmap.recycle();
        }
        this.mCompassFrameBitmap = Bitmap.createBitmap((int)picBorderWidthAndHeight, (int)picBorderWidthAndHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.mCompassFrameBitmap);
        canvas.drawCircle((float)center, (float)center, 20.0f * this.mScale, innerPaint);
        canvas.drawCircle((float)center, (float)center, 20.0f * this.mScale, outerPaint);
        this.drawTriangle(canvas, center, center, 20.0f * this.mScale, 0.0f, outerPaint);
        this.drawTriangle(canvas, center, center, 20.0f * this.mScale, 90.0f, outerPaint);
        this.drawTriangle(canvas, center, center, 20.0f * this.mScale, 180.0f, outerPaint);
        this.drawTriangle(canvas, center, center, 20.0f * this.mScale, 270.0f, outerPaint);
    }

    private void createCompassRosePicture() {
        Paint northPaint = new Paint();
        northPaint.setColor(-6291456);
        northPaint.setAntiAlias(true);
        northPaint.setStyle(Paint.Style.FILL);
        northPaint.setAlpha(220);
        Paint southPaint = new Paint();
        southPaint.setColor(-16777216);
        southPaint.setAntiAlias(true);
        southPaint.setStyle(Paint.Style.FILL);
        southPaint.setAlpha(220);
        Paint centerPaint = new Paint();
        centerPaint.setColor(-1);
        centerPaint.setAntiAlias(true);
        centerPaint.setStyle(Paint.Style.FILL);
        centerPaint.setAlpha(220);
        int picBorderWidthAndHeight = (int)(50.0f * this.mScale);
        int center = picBorderWidthAndHeight / 2;
        if (this.mCompassRoseBitmap != null) {
            this.mCompassRoseBitmap.recycle();
        }
        this.mCompassRoseBitmap = Bitmap.createBitmap((int)picBorderWidthAndHeight, (int)picBorderWidthAndHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.mCompassRoseBitmap);
        Path pathNorth = new Path();
        pathNorth.moveTo((float)center, (float)center - 17.0f * this.mScale);
        pathNorth.lineTo((float)center + 4.0f * this.mScale, (float)center);
        pathNorth.lineTo((float)center - 4.0f * this.mScale, (float)center);
        pathNorth.lineTo((float)center, (float)center - 17.0f * this.mScale);
        pathNorth.close();
        canvas.drawPath(pathNorth, northPaint);
        Path pathSouth = new Path();
        pathSouth.moveTo((float)center, (float)center + 17.0f * this.mScale);
        pathSouth.lineTo((float)center + 4.0f * this.mScale, (float)center);
        pathSouth.lineTo((float)center - 4.0f * this.mScale, (float)center);
        pathSouth.lineTo((float)center, (float)center + 17.0f * this.mScale);
        pathSouth.close();
        canvas.drawPath(pathSouth, southPaint);
        canvas.drawCircle((float)center, (float)center, 2.0f, centerPaint);
    }

    private void createPointerPicture() {
        Paint arrowPaint = new Paint();
        arrowPaint.setColor(-16777216);
        arrowPaint.setAntiAlias(true);
        arrowPaint.setStyle(Paint.Style.FILL);
        arrowPaint.setAlpha(220);
        Paint centerPaint = new Paint();
        centerPaint.setColor(-1);
        centerPaint.setAntiAlias(true);
        centerPaint.setStyle(Paint.Style.FILL);
        centerPaint.setAlpha(220);
        int picBorderWidthAndHeight = (int)(50.0f * this.mScale);
        int center = picBorderWidthAndHeight / 2;
        if (this.mCompassRoseBitmap != null) {
            this.mCompassRoseBitmap.recycle();
        }
        this.mCompassRoseBitmap = Bitmap.createBitmap((int)picBorderWidthAndHeight, (int)picBorderWidthAndHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.mCompassRoseBitmap);
        Path pathArrow = new Path();
        pathArrow.moveTo((float)center, (float)center - 17.0f * this.mScale);
        pathArrow.lineTo((float)center + 4.0f * this.mScale, (float)center + 17.0f * this.mScale);
        pathArrow.lineTo((float)center, (float)center + 8.5f * this.mScale);
        pathArrow.lineTo((float)center - 4.0f * this.mScale, (float)center + 17.0f * this.mScale);
        pathArrow.lineTo((float)center, (float)center - 17.0f * this.mScale);
        pathArrow.close();
        canvas.drawPath(pathArrow, arrowPaint);
        canvas.drawCircle((float)center, (float)center, 2.0f, centerPaint);
    }
}

