/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.osmdroid.util.IntegerAccepter;
import org.osmdroid.util.LineBuilder;
import org.osmdroid.views.overlay.PaintList;
import org.osmdroid.views.overlay.advancedpolyline.MonochromaticPaintList;

public class LineDrawer
extends LineBuilder {
    private IntegerAccepter mIntegerAccepter;
    private Canvas mCanvas;
    private PaintList mPaintList;

    public LineDrawer(int pMaxSize) {
        super(pMaxSize);
    }

    public void setCanvas(Canvas pCanvas) {
        this.mCanvas = pCanvas;
    }

    public void setPaint(Paint pPaint) {
        this.setPaint(new MonochromaticPaintList(pPaint));
    }

    public void setPaint(PaintList pPaintList) {
        this.mPaintList = pPaintList;
    }

    public void setIntegerAccepter(IntegerAccepter pIntegerAccepter) {
        this.mIntegerAccepter = pIntegerAccepter;
    }

    @Override
    public void flush() {
        int nbSegments = this.getSize() / 4;
        if (nbSegments == 0) {
            this.additionalFlush();
            return;
        }
        float[] lines = this.getLines();
        Paint paint = this.mPaintList.getPaint();
        if (paint != null) {
            int size = LineDrawer.compact(lines, nbSegments * 4);
            if (size > 0) {
                this.mCanvas.drawLines(lines, 0, size, paint);
            }
            this.additionalFlush();
            return;
        }
        for (int i = 0; i < nbSegments * 4; i += 4) {
            float x0 = lines[i];
            float y0 = lines[i + 1];
            float x1 = lines[i + 2];
            float y1 = lines[i + 3];
            if (x0 == x1 && y0 == y1) continue;
            int segmentIndex = this.mIntegerAccepter.getValue(i / 2);
            this.mCanvas.drawLine(x0, y0, x1, y1, this.mPaintList.getPaint(segmentIndex, x0, y0, x1, y1));
        }
        this.additionalFlush();
    }

    private void additionalFlush() {
        if (this.mIntegerAccepter != null) {
            this.mIntegerAccepter.flush();
        }
    }

    private static int compact(float[] pLines, int pSize) {
        int dstIndex = 0;
        for (int srcIndex = 0; srcIndex < pSize; srcIndex += 4) {
            float x0 = pLines[srcIndex];
            float y0 = pLines[srcIndex + 1];
            float x1 = pLines[srcIndex + 2];
            float y1 = pLines[srcIndex + 3];
            if (x0 == x1 && y0 == y1) continue;
            if (srcIndex != dstIndex) {
                System.arraycopy(pLines, srcIndex, pLines, dstIndex, 4);
            }
            dstIndex += 4;
        }
        return dstIndex;
    }
}

