/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.util.concurrent.atomic.AtomicReference;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.modules.CantContinueException;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.modules.SqlTileWriter;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.Counters;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.TileSystem;

public class MapTileSqlCacheProvider
extends MapTileFileStorageProviderBase {
    private final AtomicReference<ITileSource> mTileSource = new AtomicReference();
    private SqlTileWriter mWriter;
    private static final String[] columns = new String[]{"tile", "expires"};

    @Deprecated
    public MapTileSqlCacheProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, long pMaximumCachedFileAge) {
        this(pRegisterReceiver, pTileSource);
    }

    public MapTileSqlCacheProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource) {
        super(pRegisterReceiver, Configuration.getInstance().getTileFileSystemThreads(), Configuration.getInstance().getTileFileSystemMaxQueueSize());
        this.setTileSource(pTileSource);
        this.mWriter = new SqlTileWriter();
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "SQL Cache Archive Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "sqlcache";
    }

    @Override
    public TileLoader getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    protected void onMediaMounted() {
    }

    @Override
    protected void onMediaUnmounted() {
        if (this.mWriter != null) {
            this.mWriter.onDetach();
        }
        this.mWriter = new SqlTileWriter();
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource.set(pTileSource);
    }

    @Override
    public void detach() {
        if (this.mWriter != null) {
            this.mWriter.onDetach();
        }
        this.mWriter = null;
        super.detach();
    }

    public boolean hasTile(long pMapTileIndex) {
        ITileSource tileSource = this.mTileSource.get();
        if (tileSource == null) {
            return false;
        }
        return this.mWriter.getExpirationTimestamp(tileSource, pMapTileIndex) != null;
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
        }

        @Override
        public Drawable loadTile(long pMapTileIndex) throws CantContinueException {
            ITileSource tileSource = (ITileSource)MapTileSqlCacheProvider.this.mTileSource.get();
            if (tileSource == null) {
                return null;
            }
            if (MapTileSqlCacheProvider.this.mWriter != null) {
                try {
                    Drawable result = MapTileSqlCacheProvider.this.mWriter.loadTile(tileSource, pMapTileIndex);
                    if (result == null) {
                        ++Counters.fileCacheMiss;
                    } else {
                        ++Counters.fileCacheHit;
                    }
                    return result;
                }
                catch (BitmapTileSourceBase.LowMemoryException e) {
                    Log.w((String)"OsmDroid", (String)("LowMemoryException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                    ++Counters.fileCacheOOM;
                    throw new CantContinueException(e);
                }
                catch (Throwable e) {
                    Log.e((String)"OsmDroid", (String)"Error loading tile", (Throwable)e);
                    return null;
                }
            }
            Log.d((String)"OsmDroid", (String)"TileLoader failed to load tile due to mWriter being null (map shutdown?)");
            return null;
        }
    }
}

