/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.drawing;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Looper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.TileStates;
import org.osmdroid.util.RectL;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.drawing.MapSnapshotHandler;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.TilesOverlay;

public class MapSnapshot
implements Runnable {
    public static final int INCLUDE_FLAG_UPTODATE = 1;
    public static final int INCLUDE_FLAG_EXPIRED = 2;
    public static final int INCLUDE_FLAG_SCALED = 4;
    public static final int INCLUDE_FLAG_NOTFOUND = 8;
    public static final int INCLUDE_FLAGS_ALL = 15;
    private final RectL mViewPort = new RectL();
    private final int mIncludeFlags;
    private Projection mProjection;
    private MapSnapshotHandler mHandler;
    private MapSnapshotable mMapSnapshotable;
    private MapTileProviderBase mTileProvider;
    private TilesOverlay mTilesOverlay;
    private List<Overlay> mOverlays;
    private Status mStatus = Status.NOTHING;
    private Bitmap mBitmap;
    private boolean mIsDetached;
    private boolean mOneMoreTime;
    private boolean mCurrentlyRunning;
    private boolean mAlreadyFinished;

    public static boolean isUIThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public MapSnapshot(MapSnapshotable pMapSnapshotable, int pIncludeFlags, MapView pMapView) {
        this(pMapSnapshotable, pIncludeFlags, pMapView.getTileProvider(), pMapView.getOverlays(), pMapView.getProjection());
    }

    public MapSnapshot(MapSnapshotable pMapSnapshotable, int pIncludeFlags, MapTileProviderBase pTileProvider, List<Overlay> pOverlays, Projection pProjection) {
        this.mMapSnapshotable = pMapSnapshotable;
        this.mIncludeFlags = pIncludeFlags;
        this.mTileProvider = pTileProvider;
        this.mOverlays = pOverlays;
        this.mProjection = pProjection;
        this.mProjection.getMercatorViewPort(this.mViewPort);
        this.mTilesOverlay = new TilesOverlay(this.mTileProvider, null);
        this.mTilesOverlay.setHorizontalWrapEnabled(this.mProjection.isHorizontalWrapEnabled());
        this.mTilesOverlay.setVerticalWrapEnabled(this.mProjection.isVerticalWrapEnabled());
        this.mHandler = new MapSnapshotHandler(this);
        this.mTileProvider.getTileRequestCompleteHandlers().add(this.mHandler);
    }

    @Override
    public void run() {
        this.mStatus = Status.STARTED;
        this.refreshASAP();
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public boolean save(File pFile) {
        return MapSnapshot.save(this.mBitmap, pFile);
    }

    public void onDetach() {
        this.mIsDetached = true;
        this.mProjection = null;
        this.mTileProvider.getTileRequestCompleteHandlers().remove((Object)this.mHandler);
        this.mTileProvider.detach();
        this.mTileProvider = null;
        this.mHandler.destroy();
        this.mHandler = null;
        this.mMapSnapshotable = null;
        this.mTilesOverlay = null;
        this.mOverlays = null;
        this.mBitmap = null;
    }

    private void draw() {
        this.mBitmap = Bitmap.createBitmap((int)this.mProjection.getWidth(), (int)this.mProjection.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.mBitmap);
        this.mProjection.save(canvas, true, false);
        this.mTilesOverlay.drawTiles(canvas, this.mProjection, this.mProjection.getZoomLevel(), this.mViewPort);
        if (this.mOverlays != null) {
            for (Overlay overlay : this.mOverlays) {
                if (overlay == null || !overlay.isEnabled()) continue;
                overlay.draw(canvas, this.mProjection);
            }
        }
        this.mProjection.restore(canvas, false);
    }

    private void refresh() {
        if (!this.refreshCheckStart()) {
            return;
        }
        TileStates tileStates = this.mTilesOverlay.getTileStates();
        do {
            this.mTilesOverlay.drawTiles(null, this.mProjection, this.mProjection.getZoomLevel(), this.mViewPort);
            boolean ready = true;
            if (this.mIncludeFlags != 0 && this.mIncludeFlags != 15) {
                if (ready && (this.mIncludeFlags & 1) == 0 && tileStates.getUpToDate() != 0) {
                    ready = false;
                }
                if (ready && (this.mIncludeFlags & 2) == 0 && tileStates.getExpired() != 0) {
                    ready = false;
                }
                if (ready && (this.mIncludeFlags & 4) == 0 && tileStates.getScaled() != 0) {
                    ready = false;
                }
                if (ready && (this.mIncludeFlags & 8) == 0 && tileStates.getNotFound() != 0) {
                    ready = false;
                }
            }
            if (!ready) continue;
            if (this.mStatus == Status.CANVAS_OK || this.mStatus == Status.PAINTING) {
                return;
            }
            if (!this.refreshCheckFinish()) {
                return;
            }
            this.mStatus = Status.PAINTING;
            if (this.mIsDetached) {
                return;
            }
            this.draw();
            this.mStatus = Status.CANVAS_OK;
            MapSnapshotable mapSnapshotable = this.mMapSnapshotable;
            if (mapSnapshotable == null) continue;
            mapSnapshotable.callback(this);
        } while (this.refreshCheckEnd());
    }

    private synchronized boolean refreshCheckStart() {
        if (this.mIsDetached) {
            return false;
        }
        if (this.mAlreadyFinished) {
            return false;
        }
        if (!this.mOneMoreTime) {
            return false;
        }
        if (this.mCurrentlyRunning) {
            return false;
        }
        this.mOneMoreTime = false;
        this.mCurrentlyRunning = true;
        return true;
    }

    private synchronized boolean refreshCheckEnd() {
        if (this.mIsDetached) {
            return false;
        }
        if (this.mAlreadyFinished) {
            return false;
        }
        if (!this.mOneMoreTime) {
            this.mCurrentlyRunning = false;
            return false;
        }
        this.mOneMoreTime = false;
        return true;
    }

    private synchronized boolean refreshCheckFinish() {
        boolean result = !this.mAlreadyFinished;
        this.mAlreadyFinished = true;
        return result;
    }

    private synchronized boolean refreshAgain() {
        this.mOneMoreTime = true;
        return !this.mCurrentlyRunning;
    }

    public void refreshASAP() {
        if (this.refreshAgain()) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean save(Bitmap pBitmap, File pFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(pFile.getAbsolutePath());
            pBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static interface MapSnapshotable {
        public void callback(MapSnapshot var1);
    }

    public static enum Status {
        NOTHING,
        STARTED,
        TILES_OK,
        PAINTING,
        CANVAS_OK;

    }
}

