/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.gestures;

import android.annotation.SuppressLint;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

@SuppressLint(value={"NewApi"})
public class OneFingerZoomOverlay
extends Overlay {
    private boolean mIsDoubleClick = false;
    private float mLastY;

    @Override
    public boolean onDoubleTapEvent(MotionEvent event, MapView mapView) {
        if (event.getAction() == 0) {
            this.mIsDoubleClick = true;
        } else if (event.getAction() == 1) {
            this.mIsDoubleClick = false;
        }
        return super.onDoubleTapEvent(event, mapView);
    }

    @Override
    public boolean onDoubleTap(MotionEvent event, MapView mapView) {
        return true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (this.mIsDoubleClick) {
            VelocityTracker velocityTracker = VelocityTracker.obtain();
            velocityTracker.addMovement(event);
            velocityTracker.computeCurrentVelocity(100, 1000.0f);
            float velocityY = Math.abs(velocityTracker.getYVelocity()) / 1000.0f;
            if (this.mLastY > event.getY()) {
                mapView.getController().setZoom(mapView.getZoomLevelDouble() - (double)velocityY);
            } else {
                mapView.getController().setZoom(mapView.getZoomLevelDouble() + (double)velocityY);
            }
            this.mLastY = event.getY();
            velocityTracker.recycle();
        }
        return super.onTouchEvent(event, mapView);
    }
}

