/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.widget.Toast;
import java.io.File;
import org.osmdroid.config.Configuration;
import org.osmdroid.library.R;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.TileStates;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.RectL;
import org.osmdroid.util.TileLooper;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.drawing.MapSnapshot;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;

public class TilesOverlay
extends Overlay
implements IOverlayMenuProvider {
    public static final int MENU_MAP_MODE = TilesOverlay.getSafeMenuId();
    public static final int MENU_TILE_SOURCE_STARTING_ID = TilesOverlay.getSafeMenuIdSequence(TileSourceFactory.getTileSources().size());
    public static final int MENU_OFFLINE = TilesOverlay.getSafeMenuId();
    public static final int MENU_SNAPSHOT = TilesOverlay.getSafeMenuId();
    public static final int MENU_STATES = TilesOverlay.getSafeMenuId();
    private Context ctx;
    protected final MapTileProviderBase mTileProvider;
    protected Drawable userSelectedLoadingDrawable = null;
    protected final Paint mDebugPaint = new Paint();
    private final Rect mTileRect = new Rect();
    protected final RectL mViewPort = new RectL();
    protected Projection mProjection;
    private boolean mOptionsMenuEnabled = true;
    private BitmapDrawable mLoadingTile = null;
    private int mLoadingBackgroundColor = Color.rgb((int)216, (int)208, (int)208);
    private int mLoadingLineColor = Color.rgb((int)200, (int)192, (int)192);
    private boolean horizontalWrapEnabled = true;
    private boolean verticalWrapEnabled = true;
    private ColorFilter currentColorFilter = null;
    static final float[] negate = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    public static final ColorFilter INVERT_COLORS = new ColorMatrixColorFilter(negate);
    private final Rect mProtectedTiles = new Rect();
    private final TileStates mTileStates = new TileStates();
    private final OverlayTileLooper mTileLooper = new OverlayTileLooper();
    private final Rect mIntersectionRect = new Rect();
    private Rect mCanvasRect;

    public TilesOverlay(MapTileProviderBase aTileProvider, Context aContext) {
        this(aTileProvider, aContext, true, true);
    }

    public TilesOverlay(MapTileProviderBase aTileProvider, Context aContext, boolean horizontalWrapEnabled, boolean verticalWrapEnabled) {
        this.ctx = aContext;
        if (aTileProvider == null) {
            throw new IllegalArgumentException("You must pass a valid tile provider to the tiles overlay.");
        }
        this.mTileProvider = aTileProvider;
        this.setHorizontalWrapEnabled(horizontalWrapEnabled);
        this.setVerticalWrapEnabled(verticalWrapEnabled);
    }

    public void setLoadingDrawable(Drawable drawable2) {
        this.userSelectedLoadingDrawable = drawable2;
    }

    @Override
    public void onDetach(MapView pMapView) {
        this.mTileProvider.detach();
        this.ctx = null;
        BitmapPool.getInstance().asyncRecycle((Drawable)this.mLoadingTile);
        this.mLoadingTile = null;
        BitmapPool.getInstance().asyncRecycle(this.userSelectedLoadingDrawable);
        this.userSelectedLoadingDrawable = null;
    }

    public int getMinimumZoomLevel() {
        return this.mTileProvider.getMinimumZoomLevel();
    }

    public int getMaximumZoomLevel() {
        return this.mTileProvider.getMaximumZoomLevel();
    }

    public boolean useDataConnection() {
        return this.mTileProvider.useDataConnection();
    }

    public void setUseDataConnection(boolean aMode) {
        this.mTileProvider.setUseDataConnection(aMode);
    }

    public void protectDisplayedTilesForCache(Canvas pCanvas, Projection pProjection) {
        if (!this.setViewPort(pCanvas, pProjection)) {
            return;
        }
        TileSystem.getTileFromMercator(this.mViewPort, TileSystem.getTileSize(this.mProjection.getZoomLevel()), this.mProtectedTiles);
        int tileZoomLevel = TileSystem.getInputTileZoomLevel(this.mProjection.getZoomLevel());
        this.mTileProvider.getTileCache().getMapTileArea().set(tileZoomLevel, this.mProtectedTiles);
        this.mTileProvider.getTileCache().maintenance();
    }

    protected boolean setViewPort(Canvas pCanvas, Projection pProjection) {
        this.setProjection(pProjection);
        this.getProjection().getMercatorViewPort(this.mViewPort);
        return true;
    }

    @Override
    public void draw(Canvas c, Projection pProjection) {
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)"onDraw");
        }
        if (!this.setViewPort(c, pProjection)) {
            return;
        }
        this.drawTiles(c, this.getProjection(), this.getProjection().getZoomLevel(), this.mViewPort);
    }

    public void drawTiles(Canvas c, Projection projection, double zoomLevel, RectL viewPort) {
        this.mProjection = projection;
        this.mTileLooper.loop(zoomLevel, viewPort, c);
    }

    protected void setCanvasRect(Rect pCanvasRect) {
        this.mCanvasRect = pCanvasRect;
    }

    protected Rect getCanvasRect() {
        return this.mCanvasRect;
    }

    protected void setProjection(Projection pProjection) {
        this.mProjection = pProjection;
    }

    protected Projection getProjection() {
        return this.mProjection;
    }

    protected void onTileReadyToDraw(Canvas c, Drawable currentMapTile, Rect tileRect) {
        currentMapTile.setColorFilter(this.currentColorFilter);
        currentMapTile.setBounds(tileRect.left, tileRect.top, tileRect.right, tileRect.bottom);
        Rect canvasRect = this.getCanvasRect();
        if (canvasRect == null) {
            currentMapTile.draw(c);
            return;
        }
        if (!this.mIntersectionRect.setIntersect(c.getClipBounds(), canvasRect)) {
            return;
        }
        c.save();
        c.clipRect(this.mIntersectionRect);
        currentMapTile.draw(c);
        c.restore();
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        SubMenu mapMenu = pMenu.addSubMenu(0, 0, 0, R.string.map_mode).setIcon(R.drawable.ic_menu_mapmode);
        for (int a = 0; a < TileSourceFactory.getTileSources().size(); ++a) {
            ITileSource tileSource = TileSourceFactory.getTileSources().get(a);
            mapMenu.add(MENU_MAP_MODE + pMenuIdOffset, MENU_TILE_SOURCE_STARTING_ID + a + pMenuIdOffset, 0, (CharSequence)tileSource.name());
        }
        mapMenu.setGroupCheckable(MENU_MAP_MODE + pMenuIdOffset, true, true);
        if (this.ctx != null) {
            String title = this.ctx.getString(pMapView.useDataConnection() ? R.string.set_mode_offline : R.string.set_mode_online);
            Drawable icon = this.ctx.getResources().getDrawable(R.drawable.ic_menu_offline);
            pMenu.add(0, MENU_OFFLINE + pMenuIdOffset, 0, (CharSequence)title).setIcon(icon);
            pMenu.add(0, MENU_SNAPSHOT + pMenuIdOffset, 0, R.string.snapshot);
            pMenu.add(0, MENU_STATES + pMenuIdOffset, 0, R.string.states);
        }
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        int index = TileSourceFactory.getTileSources().indexOf(pMapView.getTileProvider().getTileSource());
        if (index >= 0) {
            pMenu.findItem(MENU_TILE_SOURCE_STARTING_ID + index + pMenuIdOffset).setChecked(true);
        }
        pMenu.findItem(MENU_OFFLINE + pMenuIdOffset).setTitle(pMapView.useDataConnection() ? R.string.set_mode_offline : R.string.set_mode_online);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId >= MENU_TILE_SOURCE_STARTING_ID && menuId < MENU_TILE_SOURCE_STARTING_ID + TileSourceFactory.getTileSources().size()) {
            pMapView.setTileSource(TileSourceFactory.getTileSources().get(menuId - MENU_TILE_SOURCE_STARTING_ID));
            return true;
        }
        if (menuId == MENU_OFFLINE) {
            boolean useDataConnection = !pMapView.useDataConnection();
            pMapView.setUseDataConnection(useDataConnection);
            return true;
        }
        if (menuId == MENU_STATES) {
            Toast.makeText((Context)pMapView.getContext(), (CharSequence)this.mTileStates.toString(), (int)0).show();
            return true;
        }
        if (menuId == MENU_SNAPSHOT) {
            MapSnapshot mapSnapshot = new MapSnapshot(new MapSnapshot.MapSnapshotable(){

                @Override
                public void callback(MapSnapshot pMapSketch) {
                    if (pMapSketch.getStatus() != MapSnapshot.Status.CANVAS_OK) {
                        return;
                    }
                    File file = new File(Configuration.getInstance().getOsmdroidBasePath(), "snapshot.png");
                    pMapSketch.save(file);
                    pMapSketch.onDetach();
                }
            }, 1, pMapView);
            Thread t = new Thread(mapSnapshot);
            t.setName("TilesOverlaySnapShotThread");
            t.start();
            return true;
        }
        return false;
    }

    public int getLoadingBackgroundColor() {
        return this.mLoadingBackgroundColor;
    }

    public void setLoadingBackgroundColor(int pLoadingBackgroundColor) {
        if (this.mLoadingBackgroundColor != pLoadingBackgroundColor) {
            this.mLoadingBackgroundColor = pLoadingBackgroundColor;
            this.clearLoadingTile();
        }
    }

    public int getLoadingLineColor() {
        return this.mLoadingLineColor;
    }

    public void setLoadingLineColor(int pLoadingLineColor) {
        if (this.mLoadingLineColor != pLoadingLineColor) {
            this.mLoadingLineColor = pLoadingLineColor;
            this.clearLoadingTile();
        }
    }

    private Drawable getLoadingTile() {
        if (this.userSelectedLoadingDrawable != null) {
            return this.userSelectedLoadingDrawable;
        }
        if (this.mLoadingTile == null && this.mLoadingBackgroundColor != 0) {
            try {
                int tileSize = this.mTileProvider.getTileSource() != null ? this.mTileProvider.getTileSource().getTileSizePixels() : 256;
                Bitmap bitmap = Bitmap.createBitmap((int)tileSize, (int)tileSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                Paint paint = new Paint();
                canvas.drawColor(this.mLoadingBackgroundColor);
                paint.setColor(this.mLoadingLineColor);
                paint.setStrokeWidth(0.0f);
                int lineSize = tileSize / 16;
                for (int a = 0; a < tileSize; a += lineSize) {
                    canvas.drawLine(0.0f, (float)a, (float)tileSize, (float)a, paint);
                    canvas.drawLine((float)a, 0.0f, (float)a, (float)tileSize, paint);
                }
                this.mLoadingTile = new BitmapDrawable(bitmap);
            }
            catch (OutOfMemoryError e) {
                Log.e((String)"OsmDroid", (String)"OutOfMemoryError getting loading tile");
                System.gc();
            }
            catch (NullPointerException e) {
                Log.e((String)"OsmDroid", (String)"NullPointerException getting loading tile");
                System.gc();
            }
        }
        return this.mLoadingTile;
    }

    private void clearLoadingTile() {
        BitmapDrawable bitmapDrawable = this.mLoadingTile;
        this.mLoadingTile = null;
        BitmapPool.getInstance().asyncRecycle((Drawable)bitmapDrawable);
    }

    public void setColorFilter(ColorFilter filter) {
        this.currentColorFilter = filter;
    }

    public boolean isHorizontalWrapEnabled() {
        return this.horizontalWrapEnabled;
    }

    public void setHorizontalWrapEnabled(boolean horizontalWrapEnabled) {
        this.horizontalWrapEnabled = horizontalWrapEnabled;
        this.mTileLooper.setHorizontalWrapEnabled(horizontalWrapEnabled);
    }

    public boolean isVerticalWrapEnabled() {
        return this.verticalWrapEnabled;
    }

    public void setVerticalWrapEnabled(boolean verticalWrapEnabled) {
        this.verticalWrapEnabled = verticalWrapEnabled;
        this.mTileLooper.setVerticalWrapEnabled(verticalWrapEnabled);
    }

    public TileStates getTileStates() {
        return this.mTileStates;
    }

    protected class OverlayTileLooper
    extends TileLooper {
        private Canvas mCanvas;

        public OverlayTileLooper() {
        }

        public OverlayTileLooper(boolean horizontalWrapEnabled, boolean verticalWrapEnabled) {
            super(horizontalWrapEnabled, verticalWrapEnabled);
        }

        public void loop(double pZoomLevel, RectL pViewPort, Canvas pCanvas) {
            this.mCanvas = pCanvas;
            this.loop(pZoomLevel, pViewPort);
        }

        @Override
        public void initialiseLoop() {
            int width = this.mTiles.right - this.mTiles.left + 1;
            int height = this.mTiles.bottom - this.mTiles.top + 1;
            int numNeeded = height * width;
            TilesOverlay.this.mTileProvider.ensureCapacity(numNeeded + Configuration.getInstance().getCacheMapTileOvershoot());
            TilesOverlay.this.mTileStates.initialiseLoop();
            super.initialiseLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTile(long pMapTileIndex, int pX, int pY) {
            ReusableBitmapDrawable reusableBitmapDrawable;
            Drawable currentMapTile = TilesOverlay.this.mTileProvider.getMapTile(pMapTileIndex);
            TilesOverlay.this.mTileStates.handleTile(currentMapTile);
            if (this.mCanvas == null) {
                return;
            }
            boolean isReusable = currentMapTile instanceof ReusableBitmapDrawable;
            ReusableBitmapDrawable reusableBitmapDrawable2 = reusableBitmapDrawable = isReusable ? (ReusableBitmapDrawable)currentMapTile : null;
            if (currentMapTile == null) {
                currentMapTile = TilesOverlay.this.getLoadingTile();
            }
            if (currentMapTile != null) {
                TilesOverlay.this.mProjection.getPixelFromTile(pX, pY, TilesOverlay.this.mTileRect);
                if (isReusable) {
                    reusableBitmapDrawable.beginUsingDrawable();
                }
                try {
                    if (isReusable && !reusableBitmapDrawable.isBitmapValid()) {
                        currentMapTile = TilesOverlay.this.getLoadingTile();
                        isReusable = false;
                    }
                    TilesOverlay.this.onTileReadyToDraw(this.mCanvas, currentMapTile, TilesOverlay.this.mTileRect);
                }
                finally {
                    if (isReusable) {
                        reusableBitmapDrawable.finishUsingDrawable();
                    }
                }
            }
            if (Configuration.getInstance().isDebugTileProviders()) {
                TilesOverlay.this.mProjection.getPixelFromTile(pX, pY, TilesOverlay.this.mTileRect);
                this.mCanvas.drawText(MapTileIndex.toString(pMapTileIndex), (float)(((TilesOverlay)TilesOverlay.this).mTileRect.left + 1), (float)((TilesOverlay)TilesOverlay.this).mTileRect.top + TilesOverlay.this.mDebugPaint.getTextSize(), TilesOverlay.this.mDebugPaint);
                this.mCanvas.drawLine((float)((TilesOverlay)TilesOverlay.this).mTileRect.left, (float)((TilesOverlay)TilesOverlay.this).mTileRect.top, (float)((TilesOverlay)TilesOverlay.this).mTileRect.right, (float)((TilesOverlay)TilesOverlay.this).mTileRect.top, TilesOverlay.this.mDebugPaint);
                this.mCanvas.drawLine((float)((TilesOverlay)TilesOverlay.this).mTileRect.left, (float)((TilesOverlay)TilesOverlay.this).mTileRect.top, (float)((TilesOverlay)TilesOverlay.this).mTileRect.left, (float)((TilesOverlay)TilesOverlay.this).mTileRect.bottom, TilesOverlay.this.mDebugPaint);
            }
        }

        @Override
        public void finaliseLoop() {
            TilesOverlay.this.mTileStates.finaliseLoop();
        }
    }
}

