/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.PointL;
import org.osmdroid.views.util.constants.MathConstants;

public class MyMath
implements MathConstants {
    private MyMath() {
    }

    public static double gudermannInverse(double aLatitude) {
        return Math.log(Math.tan(0.7853981633974483 + Math.PI / 180 * aLatitude / 2.0));
    }

    public static double gudermann(double y) {
        return 57.29577951308232 * Math.atan(Math.sinh(y));
    }

    public static int mod(int number, int modulus) {
        if (number > 0) {
            return number % modulus;
        }
        while (number < 0) {
            number += modulus;
        }
        return number;
    }

    public static long floorToLong(double pValue) {
        long result = (long)pValue;
        if ((double)result <= pValue) {
            return result;
        }
        return result - 1L;
    }

    public static int floorToInt(double pValue) {
        int result = (int)pValue;
        if ((double)result <= pValue) {
            return result;
        }
        return result - 1;
    }

    public static int getNextSquareNumberAbove(float factor) {
        int out = 0;
        int cur = 1;
        int i = 1;
        while (!((float)cur > factor)) {
            out = i++;
            cur *= 2;
        }
        return out;
    }

    public static double getAngleDifference(double pStart, double pEnd, Boolean pClockwise) {
        double difference = MyMath.cleanPositiveAngle(pEnd - pStart);
        if (pClockwise != null) {
            if (pClockwise.booleanValue()) {
                return difference;
            }
            return difference - 360.0;
        }
        if (difference < 180.0) {
            return difference;
        }
        return difference - 360.0;
    }

    public static double cleanPositiveAngle(double pAngle) {
        while (pAngle < 0.0) {
            pAngle += 360.0;
        }
        while (pAngle >= 360.0) {
            pAngle -= 360.0;
        }
        return pAngle;
    }

    public static double computeAngle(long pX1, long pY1, long pX2, long pY2) {
        return Math.atan2(pY2 - pY1, pX2 - pX1);
    }

    public static void computeCirclePoint(long pCenterX, long pCenterY, double pRadius, double pAngle, PointL pOutput) {
        pOutput.x = pCenterX + (long)(pRadius * Math.cos(pAngle));
        pOutput.y = pCenterY + (long)(pRadius * Math.sin(pAngle));
    }
}

