/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.MapTileIndex;

public class ZipFileArchive
implements IArchiveFile {
    protected ZipFile mZipFile;
    private boolean mIgnoreTileSource = false;

    public ZipFileArchive() {
    }

    private ZipFileArchive(ZipFile pZipFile) {
        this.mZipFile = pZipFile;
    }

    public static ZipFileArchive getZipFileArchive(File pFile) throws ZipException, IOException {
        return new ZipFileArchive(new ZipFile(pFile));
    }

    @Override
    public void setIgnoreTileSource(boolean pIgnoreTileSource) {
        this.mIgnoreTileSource = pIgnoreTileSource;
    }

    @Override
    public void init(File pFile) throws Exception {
        this.mZipFile = new ZipFile(pFile);
    }

    @Override
    public InputStream getInputStream(ITileSource pTileSource, long pMapTileIndex) {
        try {
            if (!this.mIgnoreTileSource) {
                String path = pTileSource.getTileRelativeFilenameString(pMapTileIndex);
                ZipEntry entry = this.mZipFile.getEntry(path);
                if (entry != null) {
                    return this.mZipFile.getInputStream(entry);
                }
            } else {
                Enumeration<? extends ZipEntry> entries = this.mZipFile.entries();
                while (entries.hasMoreElements()) {
                    String path;
                    ZipEntry entry;
                    ZipEntry nextElement = entries.nextElement();
                    String str = nextElement.getName();
                    if (!str.contains("/") || (entry = this.mZipFile.getEntry(path = this.getTileRelativeFilenameString(pMapTileIndex, str.split("/")[0]))) == null) continue;
                    return this.mZipFile.getInputStream(entry);
                }
            }
        }
        catch (IOException e) {
            Log.w((String)"OsmDroid", (String)("Error getting zip stream: " + MapTileIndex.toString(pMapTileIndex)), (Throwable)e);
        }
        return null;
    }

    private String getTileRelativeFilenameString(long pMapTileIndex, String pathBase) {
        StringBuilder sb = new StringBuilder();
        sb.append(pathBase);
        sb.append('/');
        sb.append(MapTileIndex.getZoom(pMapTileIndex));
        sb.append('/');
        sb.append(MapTileIndex.getX(pMapTileIndex));
        sb.append('/');
        sb.append(MapTileIndex.getY(pMapTileIndex));
        sb.append(".png");
        return sb.toString();
    }

    @Override
    public Set<String> getTileSources() {
        HashSet<String> ret = new HashSet<String>();
        try {
            Enumeration<? extends ZipEntry> entries = this.mZipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextElement = entries.nextElement();
                String str = nextElement.getName();
                if (!str.contains("/")) continue;
                ret.add(str.split("/")[0]);
            }
        }
        catch (Exception e) {
            Log.w((String)"OsmDroid", (String)"Error getting tile sources: ", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void close() {
        try {
            this.mZipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "ZipFileArchive [mZipFile=" + this.mZipFile.getName() + "]";
    }
}

