/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.milestones;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.osmdroid.views.overlay.LineDrawer;
import org.osmdroid.views.overlay.milestones.MilestoneDisplayer;
import org.osmdroid.views.overlay.milestones.MilestoneStep;

public class MilestoneLineDisplayer
extends MilestoneDisplayer {
    private boolean mFirst = true;
    private long mPreviousX;
    private long mPreviousY;
    private final LineDrawer mLineDrawer = new LineDrawer(256){

        @Override
        public void flush() {
            super.flush();
            MilestoneLineDisplayer.this.mFirst = true;
        }
    };

    public MilestoneLineDisplayer(Paint pPaint) {
        super(0.0, false);
        this.mLineDrawer.setPaint(pPaint);
    }

    @Override
    public void drawBegin(Canvas pCanvas) {
        this.mLineDrawer.init();
        this.mLineDrawer.setCanvas(pCanvas);
        this.mFirst = true;
    }

    @Override
    public void draw(Canvas pCanvas, MilestoneStep pStep) {
        long nextX = pStep.getX();
        long nextY = pStep.getY();
        if (this.mFirst) {
            this.mFirst = false;
        } else if (this.mPreviousX != nextX || this.mPreviousY != nextY) {
            this.mLineDrawer.add(this.mPreviousX, this.mPreviousY);
            this.mLineDrawer.add(nextX, nextY);
        }
        this.mPreviousX = nextX;
        this.mPreviousY = nextY;
    }

    @Override
    public void drawEnd(Canvas pCanvas) {
        this.mLineDrawer.end();
    }

    @Override
    protected void draw(Canvas pCanvas, Object pParameter) {
    }
}

