/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.advancedpolyline;

import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import org.osmdroid.views.overlay.PaintList;
import org.osmdroid.views.overlay.advancedpolyline.ColorMapping;

public class PolychromaticPaintList
implements PaintList {
    private final Paint mPaint;
    private final ColorMapping mColorMapping;
    private final boolean mUseGradient;

    public PolychromaticPaintList(Paint pPaint, ColorMapping pColorMapping, boolean pUseGradient) {
        this.mPaint = pPaint;
        this.mColorMapping = pColorMapping;
        this.mUseGradient = pUseGradient;
    }

    @Override
    public Paint getPaint() {
        return null;
    }

    @Override
    public Paint getPaint(int pIndex, float pX0, float pY0, float pX1, float pY1) {
        int startColor = this.mColorMapping.getColorForIndex(pIndex);
        if (this.mUseGradient) {
            int endColor = this.mColorMapping.getColorForIndex(pIndex + 1);
            if (startColor != endColor) {
                LinearGradient shader = new LinearGradient(pX0, pY0, pX1, pY1, startColor, endColor, Shader.TileMode.CLAMP);
                this.mPaint.setShader((Shader)shader);
                return this.mPaint;
            }
            this.mPaint.setShader(null);
        }
        this.mPaint.setColor(startColor);
        return this.mPaint;
    }
}

