/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.advancedpolyline;

import java.util.Map;
import java.util.SortedMap;
import org.osmdroid.views.overlay.advancedpolyline.ColorMappingForScalar;

public class ColorMappingRanges
extends ColorMappingForScalar {
    private final SortedMap<Float, Integer> mColorRanges;
    private final boolean mStrictComparison;

    public ColorMappingRanges(SortedMap<Float, Integer> pColorArray, boolean pStrictComparison) {
        this.mColorRanges = pColorArray;
        this.mStrictComparison = pStrictComparison;
    }

    @Override
    protected int computeColor(float pScalar) {
        int lastArrayIndexFromLoop = 0;
        for (Map.Entry<Float, Integer> entry : this.mColorRanges.entrySet()) {
            if (this.mStrictComparison ? pScalar < entry.getKey().floatValue() : pScalar <= entry.getKey().floatValue()) {
                return entry.getValue();
            }
            ++lastArrayIndexFromLoop;
        }
        if (lastArrayIndexFromLoop == this.mColorRanges.size()) {
            return (Integer)this.mColorRanges.get(this.mColorRanges.lastKey());
        }
        return 0;
    }
}

