/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import java.util.Locale;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.constants.GeoConstants;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.ScaleBarOverlay;

public class ScaleDiskOverlay
extends Overlay {
    private final Point mPixelCenter = new Point();
    private final Rect mLabelRect = new Rect();
    private final GeoPoint mGeoCenter;
    private final double mMeters;
    private final String mLabel;
    private Paint mCirclePaint1;
    private Paint mCirclePaint2;
    private Paint mTextPaint;
    private Integer mLabelOffsetTop;
    private Integer mLabelOffsetBottom;
    private Integer mLabelOffsetLeft;
    private Integer mLabelOffsetRight;
    private int mDisplaySizeMin;
    private int mDisplaySizeMax;

    public ScaleDiskOverlay(Context pContext, GeoPoint pGeoCenter, int pValue, GeoConstants.UnitOfMeasure pUnitOfMeasure) {
        this.mGeoCenter = pGeoCenter;
        this.mMeters = (double)pValue * pUnitOfMeasure.getConversionFactorToMeters();
        this.mLabel = ScaleBarOverlay.getScaleString(pContext, String.format(Locale.getDefault(), "%d", pValue), pUnitOfMeasure);
    }

    public void setCirclePaint1(Paint pPaint) {
        this.mCirclePaint1 = pPaint;
    }

    public void setCirclePaint2(Paint pPaint) {
        this.mCirclePaint2 = pPaint;
    }

    public void setTextPaint(Paint pPaint) {
        this.mTextPaint = pPaint;
    }

    public void setLabelOffsetTop(Integer pValue) {
        this.mLabelOffsetTop = pValue;
    }

    public void setLabelOffsetBottom(Integer pValue) {
        this.mLabelOffsetBottom = pValue;
    }

    public void setLabelOffsetLeft(Integer pValue) {
        this.mLabelOffsetLeft = pValue;
    }

    public void setLabelOffsetRight(Integer pValue) {
        this.mLabelOffsetRight = pValue;
    }

    public void setDisplaySizeMin(int pValue) {
        this.mDisplaySizeMin = pValue;
    }

    public void setDisplaySizeMax(int pValue) {
        this.mDisplaySizeMax = pValue;
    }

    @Override
    public void draw(Canvas pCanvas, Projection pProjection) {
        pProjection.toPixels(this.mGeoCenter, this.mPixelCenter);
        int x = this.mPixelCenter.x;
        int y = this.mPixelCenter.y;
        int radius = (int)pProjection.metersToPixels((float)this.mMeters, this.mGeoCenter.getLatitude(), pProjection.getZoomLevel());
        if (this.mDisplaySizeMin > 0 && 2 * radius < this.mDisplaySizeMin) {
            return;
        }
        if (this.mDisplaySizeMax > 0 && 2 * radius > this.mDisplaySizeMax) {
            return;
        }
        if (this.mCirclePaint1 != null) {
            pCanvas.drawCircle((float)x, (float)y, (float)radius, this.mCirclePaint1);
        }
        if (this.mCirclePaint2 != null) {
            pCanvas.drawCircle((float)x, (float)y, (float)radius, this.mCirclePaint2);
        }
        if (this.mTextPaint != null) {
            int offsetY;
            int offsetX;
            this.mTextPaint.getTextBounds(this.mLabel, 0, this.mLabel.length(), this.mLabelRect);
            if (this.mLabelOffsetTop != null) {
                offsetX = this.getOffsetX();
                offsetY = -radius + this.getOffsetY(this.mLabelOffsetTop);
                pCanvas.drawText(this.mLabel, (float)(x + offsetX), (float)(y + offsetY), this.mTextPaint);
            }
            if (this.mLabelOffsetLeft != null) {
                offsetX = -radius + this.getOffsetX(this.mLabelOffsetLeft);
                offsetY = this.getOffsetY();
                pCanvas.drawText(this.mLabel, (float)(x + offsetX), (float)(y + offsetY), this.mTextPaint);
            }
            if (this.mLabelOffsetBottom != null) {
                offsetX = this.getOffsetX();
                offsetY = radius + this.getOffsetY(this.mLabelOffsetBottom);
                pCanvas.drawText(this.mLabel, (float)(x + offsetX), (float)(y + offsetY), this.mTextPaint);
            }
            if (this.mLabelOffsetRight != null) {
                offsetX = radius + this.getOffsetX(this.mLabelOffsetRight);
                offsetY = this.getOffsetY();
                pCanvas.drawText(this.mLabel, (float)(x + offsetX), (float)(y + offsetY), this.mTextPaint);
            }
        }
    }

    private int getOffsetX() {
        return -this.mLabelRect.width() / 2;
    }

    private int getOffsetY() {
        return 0;
    }

    private int getOffsetX(int pOffsetX) {
        return pOffsetX + (pOffsetX >= 0 ? 0 : -this.mLabelRect.width());
    }

    private int getOffsetY(int pOffsetY) {
        return pOffsetY + (pOffsetY >= 0 ? -this.mLabelRect.top : -this.mLabelRect.bottom);
    }
}

