/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Paint;
import java.util.ArrayList;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.PolyOverlayWithIW;

public class Polyline
extends PolyOverlayWithIW {
    protected OnClickListener mOnClickListener;

    public Polyline() {
        this((MapView)null);
    }

    public Polyline(MapView mapView) {
        this(mapView, false);
    }

    public Polyline(MapView pMapView, boolean pUsePath, boolean pClosePath) {
        super(pMapView, pUsePath, pClosePath);
        this.mOutlinePaint.setColor(-16777216);
        this.mOutlinePaint.setStrokeWidth(10.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutlinePaint.setAntiAlias(true);
    }

    public Polyline(MapView pMapView, boolean pUsePath) {
        this(pMapView, pUsePath, false);
    }

    @Deprecated
    public ArrayList<GeoPoint> getPoints() {
        return new ArrayList<GeoPoint>(this.getActualPoints());
    }

    @Deprecated
    public int getColor() {
        return this.mOutlinePaint.getColor();
    }

    @Deprecated
    public float getWidth() {
        return this.mOutlinePaint.getStrokeWidth();
    }

    @Deprecated
    public Paint getPaint() {
        return this.getOutlinePaint();
    }

    @Deprecated
    public void setColor(int color) {
        this.mOutlinePaint.setColor(color);
    }

    @Deprecated
    public void setWidth(float width) {
        this.mOutlinePaint.setStrokeWidth(width);
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public boolean onClickDefault(Polyline polyline, MapView mapView, GeoPoint eventPos) {
        polyline.setInfoWindowLocation(eventPos);
        polyline.showInfoWindow();
        return true;
    }

    @Override
    public void onDetach(MapView mapView) {
        super.onDetach(mapView);
        this.mOnClickListener = null;
    }

    @Override
    public double getDistance() {
        return this.mOutline.getDistance();
    }

    @Override
    protected boolean click(MapView pMapView, GeoPoint pEventPos) {
        if (this.mOnClickListener == null) {
            return this.onClickDefault(this, pMapView, pEventPos);
        }
        return this.mOnClickListener.onClick(this, pMapView, pEventPos);
    }

    public static interface OnClickListener {
        public boolean onClick(Polyline var1, MapView var2, GeoPoint var3);
    }
}

