/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

public class MapTileIndex {
    public static int mMaxZoomLevel = 29;
    private static int mModulo = 1 << mMaxZoomLevel;

    public static long getTileIndex(int pZoom, int pX, int pY) {
        MapTileIndex.checkValues(pZoom, pX, pY);
        return ((long)pZoom << mMaxZoomLevel * 2) + ((long)pX << mMaxZoomLevel) + (long)pY;
    }

    public static int getZoom(long pTileIndex) {
        return (int)(pTileIndex >> mMaxZoomLevel * 2);
    }

    public static int getX(long pTileIndex) {
        return (int)((pTileIndex >> mMaxZoomLevel) % (long)mModulo);
    }

    public static int getY(long pTileIndex) {
        return (int)(pTileIndex % (long)mModulo);
    }

    public static String toString(int pZoom, int pX, int pY) {
        return "/" + pZoom + "/" + pX + "/" + pY;
    }

    public static String toString(long pIndex) {
        return MapTileIndex.toString(MapTileIndex.getZoom(pIndex), MapTileIndex.getX(pIndex), MapTileIndex.getY(pIndex));
    }

    private static void checkValues(int pZoom, int pX, int pY) {
        if (pZoom < 0 || pZoom > mMaxZoomLevel) {
            MapTileIndex.throwIllegalValue(pZoom, pZoom, "Zoom");
        }
        long max = 1 << pZoom;
        if (pX < 0 || (long)pX >= max) {
            MapTileIndex.throwIllegalValue(pZoom, pX, "X");
        }
        if (pY < 0 || (long)pY >= max) {
            MapTileIndex.throwIllegalValue(pZoom, pY, "Y");
        }
    }

    private static void throwIllegalValue(int pZoom, int pValue, String pTag) {
        throw new IllegalArgumentException("MapTileIndex: " + pTag + " (" + pValue + ") is too big (zoom=" + pZoom + ")");
    }
}

