/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.Rect;
import java.util.Iterator;
import org.osmdroid.util.IterableWithSize;
import org.osmdroid.util.MapTileContainer;
import org.osmdroid.util.MapTileIndex;

public class MapTileArea
implements MapTileContainer,
IterableWithSize<Long> {
    private int mZoom;
    private int mLeft;
    private int mTop;
    private int mWidth;
    private int mHeight;
    private int mMapTileUpperBound;

    public MapTileArea set(int pZoom, int pLeft, int pTop, int pRight, int pBottom) {
        this.mZoom = pZoom;
        this.mMapTileUpperBound = 1 << this.mZoom;
        this.mWidth = this.computeSize(pLeft, pRight);
        this.mHeight = this.computeSize(pTop, pBottom);
        this.mLeft = this.cleanValue(pLeft);
        this.mTop = this.cleanValue(pTop);
        return this;
    }

    public MapTileArea set(int pZoom, Rect pRect) {
        return this.set(pZoom, pRect.left, pRect.top, pRect.right, pRect.bottom);
    }

    public MapTileArea set(MapTileArea pArea) {
        if (pArea.size() == 0) {
            return this.reset();
        }
        return this.set(pArea.mZoom, pArea.mLeft, pArea.mTop, pArea.getRight(), pArea.getBottom());
    }

    public MapTileArea reset() {
        this.mWidth = 0;
        return this;
    }

    public int getZoom() {
        return this.mZoom;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getRight() {
        return (this.mLeft + this.mWidth) % this.mMapTileUpperBound;
    }

    public int getBottom() {
        return (this.mTop + this.mHeight) % this.mMapTileUpperBound;
    }

    @Override
    public int size() {
        return this.mWidth * this.mHeight;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private int mIndex;

            @Override
            public boolean hasNext() {
                return this.mIndex < MapTileArea.this.size();
            }

            @Override
            public Long next() {
                int x;
                if (!this.hasNext()) {
                    return null;
                }
                int y = MapTileArea.this.mTop + this.mIndex / MapTileArea.this.mWidth;
                ++this.mIndex;
                for (x = MapTileArea.this.mLeft + this.mIndex % MapTileArea.this.mWidth; x >= MapTileArea.this.mMapTileUpperBound; x -= MapTileArea.this.mMapTileUpperBound) {
                }
                while (y >= MapTileArea.this.mMapTileUpperBound) {
                    y -= MapTileArea.this.mMapTileUpperBound;
                }
                return MapTileIndex.getTileIndex(MapTileArea.this.mZoom, x, y);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean contains(long pTileIndex) {
        if (MapTileIndex.getZoom(pTileIndex) != this.mZoom) {
            return false;
        }
        if (!this.contains(MapTileIndex.getX(pTileIndex), this.mLeft, this.mWidth)) {
            return false;
        }
        return this.contains(MapTileIndex.getY(pTileIndex), this.mTop, this.mHeight);
    }

    private boolean contains(int pValue, int pFirst, int pSize) {
        while (pValue < pFirst) {
            pValue += this.mMapTileUpperBound;
        }
        return pValue < pFirst + pSize;
    }

    private int cleanValue(int pValue) {
        while (pValue < 0) {
            pValue += this.mMapTileUpperBound;
        }
        while (pValue >= this.mMapTileUpperBound) {
            pValue -= this.mMapTileUpperBound;
        }
        return pValue;
    }

    private int computeSize(int pTopLeft, int pBottomRight) {
        while (pTopLeft > pBottomRight) {
            pBottomRight += this.mMapTileUpperBound;
        }
        return Math.min(this.mMapTileUpperBound, pBottomRight - pTopLeft + 1);
    }

    public String toString() {
        if (this.mWidth == 0) {
            return "MapTileArea:empty";
        }
        return "MapTileArea:zoom=" + this.mZoom + ",left=" + this.mLeft + ",top=" + this.mTop + ",width=" + this.mWidth + ",height=" + this.mHeight;
    }
}

