/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.location.Location;
import android.location.LocationManager;
import org.osmdroid.config.Configuration;

public class LocationUtils {
    private LocationUtils() {
    }

    public static Location getLastKnownLocation(LocationManager pLocationManager) {
        if (pLocationManager == null) {
            return null;
        }
        Location gpsLocation = LocationUtils.getLastKnownLocation(pLocationManager, "gps");
        Location networkLocation = LocationUtils.getLastKnownLocation(pLocationManager, "network");
        if (gpsLocation == null) {
            return networkLocation;
        }
        if (networkLocation == null) {
            return gpsLocation;
        }
        if (networkLocation.getTime() > gpsLocation.getTime() + Configuration.getInstance().getGpsWaitTime()) {
            return networkLocation;
        }
        return gpsLocation;
    }

    private static Location getLastKnownLocation(LocationManager pLocationManager, String pProvider) {
        try {
            if (!pLocationManager.isProviderEnabled(pProvider)) {
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return pLocationManager.getLastKnownLocation(pProvider);
    }
}

