/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource.bing;

import org.json.JSONArray;
import org.json.JSONObject;

public class ImageryMetaDataResource {
    private static final String IMAGE_WIDTH = "imageWidth";
    private static final String IMAGE_HEIGHT = "imageHeight";
    private static final String IMAGE_URL = "imageUrl";
    private static final String IMAGE_URL_SUBDOMAINS = "imageUrlSubdomains";
    private static final String ZOOM_MIN = "ZoomMin";
    private static final String ZOOM_MAX = "ZoomMax";
    private static final String COPYRIGHT = "copyright";
    public String copyright = "";
    public int m_imageHeight = 256;
    public int m_imageWidth = 256;
    public String m_imageUrl;
    public String[] m_imageUrlSubdomains;
    public int m_zoomMax = 22;
    public int m_zoomMin = 1;
    public boolean m_isInitialised = false;
    private int m_subdomainsCounter = 0;

    public static ImageryMetaDataResource getDefaultInstance() {
        return new ImageryMetaDataResource();
    }

    public static ImageryMetaDataResource getInstanceFromJSON(JSONObject a_jsonObject, JSONObject parent) throws Exception {
        JSONArray subdomains;
        ImageryMetaDataResource result = new ImageryMetaDataResource();
        if (a_jsonObject == null) {
            throw new Exception("JSON to parse is null");
        }
        result.copyright = parent.getString(COPYRIGHT);
        if (a_jsonObject.has(IMAGE_HEIGHT)) {
            result.m_imageHeight = a_jsonObject.getInt(IMAGE_HEIGHT);
        }
        if (a_jsonObject.has(IMAGE_WIDTH)) {
            result.m_imageWidth = a_jsonObject.getInt(IMAGE_WIDTH);
        }
        if (a_jsonObject.has(ZOOM_MIN)) {
            result.m_zoomMin = a_jsonObject.getInt(ZOOM_MIN);
        }
        if (a_jsonObject.has(ZOOM_MAX)) {
            result.m_zoomMax = a_jsonObject.getInt(ZOOM_MAX);
        }
        result.m_imageUrl = a_jsonObject.getString(IMAGE_URL);
        if (result.m_imageUrl != null && result.m_imageUrl.matches(".*?\\{.*?\\}.*?")) {
            result.m_imageUrl = result.m_imageUrl.replaceAll("\\{.*?\\}", "%s");
        }
        if ((subdomains = a_jsonObject.getJSONArray(IMAGE_URL_SUBDOMAINS)) != null && subdomains.length() >= 1) {
            result.m_imageUrlSubdomains = new String[subdomains.length()];
            for (int i = 0; i < subdomains.length(); ++i) {
                result.m_imageUrlSubdomains[i] = subdomains.getString(i);
            }
        }
        result.m_isInitialised = true;
        return result;
    }

    public synchronized String getSubDomain() {
        if (this.m_imageUrlSubdomains == null || this.m_imageUrlSubdomains.length <= 0) {
            return null;
        }
        String result = this.m_imageUrlSubdomains[this.m_subdomainsCounter];
        this.m_subdomainsCounter = this.m_subdomainsCounter < this.m_imageUrlSubdomains.length - 1 ? ++this.m_subdomainsCounter : 0;
        return result;
    }
}

