/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.MapTileIndex;

public class MBTilesFileArchive
implements IArchiveFile {
    private SQLiteDatabase mDatabase;
    public static final String TABLE_TILES = "tiles";
    public static final String COL_TILES_ZOOM_LEVEL = "zoom_level";
    public static final String COL_TILES_TILE_COLUMN = "tile_column";
    public static final String COL_TILES_TILE_ROW = "tile_row";
    public static final String COL_TILES_TILE_DATA = "tile_data";

    public MBTilesFileArchive() {
    }

    private MBTilesFileArchive(SQLiteDatabase pDatabase) {
        this.mDatabase = pDatabase;
    }

    public static MBTilesFileArchive getDatabaseFileArchive(File pFile) throws SQLiteException {
        return new MBTilesFileArchive(SQLiteDatabase.openDatabase((String)pFile.getAbsolutePath(), null, (int)17));
    }

    @Override
    public void init(File pFile) throws Exception {
        this.mDatabase = SQLiteDatabase.openDatabase((String)pFile.getAbsolutePath(), null, (int)17);
    }

    @Override
    public InputStream getInputStream(ITileSource pTileSource, long pMapTileIndex) {
        try {
            ByteArrayInputStream ret = null;
            String[] tile = new String[]{COL_TILES_TILE_DATA};
            String[] xyz = new String[]{Integer.toString(MapTileIndex.getX(pMapTileIndex)), Double.toString(Math.pow(2.0, MapTileIndex.getZoom(pMapTileIndex)) - (double)MapTileIndex.getY(pMapTileIndex) - 1.0), Integer.toString(MapTileIndex.getZoom(pMapTileIndex))};
            Cursor cur = this.mDatabase.query(TABLE_TILES, tile, "tile_column=? and tile_row=? and zoom_level=?", xyz, null, null, null);
            if (cur.getCount() != 0) {
                cur.moveToFirst();
                ret = new ByteArrayInputStream(cur.getBlob(0));
            }
            cur.close();
            if (ret != null) {
                return ret;
            }
        }
        catch (Throwable e) {
            Log.w((String)"OsmDroid", (String)("Error getting db stream: " + MapTileIndex.toString(pMapTileIndex)), (Throwable)e);
        }
        return null;
    }

    @Override
    public Set<String> getTileSources() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void setIgnoreTileSource(boolean pIgnoreTileSource) {
    }

    @Override
    public void close() {
        this.mDatabase.close();
    }

    public String toString() {
        return "DatabaseFileArchive [mDatabase=" + this.mDatabase.getPath() + "]";
    }
}

