/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.content.Context;
import android.os.Build;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTileProviderArray;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.INetworkAvailablityCheck;
import org.osmdroid.tileprovider.modules.MapTileApproximater;
import org.osmdroid.tileprovider.modules.MapTileAssetsProvider;
import org.osmdroid.tileprovider.modules.MapTileDownloader;
import org.osmdroid.tileprovider.modules.MapTileFileArchiveProvider;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileFilesystemProvider;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.modules.MapTileSqlCacheProvider;
import org.osmdroid.tileprovider.modules.NetworkAvailabliltyCheck;
import org.osmdroid.tileprovider.modules.SqlTileWriter;
import org.osmdroid.tileprovider.modules.TileWriter;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.tileprovider.util.SimpleRegisterReceiver;
import org.osmdroid.util.MapTileAreaBorderComputer;
import org.osmdroid.util.MapTileAreaZoomComputer;
import org.osmdroid.util.MapTileIndex;

public class MapTileProviderBasic
extends MapTileProviderArray
implements IMapTileProviderCallback {
    protected IFilesystemCache tileWriter;
    private final INetworkAvailablityCheck mNetworkAvailabilityCheck;
    private final MapTileDownloader mDownloaderProvider;
    private final MapTileApproximater mApproximationProvider;

    public MapTileProviderBasic(Context pContext) {
        this(pContext, TileSourceFactory.DEFAULT_TILE_SOURCE);
    }

    public MapTileProviderBasic(Context pContext, ITileSource pTileSource) {
        this(pContext, pTileSource, null);
    }

    public MapTileProviderBasic(Context pContext, ITileSource pTileSource, IFilesystemCache cacheWriter) {
        this(new SimpleRegisterReceiver(pContext), new NetworkAvailabliltyCheck(pContext), pTileSource, pContext, cacheWriter);
    }

    public MapTileProviderBasic(IRegisterReceiver pRegisterReceiver, INetworkAvailablityCheck aNetworkAvailablityCheck, ITileSource pTileSource, Context pContext, IFilesystemCache cacheWriter) {
        super(pTileSource, pRegisterReceiver);
        this.mNetworkAvailabilityCheck = aNetworkAvailablityCheck;
        this.tileWriter = cacheWriter != null ? cacheWriter : (Build.VERSION.SDK_INT < 10 ? new TileWriter() : new SqlTileWriter());
        MapTileFileStorageProviderBase assetsProvider = this.createAssetsProvider(pRegisterReceiver, pTileSource, pContext);
        this.mTileProviderList.add(assetsProvider);
        MapTileFileStorageProviderBase cacheProvider = MapTileProviderBasic.getMapTileFileStorageProviderBase(pRegisterReceiver, pTileSource, this.tileWriter);
        this.mTileProviderList.add(cacheProvider);
        MapTileFileStorageProviderBase archiveProvider = this.createArchiveProvider(pRegisterReceiver, pTileSource);
        this.mTileProviderList.add(archiveProvider);
        this.mApproximationProvider = this.createApproximater(assetsProvider, cacheProvider, archiveProvider);
        this.mTileProviderList.add(this.mApproximationProvider);
        this.mDownloaderProvider = this.createDownloaderProvider(aNetworkAvailablityCheck, pTileSource);
        this.mTileProviderList.add(this.mDownloaderProvider);
        this.getTileCache().getProtectedTileComputers().add(new MapTileAreaZoomComputer(-1));
        this.getTileCache().getProtectedTileComputers().add(new MapTileAreaBorderComputer(1));
        this.getTileCache().setAutoEnsureCapacity(false);
        this.getTileCache().setStressedMemory(false);
        this.getTileCache().getPreCache().addProvider(assetsProvider);
        this.getTileCache().getPreCache().addProvider(cacheProvider);
        this.getTileCache().getPreCache().addProvider(archiveProvider);
        this.getTileCache().getPreCache().addProvider(this.mDownloaderProvider);
        this.getTileCache().getProtectedTileContainers().add(this);
        this.setOfflineFirst(true);
    }

    protected MapTileApproximater createApproximater(MapTileFileStorageProviderBase assetsProvider, MapTileFileStorageProviderBase cacheProvider, MapTileFileStorageProviderBase archiveProvider) {
        MapTileApproximater approximationProvider = new MapTileApproximater();
        approximationProvider.addProvider(assetsProvider);
        approximationProvider.addProvider(cacheProvider);
        approximationProvider.addProvider(archiveProvider);
        return approximationProvider;
    }

    protected MapTileFileStorageProviderBase createArchiveProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource) {
        return new MapTileFileArchiveProvider(pRegisterReceiver, pTileSource);
    }

    protected MapTileFileStorageProviderBase createAssetsProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, Context pContext) {
        return new MapTileAssetsProvider(pRegisterReceiver, pContext.getAssets(), pTileSource);
    }

    @Override
    public IFilesystemCache getTileWriter() {
        return this.tileWriter;
    }

    protected MapTileDownloader createDownloaderProvider(INetworkAvailablityCheck aNetworkAvailablityCheck, ITileSource pTileSource) {
        return new MapTileDownloader(pTileSource, this.tileWriter, aNetworkAvailablityCheck);
    }

    @Override
    public void detach() {
        if (this.tileWriter != null) {
            this.tileWriter.onDetach();
        }
        this.tileWriter = null;
        super.detach();
    }

    @Override
    protected boolean isDowngradedMode(long pMapTileIndex) {
        if (this.mNetworkAvailabilityCheck != null && !this.mNetworkAvailabilityCheck.getNetworkAvailable() || !this.useDataConnection()) {
            return true;
        }
        int zoomMin = -1;
        int zoomMax = -1;
        for (MapTileModuleProviderBase provider : this.mTileProviderList) {
            if (!provider.getUsesDataConnection()) continue;
            int tmp = provider.getMinimumZoomLevel();
            if (zoomMin == -1 || zoomMin > tmp) {
                zoomMin = tmp;
            }
            tmp = provider.getMaximumZoomLevel();
            if (zoomMax != -1 && zoomMax >= tmp) continue;
            zoomMax = tmp;
        }
        if (zoomMin == -1 || zoomMax == -1) {
            return true;
        }
        int zoom = MapTileIndex.getZoom(pMapTileIndex);
        return zoom < zoomMin || zoom > zoomMax;
    }

    public static MapTileFileStorageProviderBase getMapTileFileStorageProviderBase(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, IFilesystemCache pTileWriter) {
        if (pTileWriter instanceof TileWriter) {
            return new MapTileFilesystemProvider(pRegisterReceiver, pTileSource);
        }
        return new MapTileSqlCacheProvider(pRegisterReceiver, pTileSource);
    }

    public boolean setOfflineFirst(boolean pOfflineFirst) {
        int downloaderIndex = -1;
        int approximationIndex = -1;
        int i = 0;
        for (MapTileModuleProviderBase provider : this.mTileProviderList) {
            if (downloaderIndex == -1 && provider == this.mDownloaderProvider) {
                downloaderIndex = i;
            }
            if (approximationIndex == -1 && provider == this.mApproximationProvider) {
                approximationIndex = i;
            }
            ++i;
        }
        if (downloaderIndex == -1 || approximationIndex == -1) {
            return false;
        }
        if (approximationIndex < downloaderIndex && pOfflineFirst) {
            return true;
        }
        if (approximationIndex > downloaderIndex && !pOfflineFirst) {
            return true;
        }
        this.mTileProviderList.set(downloaderIndex, this.mApproximationProvider);
        this.mTileProviderList.set(approximationIndex, this.mDownloaderProvider);
        return true;
    }
}

