/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import android.content.Context;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.ManifestUtil;
import org.osmdroid.util.MapTileIndex;

public class ThunderforestTileSource
extends OnlineTileSourceBase {
    private static final String THUNDERFOREST_MAPID = "THUNDERFOREST_MAPID";
    public static final int CYCLE = 0;
    public static final int TRANSPORT = 1;
    public static final int LANDSCAPE = 2;
    public static final int OUTDOORS = 3;
    public static final int TRANSPORT_DARK = 4;
    public static final int SPINAL_MAP = 5;
    public static final int PIONEER = 6;
    public static final int MOBILE_ATLAS = 7;
    public static final int NEIGHBOURHOOD = 8;
    private static final String[] urlMap = new String[]{"cycle", "transport", "landscape", "outdoors", "transport-dark", "spinal-map", "pioneer", "mobile-atlas", "neighbourhood"};
    private static final String[] uiMap = new String[]{"CycleMap", "Transport", "Landscape", "Outdoors", "TransportDark", "Spinal", "Pioneer", "MobileAtlas", "Neighbourhood"};
    private static final String[] baseUrl = new String[]{"https://a.tile.thunderforest.com/{map}/", "https://b.tile.thunderforest.com/{map}/", "https://c.tile.thunderforest.com/{map}/"};
    private final int mMap;
    private final String mMapId;

    public static final String mapName(int m) {
        if (m < 0 || m >= uiMap.length) {
            return "";
        }
        return uiMap[m];
    }

    public ThunderforestTileSource(Context ctx, int aMap) {
        super(uiMap[aMap], 0, 17, 256, ".png", baseUrl, "Maps \u00a9 Thunderforest, Data \u00a9 OpenStreetMap contributors.");
        this.mMap = aMap;
        this.mMapId = this.retrieveMapId(ctx);
    }

    public final String retrieveMapId(Context aContext) {
        return ManifestUtil.retrieveKey(aContext, THUNDERFOREST_MAPID);
    }

    @Override
    public String getTileURLString(long pMapTileIndex) {
        StringBuilder url = new StringBuilder(this.getBaseUrl().replace("{map}", urlMap[this.mMap]));
        url.append(MapTileIndex.getZoom(pMapTileIndex));
        url.append("/");
        url.append(MapTileIndex.getX(pMapTileIndex));
        url.append("/");
        url.append(MapTileIndex.getY(pMapTileIndex));
        url.append(".png?");
        url.append("apikey=").append(this.mMapId);
        String res = url.toString();
        return res;
    }

    public static boolean haveMapId(Context aContext) {
        return !ManifestUtil.retrieveKey(aContext, THUNDERFOREST_MAPID).equals("");
    }
}

