/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.cachemanager;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.modules.CantContinueException;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.TileDownloader;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.tilesource.TileSourcePolicyException;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.IterableWithSize;
import org.osmdroid.util.MapTileArea;
import org.osmdroid.util.MapTileAreaList;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;

public class CacheManager {
    private TileDownloader mTileDownloader = new TileDownloader();
    protected final ITileSource mTileSource;
    protected final IFilesystemCache mTileWriter;
    protected final int mMinZoomLevel;
    protected final int mMaxZoomLevel;
    protected Set<CacheManagerTask> mPendingTasks = new HashSet<CacheManagerTask>();
    protected boolean verifyCancel = true;

    public CacheManager(MapView mapView) throws TileSourcePolicyException {
        this(mapView, mapView.getTileProvider().getTileWriter());
    }

    public CacheManager(MapView mapView, IFilesystemCache writer) throws TileSourcePolicyException {
        this(mapView.getTileProvider(), writer, (int)mapView.getMinZoomLevel(), (int)mapView.getMaxZoomLevel());
    }

    public CacheManager(MapTileProviderBase pTileProvider, IFilesystemCache pWriter, int pMinZoomLevel, int pMaxZoomLevel) throws TileSourcePolicyException {
        this(pTileProvider.getTileSource(), pWriter, pMinZoomLevel, pMaxZoomLevel);
    }

    public CacheManager(ITileSource pTileSource, IFilesystemCache pWriter, int pMinZoomLevel, int pMaxZoomLevel) throws TileSourcePolicyException {
        this.mTileSource = pTileSource;
        this.mTileWriter = pWriter;
        this.mMinZoomLevel = pMinZoomLevel;
        this.mMaxZoomLevel = pMaxZoomLevel;
    }

    public int getPendingJobs() {
        return this.mPendingTasks.size();
    }

    @Deprecated
    public static Point getMapTileFromCoordinates(double aLat, double aLon, int zoom) {
        int y = MapView.getTileSystem().getTileYFromLatitude(aLat, zoom);
        int x = MapView.getTileSystem().getTileXFromLongitude(aLon, zoom);
        return new Point(x, y);
    }

    @Deprecated
    public static GeoPoint getCoordinatesFromMapTile(int x, int y, int zoom) {
        double lat = MapView.getTileSystem().getLatitudeFromTileY(y, zoom);
        double lon = MapView.getTileSystem().getLongitudeFromTileX(x, zoom);
        return new GeoPoint(lat, lon);
    }

    public static File getFileName(ITileSource tileSource, long pMapTileIndex) {
        File file = new File(Configuration.getInstance().getOsmdroidTileCache(), tileSource.getTileRelativeFilenameString(pMapTileIndex) + ".tile");
        return file;
    }

    public boolean loadTile(OnlineTileSourceBase tileSource, long pMapTileIndex) {
        File file = CacheManager.getFileName(tileSource, pMapTileIndex);
        if (file.exists()) {
            return true;
        }
        if (this.mTileWriter.exists(tileSource, pMapTileIndex)) {
            return true;
        }
        return this.forceLoadTile(tileSource, pMapTileIndex);
    }

    public boolean forceLoadTile(OnlineTileSourceBase tileSource, long pMapTileIndex) {
        try {
            Drawable drawable = this.mTileDownloader.downloadTile(pMapTileIndex, this.mTileWriter, tileSource);
            return drawable != null;
        }
        catch (CantContinueException e) {
            return false;
        }
    }

    public boolean deleteTile(long pMapTileIndex) {
        return this.mTileWriter.exists(this.mTileSource, pMapTileIndex) && this.mTileWriter.remove(this.mTileSource, pMapTileIndex);
    }

    public boolean checkTile(long pMapTileIndex) {
        return this.mTileWriter.exists(this.mTileSource, pMapTileIndex);
    }

    public boolean isTileToBeDownloaded(ITileSource pTileSource, long pMapTileIndex) {
        Long expiration = this.mTileWriter.getExpirationTimestamp(pTileSource, pMapTileIndex);
        if (expiration == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        return now > expiration;
    }

    public static List<Long> getTilesCoverage(BoundingBox pBB, int pZoomMin, int pZoomMax) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (int zoomLevel = pZoomMin; zoomLevel <= pZoomMax; ++zoomLevel) {
            Collection<Long> resultForZoom = CacheManager.getTilesCoverage(pBB, zoomLevel);
            result.addAll(resultForZoom);
        }
        return result;
    }

    public static Collection<Long> getTilesCoverage(BoundingBox pBB, int pZoomLevel) {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        for (Long mapTile : CacheManager.getTilesCoverageIterable(pBB, pZoomLevel, pZoomLevel)) {
            result.add(mapTile);
        }
        return result;
    }

    static IterableWithSize<Long> getTilesCoverageIterable(BoundingBox pBB, int pZoomMin, int pZoomMax) {
        MapTileAreaList list = new MapTileAreaList();
        for (int zoomLevel = pZoomMin; zoomLevel <= pZoomMax; ++zoomLevel) {
            list.getList().add(new MapTileArea().set(zoomLevel, CacheManager.getTilesRect(pBB, zoomLevel)));
        }
        return list;
    }

    public static Rect getTilesRect(BoundingBox pBB, int pZoomLevel) {
        int height;
        int mapTileUpperBound = 1 << pZoomLevel;
        int right = MapView.getTileSystem().getTileXFromLongitude(pBB.getLonEast(), pZoomLevel);
        int bottom = MapView.getTileSystem().getTileYFromLatitude(pBB.getLatSouth(), pZoomLevel);
        int left = MapView.getTileSystem().getTileXFromLongitude(pBB.getLonWest(), pZoomLevel);
        int top = MapView.getTileSystem().getTileYFromLatitude(pBB.getLatNorth(), pZoomLevel);
        int width = right - left + 1;
        if (width <= 0) {
            width += mapTileUpperBound;
        }
        if ((height = bottom - top + 1) <= 0) {
            height += mapTileUpperBound;
        }
        return new Rect(left, top, left + width - 1, top + height - 1);
    }

    public static List<Long> getTilesCoverage(ArrayList<GeoPoint> pGeoPoints, int pZoomMin, int pZoomMax) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (int zoomLevel = pZoomMin; zoomLevel <= pZoomMax; ++zoomLevel) {
            Collection<Long> resultForZoom = CacheManager.getTilesCoverage(pGeoPoints, zoomLevel);
            result.addAll(resultForZoom);
        }
        return result;
    }

    public static Collection<Long> getTilesCoverage(ArrayList<GeoPoint> pGeoPoints, int pZoomLevel) {
        HashSet<Long> result = new HashSet<Long>();
        GeoPoint prevPoint = null;
        Point prevTile = null;
        int mapTileUpperBound = 1 << pZoomLevel;
        for (GeoPoint geoPoint : pGeoPoints) {
            Point tile;
            double d = TileSystem.GroundResolution(geoPoint.getLatitude(), pZoomLevel);
            if (result.size() != 0) {
                if (prevPoint != null) {
                    double leadCoef = (geoPoint.getLatitude() - prevPoint.getLatitude()) / (geoPoint.getLongitude() - prevPoint.getLongitude());
                    double brng = geoPoint.getLongitude() > prevPoint.getLongitude() ? 1.5707963267948966 - Math.atan(leadCoef) : 4.71238898038469 - Math.atan(leadCoef);
                    GeoPoint wayPoint = new GeoPoint(prevPoint.getLatitude(), prevPoint.getLongitude());
                    while ((geoPoint.getLatitude() > prevPoint.getLatitude() && wayPoint.getLatitude() < geoPoint.getLatitude() || geoPoint.getLatitude() < prevPoint.getLatitude() && wayPoint.getLatitude() > geoPoint.getLatitude()) && (geoPoint.getLongitude() > prevPoint.getLongitude() && wayPoint.getLongitude() < geoPoint.getLongitude() || geoPoint.getLongitude() < prevPoint.getLongitude() && wayPoint.getLongitude() > geoPoint.getLongitude())) {
                        double prevLatRad = wayPoint.getLatitude() * Math.PI / 180.0;
                        double prevLonRad = wayPoint.getLongitude() * Math.PI / 180.0;
                        double latRad = Math.asin(Math.sin(prevLatRad) * Math.cos(d / 6378137.0) + Math.cos(prevLatRad) * Math.sin(d / 6378137.0) * Math.cos(brng));
                        double lonRad = prevLonRad + Math.atan2(Math.sin(brng) * Math.sin(d / 6378137.0) * Math.cos(prevLatRad), Math.cos(d / 6378137.0) - Math.sin(prevLatRad) * Math.sin(latRad));
                        wayPoint.setLatitude(latRad * 180.0 / Math.PI);
                        wayPoint.setLongitude(lonRad * 180.0 / Math.PI);
                        tile = new Point(MapView.getTileSystem().getTileXFromLongitude(wayPoint.getLongitude(), pZoomLevel), MapView.getTileSystem().getTileYFromLatitude(wayPoint.getLatitude(), pZoomLevel));
                        if (tile.equals((Object)prevTile)) continue;
                        int ofsx = tile.x >= 0 ? 0 : -tile.x;
                        int ofsy = tile.y >= 0 ? 0 : -tile.y;
                        for (int xAround = tile.x + ofsx; xAround <= tile.x + 1 + ofsx; ++xAround) {
                            for (int yAround = tile.y + ofsy; yAround <= tile.y + 1 + ofsy; ++yAround) {
                                int tileY = MyMath.mod(yAround, mapTileUpperBound);
                                int tileX = MyMath.mod(xAround, mapTileUpperBound);
                                result.add(MapTileIndex.getTileIndex(pZoomLevel, tileX, tileY));
                            }
                        }
                        prevTile = tile;
                    }
                }
            } else {
                prevTile = tile = new Point(MapView.getTileSystem().getTileXFromLongitude(geoPoint.getLongitude(), pZoomLevel), MapView.getTileSystem().getTileYFromLatitude(geoPoint.getLatitude(), pZoomLevel));
                int ofsx = tile.x >= 0 ? 0 : -tile.x;
                int ofsy = tile.y >= 0 ? 0 : -tile.y;
                for (int xAround = tile.x + ofsx; xAround <= tile.x + 1 + ofsx; ++xAround) {
                    for (int yAround = tile.y + ofsy; yAround <= tile.y + 1 + ofsy; ++yAround) {
                        int tileY = MyMath.mod(yAround, mapTileUpperBound);
                        int tileX = MyMath.mod(xAround, mapTileUpperBound);
                        result.add(MapTileIndex.getTileIndex(pZoomLevel, tileX, tileY));
                    }
                }
            }
            prevPoint = geoPoint;
        }
        return result;
    }

    public int possibleTilesInArea(BoundingBox pBB, int pZoomMin, int pZoomMax) {
        return CacheManager.getTilesCoverageIterable(pBB, pZoomMin, pZoomMax).size();
    }

    public int possibleTilesCovered(ArrayList<GeoPoint> pGeoPoints, int pZoomMin, int pZoomMax) {
        return CacheManager.getTilesCoverage(pGeoPoints, pZoomMin, pZoomMax).size();
    }

    public CacheManagerTask execute(CacheManagerTask pTask) {
        pTask.execute(new Object[0]);
        this.mPendingTasks.add(pTask);
        return pTask;
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), bb, zoomMin, zoomMax);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), geoPoints, zoomMin, zoomMax);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), bb, zoomMin, zoomMax);
        task.addCallback(callback);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), geoPoints, zoomMin, zoomMax);
        task.addCallback(callback);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsyncNoUI(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), geoPoints, zoomMin, zoomMax);
        task.addCallback(callback);
        return this.execute(task);
    }

    public CacheManagerTask downloadAreaAsyncNoUI(Context ctx, BoundingBox bb, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), bb, zoomMin, zoomMax);
        task.addCallback(callback);
        this.execute(task);
        return task;
    }

    public void cancelAllJobs() {
        for (CacheManagerTask next : this.mPendingTasks) {
            next.cancel(true);
        }
        this.mPendingTasks.clear();
    }

    public CacheManagerTask downloadAreaAsync(Context ctx, List<Long> pTiles, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getDownloadingAction(), pTiles, zoomMin, zoomMax);
        task.addCallback(this.getDownloadingDialog(ctx, task));
        return this.execute(task);
    }

    public void setVerifyCancel(boolean state) {
        this.verifyCancel = state;
    }

    public boolean getVerifyCancel() {
        return this.verifyCancel;
    }

    public CacheManagerDialog getDownloadingDialog(final Context pCtx, CacheManagerTask pTask) {
        return new CacheManagerDialog(pCtx, pTask){

            @Override
            protected String getUITitle() {
                return "Downloading tiles";
            }

            @Override
            public void onTaskFailed(int errors) {
                super.onTaskFailed(errors);
                Toast.makeText((Context)pCtx, (CharSequence)("Loading completed with " + errors + " errors."), (int)0).show();
            }
        };
    }

    public CacheManagerDialog getCleaningDialog(final Context pCtx, CacheManagerTask pTask) {
        return new CacheManagerDialog(pCtx, pTask){

            @Override
            protected String getUITitle() {
                return "Cleaning tiles";
            }

            @Override
            public void onTaskFailed(int deleted) {
                super.onTaskFailed(deleted);
                Toast.makeText((Context)pCtx, (CharSequence)("Cleaning completed, " + deleted + " tiles deleted."), (int)0).show();
            }
        };
    }

    public CacheManagerAction getDownloadingAction() {
        return new CacheManagerAction(){

            @Override
            public boolean preCheck() {
                if (CacheManager.this.mTileSource instanceof OnlineTileSourceBase) {
                    if (!((OnlineTileSourceBase)CacheManager.this.mTileSource).getTileSourcePolicy().acceptsBulkDownload()) {
                        throw new TileSourcePolicyException("This online tile source doesn't support bulk download");
                    }
                    return true;
                }
                Log.e((String)"OsmDroid", (String)"TileSource is not an online tile source");
                return false;
            }

            @Override
            public int getProgressModulo() {
                return 10;
            }

            @Override
            public boolean tileAction(long pMapTileIndex) {
                return !CacheManager.this.loadTile((OnlineTileSourceBase)CacheManager.this.mTileSource, pMapTileIndex);
            }
        };
    }

    public CacheManagerAction getCleaningAction() {
        return new CacheManagerAction(){

            @Override
            public boolean preCheck() {
                return true;
            }

            @Override
            public int getProgressModulo() {
                return 1000;
            }

            @Override
            public boolean tileAction(long pMapTileIndex) {
                return CacheManager.this.deleteTile(pMapTileIndex);
            }
        };
    }

    public CacheManagerTask cleanAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getCleaningAction(), bb, zoomMin, zoomMax);
        task.addCallback(this.getCleaningDialog(ctx, task));
        return this.execute(task);
    }

    public CacheManagerTask cleanAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax) {
        BoundingBox extendedBounds = this.extendedBoundsFromGeoPoints(geoPoints, zoomMin);
        return this.cleanAreaAsync(ctx, extendedBounds, zoomMin, zoomMax);
    }

    public CacheManagerTask cleanAreaAsync(Context ctx, List<Long> tiles, int zoomMin, int zoomMax) {
        CacheManagerTask task = new CacheManagerTask(this, this.getCleaningAction(), tiles, zoomMin, zoomMax);
        task.addCallback(this.getCleaningDialog(ctx, task));
        return this.execute(task);
    }

    public BoundingBox extendedBoundsFromGeoPoints(ArrayList<GeoPoint> geoPoints, int minZoomLevel) {
        BoundingBox bb = BoundingBox.fromGeoPoints(geoPoints);
        int right = MapView.getTileSystem().getTileXFromLongitude(bb.getLonEast(), minZoomLevel);
        int bottom = MapView.getTileSystem().getTileYFromLatitude(bb.getLatSouth(), minZoomLevel);
        int left = MapView.getTileSystem().getTileXFromLongitude(bb.getLonWest(), minZoomLevel);
        int top = MapView.getTileSystem().getTileYFromLatitude(bb.getLatNorth(), minZoomLevel);
        return new BoundingBox(MapView.getTileSystem().getLatitudeFromTileY(top - 1, minZoomLevel), MapView.getTileSystem().getLongitudeFromTileX(right + 1, minZoomLevel), MapView.getTileSystem().getLatitudeFromTileY(bottom + 1, minZoomLevel), MapView.getTileSystem().getLongitudeFromTileX(left - 1, minZoomLevel));
    }

    public long currentCacheUsage() {
        return this.directorySize(Configuration.getInstance().getOsmdroidTileCache());
    }

    public long cacheCapacity() {
        return Configuration.getInstance().getTileFileSystemCacheMaxBytes();
    }

    public long directorySize(File pDirectory) {
        long usedCacheSpace = 0L;
        File[] z = pDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    usedCacheSpace += file.length();
                    continue;
                }
                if (!file.isDirectory()) continue;
                usedCacheSpace += this.directorySize(file);
            }
        }
        return usedCacheSpace;
    }

    public void setTileDownloader(TileDownloader pTileDownloader) {
        this.mTileDownloader = pTileDownloader;
    }

    private static class ListWrapper<T>
    implements IterableWithSize<T> {
        private final List<T> list;

        private ListWrapper(List<T> list) {
            this.list = list;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }
    }

    public static interface CacheManagerAction {
        public boolean preCheck();

        public int getProgressModulo();

        public boolean tileAction(long var1);
    }

    public static class CacheManagerTask
    extends AsyncTask<Object, Integer, Integer> {
        private final CacheManager mManager;
        private final CacheManagerAction mAction;
        private final IterableWithSize<Long> mTiles;
        private final int mZoomMin;
        private final int mZoomMax;
        private final ArrayList<CacheManagerCallback> mCallbacks = new ArrayList();

        private CacheManagerTask(CacheManager pManager, CacheManagerAction pAction, IterableWithSize<Long> pTiles, int pZoomMin, int pZoomMax) {
            this.mManager = pManager;
            this.mAction = pAction;
            this.mTiles = pTiles;
            this.mZoomMin = Math.max(pZoomMin, pManager.mMinZoomLevel);
            this.mZoomMax = Math.min(pZoomMax, pManager.mMaxZoomLevel);
        }

        public CacheManagerTask(CacheManager pManager, CacheManagerAction pAction, List<Long> pTiles, int pZoomMin, int pZoomMax) {
            this(pManager, pAction, new ListWrapper<Long>(pTiles), pZoomMin, pZoomMax);
        }

        public CacheManagerTask(CacheManager pManager, CacheManagerAction pAction, ArrayList<GeoPoint> pGeoPoints, int pZoomMin, int pZoomMax) {
            this(pManager, pAction, CacheManager.getTilesCoverage(pGeoPoints, pZoomMin, pZoomMax), pZoomMin, pZoomMax);
        }

        public CacheManagerTask(CacheManager pManager, CacheManagerAction pAction, BoundingBox pBB, int pZoomMin, int pZoomMax) {
            this(pManager, pAction, CacheManager.getTilesCoverageIterable(pBB, pZoomMin, pZoomMax), pZoomMin, pZoomMax);
        }

        public void addCallback(CacheManagerCallback pCallback) {
            if (pCallback != null) {
                this.mCallbacks.add(pCallback);
            }
        }

        protected void onPreExecute() {
            int total = this.mTiles.size();
            for (CacheManagerCallback callback : this.mCallbacks) {
                try {
                    callback.setPossibleTilesInArea(total);
                    callback.downloadStarted();
                    callback.updateProgress(0, this.mZoomMin, this.mZoomMin, this.mZoomMax);
                }
                catch (Throwable t) {
                    this.logFaultyCallback(t);
                }
            }
        }

        private void logFaultyCallback(Throwable pThrowable) {
            Log.w((String)"OsmDroid", (String)"Error caught processing cachemanager callback, your implementation is faulty", (Throwable)pThrowable);
        }

        protected void onProgressUpdate(Integer ... count) {
            for (CacheManagerCallback callback : this.mCallbacks) {
                try {
                    callback.updateProgress(count[0], count[1], this.mZoomMin, this.mZoomMax);
                }
                catch (Throwable t) {
                    this.logFaultyCallback(t);
                }
            }
        }

        protected void onCancelled() {
            this.mManager.mPendingTasks.remove((Object)this);
        }

        protected void onPostExecute(Integer specialCount) {
            this.mManager.mPendingTasks.remove((Object)this);
            for (CacheManagerCallback callback : this.mCallbacks) {
                try {
                    if (specialCount == 0) {
                        callback.onTaskComplete();
                        continue;
                    }
                    callback.onTaskFailed(specialCount);
                }
                catch (Throwable t) {
                    this.logFaultyCallback(t);
                }
            }
        }

        protected Integer doInBackground(Object ... params) {
            if (!this.mAction.preCheck()) {
                return 0;
            }
            int tileCounter = 0;
            int errors = 0;
            Iterator iterator = this.mTiles.iterator();
            while (iterator.hasNext()) {
                long tile = (Long)iterator.next();
                int zoom = MapTileIndex.getZoom(tile);
                if (zoom >= this.mZoomMin && zoom <= this.mZoomMax && this.mAction.tileAction(tile)) {
                    ++errors;
                }
                if (++tileCounter % this.mAction.getProgressModulo() != 0) continue;
                if (this.isCancelled()) {
                    return errors;
                }
                this.publishProgress(new Integer[]{tileCounter, MapTileIndex.getZoom(tile)});
            }
            return errors;
        }
    }

    public static abstract class CacheManagerDialog
    implements CacheManagerCallback {
        private final CacheManagerTask mTask;
        private final ProgressDialog mProgressDialog;

        public CacheManagerDialog(final Context pCtx, CacheManagerTask pTask) {
            this.mTask = pTask;
            this.mProgressDialog = new ProgressDialog(pCtx);
            this.mProgressDialog.setProgressStyle(1);
            this.mProgressDialog.setCancelable(true);
            if (pTask.mManager.getVerifyCancel()) {
                this.mProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface cancelDialog) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(pCtx);
                        builder.setTitle((CharSequence)"Cancel map download");
                        builder.setMessage((CharSequence)"Do you want to cancel the map download?");
                        builder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                mTask.cancel(true);
                            }
                        });
                        builder.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                mProgressDialog.show();
                            }
                        });
                        builder.show();
                    }
                });
            } else {
                this.mProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        mTask.cancel(true);
                    }
                });
            }
        }

        protected String zoomMessage(int zoomLevel, int zoomMin, int zoomMax) {
            return "Handling zoom level: " + zoomLevel + " (from " + zoomMin + " to " + zoomMax + ")";
        }

        protected abstract String getUITitle();

        @Override
        public void updateProgress(int progress, int currentZoomLevel, int zoomMin, int zoomMax) {
            this.mProgressDialog.setProgress(progress);
            this.mProgressDialog.setMessage((CharSequence)this.zoomMessage(currentZoomLevel, zoomMin, zoomMax));
        }

        @Override
        public void downloadStarted() {
            this.mProgressDialog.setTitle((CharSequence)this.getUITitle());
            this.mProgressDialog.show();
        }

        @Override
        public void setPossibleTilesInArea(int total) {
            this.mProgressDialog.setMax(total);
        }

        @Override
        public void onTaskComplete() {
            this.dismiss();
        }

        @Override
        public void onTaskFailed(int errors) {
            this.dismiss();
        }

        private void dismiss() {
            if (this.mProgressDialog.isShowing()) {
                this.mProgressDialog.dismiss();
            }
        }
    }

    public static interface CacheManagerCallback {
        public void onTaskComplete();

        public void updateProgress(int var1, int var2, int var3, int var4);

        public void downloadStarted();

        public void setPossibleTilesInArea(int var1);

        public void onTaskFailed(int var1);
    }
}

