/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osmdroid.util.IterableWithSize;
import org.osmdroid.util.MapTileArea;
import org.osmdroid.util.MapTileContainer;

public class MapTileAreaList
implements MapTileContainer,
IterableWithSize<Long> {
    private final List<MapTileArea> mList = new ArrayList<MapTileArea>();

    public List<MapTileArea> getList() {
        return this.mList;
    }

    @Override
    public int size() {
        int size = 0;
        for (MapTileArea area : this.mList) {
            size += area.size();
        }
        return size;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private int mIndex;
            private Iterator<Long> mCurrent;

            @Override
            public boolean hasNext() {
                Iterator<Long> current = this.getCurrent();
                return current != null && current.hasNext();
            }

            @Override
            public Long next() {
                long result = this.getCurrent().next();
                if (!this.getCurrent().hasNext()) {
                    this.mCurrent = null;
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Iterator<Long> getCurrent() {
                if (this.mCurrent != null) {
                    return this.mCurrent;
                }
                if (this.mIndex < MapTileAreaList.this.mList.size()) {
                    this.mCurrent = ((MapTileArea)MapTileAreaList.this.mList.get(this.mIndex++)).iterator();
                    return this.mCurrent;
                }
                return null;
            }
        };
    }

    @Override
    public boolean contains(long pTileIndex) {
        for (MapTileArea area : this.mList) {
            if (!area.contains(pTileIndex)) continue;
            return true;
        }
        return false;
    }
}

