/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;

public class TileStates {
    private Collection<Runnable> mRunAfters = new LinkedHashSet<Runnable>();
    private boolean mDone;
    private int mTotal;
    private int mUpToDate;
    private int mExpired;
    private int mScaled;
    private int mNotFound;

    public Collection<Runnable> getRunAfters() {
        return this.mRunAfters;
    }

    public void initialiseLoop() {
        this.mDone = false;
        this.mTotal = 0;
        this.mUpToDate = 0;
        this.mExpired = 0;
        this.mScaled = 0;
        this.mNotFound = 0;
    }

    public void finaliseLoop() {
        this.mDone = true;
        for (Runnable runnable : this.mRunAfters) {
            if (runnable == null) continue;
            runnable.run();
        }
    }

    public void handleTile(Drawable pDrawable) {
        ++this.mTotal;
        if (pDrawable == null) {
            ++this.mNotFound;
        } else {
            int state = ExpirableBitmapDrawable.getState(pDrawable);
            switch (state) {
                case -1: {
                    ++this.mUpToDate;
                    break;
                }
                case -2: {
                    ++this.mExpired;
                    break;
                }
                case -3: {
                    ++this.mScaled;
                    break;
                }
                case -4: {
                    ++this.mNotFound;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown state: " + state);
                }
            }
        }
    }

    public boolean isDone() {
        return this.mDone;
    }

    public int getTotal() {
        return this.mTotal;
    }

    public int getUpToDate() {
        return this.mUpToDate;
    }

    public int getExpired() {
        return this.mExpired;
    }

    public int getScaled() {
        return this.mScaled;
    }

    public int getNotFound() {
        return this.mNotFound;
    }

    public String toString() {
        if (this.mDone) {
            return "TileStates: " + this.mTotal + " = " + this.mUpToDate + "(U) + " + this.mExpired + "(E) + " + this.mScaled + "(S) + " + this.mNotFound + "(N)";
        }
        return "TileStates";
    }
}

