/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.gestures;

import android.view.MotionEvent;

public class RotationGestureDetector {
    protected float mRotation;
    private RotationListener mListener;
    private boolean mEnabled = true;

    public RotationGestureDetector(RotationListener listener) {
        this.mListener = listener;
    }

    private static float rotation(MotionEvent event) {
        double delta_x = event.getX(0) - event.getX(1);
        double delta_y = event.getY(0) - event.getY(1);
        double radians = Math.atan2(delta_y, delta_x);
        return (float)Math.toDegrees(radians);
    }

    public void onTouch(MotionEvent e) {
        if (e.getPointerCount() != 2) {
            return;
        }
        if (e.getActionMasked() == 5) {
            this.mRotation = RotationGestureDetector.rotation(e);
        }
        float rotation = RotationGestureDetector.rotation(e);
        float delta = rotation - this.mRotation;
        if (this.mEnabled) {
            this.mRotation += delta;
            this.mListener.onRotate(delta);
        } else {
            this.mRotation = rotation;
        }
    }

    public void setEnabled(boolean pEnabled) {
        this.mEnabled = pEnabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public static interface RotationListener {
        public void onRotate(float var1);
    }
}

