/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.advancedpolyline;

import java.util.ArrayList;
import java.util.List;
import org.osmdroid.views.overlay.advancedpolyline.ColorMappingForScalar;

public class ColorMappingForScalarContainer {
    private final ColorMappingForScalar mInnerMapping;
    private final List<Float> mScalars = new ArrayList<Float>();
    private float mScalarMin = Float.MAX_VALUE;
    private float mScalarMax = Float.MIN_VALUE;

    public ColorMappingForScalarContainer(ColorMappingForScalar pInnerMapping) {
        this.mInnerMapping = pInnerMapping;
    }

    public ColorMappingForScalar getMappingForScalar() {
        return this.mInnerMapping;
    }

    public int size() {
        return this.mScalars.size();
    }

    public float getScalarMin() {
        return this.mScalarMin;
    }

    public float getScalarMax() {
        return this.mScalarMax;
    }

    public void add(float pScalar) {
        this.mInnerMapping.add(pScalar);
        this.mScalars.add(Float.valueOf(pScalar));
        if (this.mScalarMin > pScalar) {
            this.mScalarMin = pScalar;
        }
        if (this.mScalarMax < pScalar) {
            this.mScalarMax = pScalar;
        }
    }

    public void refresh() {
        int i = 0;
        for (float scalar : this.mScalars) {
            this.mInnerMapping.set(i, scalar);
            ++i;
        }
    }
}

