/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource.bing;

import org.json.JSONArray;
import org.json.JSONObject;
import org.osmdroid.tileprovider.tilesource.bing.ImageryMetaDataResource;

public class ImageryMetaData {
    private static final String STATUS_CODE = "statusCode";
    private static final String AUTH_RESULT_CODE = "authenticationResultCode";
    private static final String AUTH_RESULT_CODE_VALID = "ValidCredentials";
    private static final String RESOURCE_SETS = "resourceSets";
    private static final String ESTIMATED_TOTAL = "estimatedTotal";
    private static final String RESOURCE = "resources";

    public static ImageryMetaDataResource getInstanceFromJSON(String a_jsonContent) throws Exception {
        if (a_jsonContent == null) {
            throw new Exception("JSON to parse is null");
        }
        JSONObject jsonResult = new JSONObject(a_jsonContent);
        int statusCode = jsonResult.getInt(STATUS_CODE);
        if (statusCode != 200) {
            throw new Exception("Status code = " + statusCode);
        }
        if (AUTH_RESULT_CODE_VALID.compareToIgnoreCase(jsonResult.getString(AUTH_RESULT_CODE)) != 0) {
            throw new Exception("authentication result code = " + jsonResult.getString(AUTH_RESULT_CODE));
        }
        JSONArray resultsSet = jsonResult.getJSONArray(RESOURCE_SETS);
        if (resultsSet == null || resultsSet.length() < 1) {
            throw new Exception("No results set found in json response");
        }
        if (resultsSet.getJSONObject(0).getInt(ESTIMATED_TOTAL) <= 0) {
            throw new Exception("No resource found in json response");
        }
        JSONObject resource = resultsSet.getJSONObject(0).getJSONArray(RESOURCE).getJSONObject(0);
        return ImageryMetaDataResource.getInstanceFromJSON(resource, jsonResult);
    }
}

