/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import java.util.List;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.IconOverlay;

public abstract class ClickableIconOverlay<DataType>
extends IconOverlay {
    protected int mId = 0;
    private DataType mData = null;

    protected ClickableIconOverlay(DataType data) {
        this.mData = data;
    }

    protected abstract boolean onMarkerClicked(MapView var1, int var2, IGeoPoint var3, DataType var4);

    public ClickableIconOverlay set(int id, IGeoPoint position, Drawable icon, DataType data) {
        this.set(position, icon);
        this.mId = id;
        this.mData = data;
        return this;
    }

    protected boolean hitTest(MotionEvent event, MapView mapView) {
        Projection pj = mapView.getProjection();
        if (this.mPosition == null || this.mPositionPixels == null || pj == null) {
            return false;
        }
        pj.toPixels(this.mPosition, this.mPositionPixels);
        Rect screenRect = pj.getIntrinsicScreenRect();
        int x = -this.mPositionPixels.x + screenRect.left + (int)event.getX();
        int y = -this.mPositionPixels.y + screenRect.top + (int)event.getY();
        boolean hit = this.mIcon.getBounds().contains(x, y);
        return hit;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched) {
            return this.onMarkerClicked(mapView, this.mId, this.mPosition, this.mData);
        }
        return super.onSingleTapConfirmed(event, mapView);
    }

    @Override
    public boolean onLongPress(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched) {
            return this.onMarkerLongPress(mapView, this.mId, this.mPosition, this.mData);
        }
        return super.onLongPress(event, mapView);
    }

    protected boolean onMarkerLongPress(MapView mapView, int markerId, IGeoPoint geoPosition, Object data) {
        return false;
    }

    public static ClickableIconOverlay find(List<ClickableIconOverlay> list, int id) {
        for (ClickableIconOverlay item : list) {
            if (item == null || item.mId != id) continue;
            return item;
        }
        return null;
    }

    public int getID() {
        return this.mId;
    }

    public DataType getData() {
        return this.mData;
    }
}

