/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.gridlines;

import android.graphics.Canvas;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.FolderOverlay;
import org.osmdroid.views.overlay.Marker;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.Polyline;

public class LatLonGridlineOverlay2
extends Overlay {
    protected DecimalFormat mDecimalFormatter = new DecimalFormat("#.#####");
    protected int mLineColor = -16777216;
    protected int mFontColor = -1;
    protected short mFontSizeDp = (short)32;
    protected int mFontBackgroundColor = -16777216;
    protected float mLineWidth = 1.0f;
    protected float mMultiplier = 1.0f;
    protected FolderOverlay mLastOverlay = null;

    @Override
    public void draw(Canvas c, MapView osmv, boolean shadow) {
        if (shadow) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.mLastOverlay != null) {
            this.mLastOverlay.onDetach(osmv);
        }
        this.mLastOverlay = this.getLatLonGrid(osmv);
        this.mLastOverlay.draw(c, osmv, shadow);
    }

    public void setDecimalFormatter(DecimalFormat df) {
        this.mDecimalFormatter = df;
    }

    public void setLineColor(int lineColor) {
        this.mLineColor = lineColor;
    }

    public void setFontColor(int fontColor) {
        this.mFontColor = fontColor;
    }

    public void setFontSizeDp(short fontSizeDp) {
        this.mFontSizeDp = fontSizeDp;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mFontBackgroundColor = backgroundColor;
    }

    public void setLineWidth(float lineWidth) {
        this.mLineWidth = lineWidth;
    }

    public void setMultiplier(float multiplier) {
        this.mMultiplier = multiplier;
    }

    protected void applyMarkerAttributes(Marker m) {
        m.setTextLabelBackgroundColor(this.mFontBackgroundColor);
        m.setTextLabelFontSize(this.mFontSizeDp);
        m.setTextLabelForegroundColor(this.mFontColor);
    }

    protected FolderOverlay getLatLonGrid(MapView mapView) {
        BoundingBox box = mapView.getBoundingBox();
        int zoom = mapView.getZoomLevel();
        FolderOverlay gridlines = new FolderOverlay();
        if (zoom >= 2) {
            String title;
            Marker m;
            GeoPoint gx;
            ArrayList<GeoPoint> pts;
            Polyline p;
            double i;
            double north = box.getLatNorth();
            double south = box.getLatSouth();
            double east = box.getLonEast();
            double west = box.getLonWest();
            if (north < south) {
                return gridlines;
            }
            boolean dateLineVisible = false;
            if (east < 0.0 && west > 0.0) {
                dateLineVisible = true;
            }
            double incrementor = this.getIncrementor(zoom);
            double[] startend = this.getStartEndPointsNS(north, south, zoom);
            double sn_start_point = startend[0];
            double sn_stop_point = startend[1];
            for (double i2 = sn_start_point; i2 <= sn_stop_point; i2 += incrementor) {
                Polyline p2 = new Polyline();
                p2.setWidth(this.mLineWidth);
                p2.setColor(this.mLineColor);
                ArrayList<GeoPoint> pts2 = new ArrayList<GeoPoint>();
                GeoPoint gx2 = new GeoPoint(i2, east);
                pts2.add(gx2);
                gx2 = new GeoPoint(i2, west);
                pts2.add(gx2);
                p2.setPoints(pts2);
                gridlines.add(p2);
                Marker m2 = new Marker(mapView);
                this.applyMarkerAttributes(m2);
                String title2 = this.mDecimalFormatter.format(i2) + (i2 > 0.0 ? "N" : "S");
                m2.setTitle(title2);
                m2.setTextIcon(title2);
                m2.setPosition(new GeoPoint(i2, west + incrementor));
                gridlines.add(m2);
            }
            double[] ew = this.getStartEndPointsWE(west, east, zoom);
            double we_startpoint = ew[1];
            double ws_stoppoint = ew[0];
            for (i = we_startpoint; i <= ws_stoppoint; i += incrementor) {
                p = new Polyline();
                p.setWidth(this.mLineWidth);
                p.setColor(this.mLineColor);
                pts = new ArrayList<GeoPoint>();
                gx = new GeoPoint(north, i);
                pts.add(gx);
                gx = new GeoPoint(south, i);
                pts.add(gx);
                p.setPoints(pts);
                gridlines.add(p);
                m = new Marker(mapView);
                this.applyMarkerAttributes(m);
                m.setRotation(-90.0f);
                title = this.mDecimalFormatter.format(i) + (i > 0.0 ? "E" : "W");
                m.setTitle(title);
                m.setTextIcon(title);
                m.setPosition(new GeoPoint(south + incrementor, i));
                gridlines.add(m);
            }
            if (dateLineVisible) {
                for (i = we_startpoint; i <= 180.0; i += incrementor) {
                    p = new Polyline();
                    p.setWidth(this.mLineWidth);
                    p.setColor(this.mLineColor);
                    pts = new ArrayList();
                    gx = new GeoPoint(north, i);
                    pts.add(gx);
                    gx = new GeoPoint(south, i);
                    pts.add(gx);
                    p.setPoints(pts);
                    gridlines.add(p);
                }
                for (i = -180.0; i <= ws_stoppoint; i += incrementor) {
                    p = new Polyline();
                    p.setWidth(this.mLineWidth);
                    p.setColor(this.mLineColor);
                    pts = new ArrayList();
                    gx = new GeoPoint(north, i);
                    pts.add(gx);
                    gx = new GeoPoint(south, i);
                    pts.add(gx);
                    p.setPoints(pts);
                    gridlines.add(p);
                    m = new Marker(mapView);
                    this.applyMarkerAttributes(m);
                    m.setRotation(-90.0f);
                    title = this.mDecimalFormatter.format(i) + (i > 0.0 ? "E" : "W");
                    m.setTitle(title);
                    m.setTextIcon(title);
                    m.setPosition(new GeoPoint(south + incrementor, i));
                    gridlines.add(m);
                }
                for (i = we_startpoint; i < 180.0; i += incrementor) {
                    Marker m3 = new Marker(mapView);
                    this.applyMarkerAttributes(m3);
                    m3.setRotation(-90.0f);
                    String title3 = this.mDecimalFormatter.format(i) + (i > 0.0 ? "E" : "W");
                    m3.setTitle(title3);
                    m3.setTextIcon(title3);
                    m3.setPosition(new GeoPoint(south + incrementor, i));
                    gridlines.add(m3);
                }
            }
        }
        return gridlines;
    }

    protected double[] getStartEndPointsNS(double north, double south, int zoom) {
        if (zoom < 10) {
            double x;
            double sn_start_point = Math.floor(south);
            double incrementor = this.getIncrementor(zoom);
            for (x = -90.0; x < sn_start_point; x += incrementor) {
            }
            sn_start_point = x;
            double sn_stop_point = Math.ceil(north);
            for (x = 90.0; x > sn_stop_point; x -= incrementor) {
            }
            sn_stop_point = x;
            if (sn_stop_point > 90.0) {
                sn_stop_point = 90.0;
            }
            if (sn_start_point < -90.0) {
                sn_start_point = -90.0;
            }
            return new double[]{sn_start_point, sn_stop_point};
        }
        double sn_start_point = -90.0;
        if (south > 0.0) {
            sn_start_point = 0.0;
        }
        double sn_stop_point = 90.0;
        if (north < 0.0) {
            sn_stop_point = 0.0;
        }
        for (int xx = 2; xx <= zoom; ++xx) {
            double inc = this.getIncrementor(xx);
            while (sn_start_point < south - inc) {
                sn_start_point += inc;
            }
            while (sn_stop_point > north + inc) {
                sn_stop_point -= inc;
            }
        }
        return new double[]{sn_start_point, sn_stop_point};
    }

    protected double[] getStartEndPointsWE(double west, double east, int zoom) {
        double incrementor = this.getIncrementor(zoom);
        if (zoom < 10) {
            double x;
            double we_startpoint = Math.floor(west);
            for (x = 180.0; x > we_startpoint; x -= incrementor) {
            }
            we_startpoint = x;
            double ws_stoppoint = Math.ceil(east);
            for (x = -180.0; x < ws_stoppoint; x += incrementor) {
            }
            if (we_startpoint < -180.0) {
                we_startpoint = -180.0;
            }
            if (ws_stoppoint > 180.0) {
                ws_stoppoint = 180.0;
            }
            return new double[]{ws_stoppoint, we_startpoint};
        }
        double west_start_point = -180.0;
        if (west > 0.0) {
            west_start_point = 0.0;
        }
        double easter_stop_point = 180.0;
        if (east < 0.0) {
            easter_stop_point = 0.0;
        }
        for (int xx = 2; xx <= zoom; ++xx) {
            double inc = this.getIncrementor(xx);
            while (easter_stop_point > east + inc) {
                easter_stop_point -= inc;
            }
            while (west_start_point < west - inc) {
                west_start_point += inc;
            }
        }
        return new double[]{easter_stop_point, west_start_point};
    }

    protected double getIncrementor(int zoom) {
        switch (zoom) {
            case 0: 
            case 1: {
                return 30.0 * (double)this.mMultiplier;
            }
            case 2: {
                return 15.0 * (double)this.mMultiplier;
            }
            case 3: {
                return 9.0 * (double)this.mMultiplier;
            }
            case 4: {
                return 6.0 * (double)this.mMultiplier;
            }
            case 5: {
                return 3.0 * (double)this.mMultiplier;
            }
            case 6: {
                return 2.0 * (double)this.mMultiplier;
            }
            case 7: {
                return 1.0 * (double)this.mMultiplier;
            }
            case 8: {
                return 0.5 * (double)this.mMultiplier;
            }
            case 9: {
                return 0.25 * (double)this.mMultiplier;
            }
            case 10: {
                return 0.1 * (double)this.mMultiplier;
            }
            case 11: {
                return 0.05 * (double)this.mMultiplier;
            }
            case 12: {
                return 0.025 * (double)this.mMultiplier;
            }
            case 13: {
                return 0.0125 * (double)this.mMultiplier;
            }
            case 14: {
                return 0.00625 * (double)this.mMultiplier;
            }
            case 15: {
                return 0.003125 * (double)this.mMultiplier;
            }
            case 16: {
                return 0.0015625 * (double)this.mMultiplier;
            }
            case 17: {
                return 7.8125E-4 * (double)this.mMultiplier;
            }
            case 18: {
                return 3.90625E-4 * (double)this.mMultiplier;
            }
            case 19: {
                return 1.953125E-4 * (double)this.mMultiplier;
            }
            case 20: {
                return 9.765625E-5 * (double)this.mMultiplier;
            }
            case 21: {
                return 4.8828125E-5 * (double)this.mMultiplier;
            }
        }
        return 2.44140625E-5 * (double)this.mMultiplier;
    }
}

