/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.events;

import android.os.Handler;
import android.util.Log;
import org.osmdroid.events.MapEvent;
import org.osmdroid.events.MapListener;
import org.osmdroid.events.ScrollEvent;
import org.osmdroid.events.ZoomEvent;

public class DelayedMapListener
implements MapListener {
    protected static final int DEFAULT_DELAY = 100;
    MapListener wrappedListener;
    protected long delay;
    protected Handler handler;
    protected CallbackTask callback;

    public DelayedMapListener(MapListener wrappedListener, long delay) {
        this.wrappedListener = wrappedListener;
        this.delay = delay;
        this.handler = new Handler();
        this.callback = null;
    }

    public DelayedMapListener(MapListener wrappedListener) {
        this(wrappedListener, 100L);
    }

    @Override
    public boolean onScroll(ScrollEvent event) {
        this.dispatch(event);
        return true;
    }

    @Override
    public boolean onZoom(ZoomEvent event) {
        this.dispatch(event);
        return true;
    }

    protected void dispatch(MapEvent event) {
        if (this.callback != null) {
            this.handler.removeCallbacks((Runnable)this.callback);
        }
        this.callback = new CallbackTask(event);
        this.handler.postDelayed((Runnable)this.callback, this.delay);
    }

    private class CallbackTask
    implements Runnable {
        private final MapEvent event;

        public CallbackTask(MapEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (this.event instanceof ScrollEvent) {
                DelayedMapListener.this.wrappedListener.onScroll((ScrollEvent)this.event);
            } else if (this.event instanceof ZoomEvent) {
                DelayedMapListener.this.wrappedListener.onZoom((ZoomEvent)this.event);
            } else {
                Log.d((String)"OsmDroid", (String)("Unknown event received: " + this.event));
            }
        }
    }
}

