/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.library.R;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointL;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.LinearRing;
import org.osmdroid.views.overlay.OverlayWithIW;
import org.osmdroid.views.overlay.infowindow.BasicInfoWindow;
import org.osmdroid.views.overlay.infowindow.InfoWindow;
import org.osmdroid.views.overlay.milestones.MilestoneManager;

public class Polygon
extends OverlayWithIW {
    private final Path mPath = new Path();
    private LinearRing mOutline = new LinearRing(this.mPath);
    private ArrayList<LinearRing> mHoles = new ArrayList();
    protected static InfoWindow mDefaultInfoWindow = null;
    protected OnClickListener mOnClickListener;
    private Paint mFillPaint;
    private Paint mOutlinePaint;
    private List<MilestoneManager> mMilestoneManagers = new ArrayList<MilestoneManager>();
    private GeoPoint mInfoWindowLocation;

    public Polygon() {
        this((MapView)null);
    }

    public Polygon(MapView mapView) {
        if (mapView != null && (mDefaultInfoWindow == null || mDefaultInfoWindow.getMapView() != mapView)) {
            mDefaultInfoWindow = new BasicInfoWindow(R.layout.bonuspack_bubble, mapView);
        }
        this.setInfoWindow(mDefaultInfoWindow);
        this.mFillPaint = new Paint();
        this.mFillPaint.setColor(0);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mOutlinePaint = new Paint();
        this.mOutlinePaint.setColor(-16777216);
        this.mOutlinePaint.setStrokeWidth(10.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutlinePaint.setAntiAlias(true);
    }

    public int getFillColor() {
        return this.mFillPaint.getColor();
    }

    public int getStrokeColor() {
        return this.mOutlinePaint.getColor();
    }

    public float getStrokeWidth() {
        return this.mOutlinePaint.getStrokeWidth();
    }

    public Paint getOutlinePaint() {
        return this.mOutlinePaint;
    }

    public Paint getFillPaint() {
        return this.mFillPaint;
    }

    public void setGeodesic(boolean geodesic) {
        this.mOutline.setGeodesic(geodesic);
    }

    public boolean isGeodesic() {
        return this.mOutline.isGeodesic();
    }

    public List<GeoPoint> getPoints() {
        return this.mOutline.getPoints();
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public void setFillColor(int fillColor) {
        this.mFillPaint.setColor(fillColor);
    }

    public void setStrokeColor(int color) {
        this.mOutlinePaint.setColor(color);
    }

    public void setStrokeWidth(float width) {
        this.mOutlinePaint.setStrokeWidth(width);
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    @Override
    public void setInfoWindow(InfoWindow infoWindow) {
        if (this.mInfoWindow != null) {
            if (this.mInfoWindow.getRelatedObject() == this) {
                this.mInfoWindow.setRelatedObject(null);
            }
            if (this.mInfoWindow != mDefaultInfoWindow) {
                this.mInfoWindow.onDetach();
            }
        }
        this.mInfoWindow = infoWindow;
    }

    public void setPoints(List<GeoPoint> points) {
        this.mOutline.setPoints(points);
        this.setDefaultInfoWindowLocation();
    }

    public void addPoint(GeoPoint p) {
        this.mOutline.addPoint(p);
    }

    public void setHoles(List<? extends List<GeoPoint>> holes) {
        this.mHoles = new ArrayList(holes.size());
        for (List<GeoPoint> list : holes) {
            LinearRing newHole = new LinearRing(this.mPath);
            newHole.setGeodesic(this.mOutline.isGeodesic());
            newHole.setPoints(list);
            this.mHoles.add(newHole);
        }
    }

    public List<List<GeoPoint>> getHoles() {
        ArrayList<List<GeoPoint>> result = new ArrayList<List<GeoPoint>>(this.mHoles.size());
        for (LinearRing hole : this.mHoles) {
            result.add(hole.getPoints());
        }
        return result;
    }

    public static ArrayList<GeoPoint> pointsAsCircle(GeoPoint center, double radiusInMeters) {
        ArrayList<GeoPoint> circlePoints = new ArrayList<GeoPoint>(60);
        for (int f = 0; f < 360; f += 6) {
            GeoPoint onCircle = center.destinationPoint(radiusInMeters, f);
            circlePoints.add(onCircle);
        }
        return circlePoints;
    }

    public static ArrayList<IGeoPoint> pointsAsRect(BoundingBox rectangle) {
        ArrayList<IGeoPoint> points = new ArrayList<IGeoPoint>(4);
        points.add(new GeoPoint(rectangle.getLatNorth(), rectangle.getLonWest()));
        points.add(new GeoPoint(rectangle.getLatNorth(), rectangle.getLonEast()));
        points.add(new GeoPoint(rectangle.getLatSouth(), rectangle.getLonEast()));
        points.add(new GeoPoint(rectangle.getLatSouth(), rectangle.getLonWest()));
        return points;
    }

    public static ArrayList<IGeoPoint> pointsAsRect(GeoPoint center, double lengthInMeters, double widthInMeters) {
        ArrayList<IGeoPoint> points = new ArrayList<IGeoPoint>(4);
        GeoPoint east = center.destinationPoint(lengthInMeters * 0.5, 90.0);
        GeoPoint south = center.destinationPoint(widthInMeters * 0.5, 180.0);
        double westLon = center.getLongitude() * 2.0 - east.getLongitude();
        double northLat = center.getLatitude() * 2.0 - south.getLatitude();
        points.add(new GeoPoint(south.getLatitude(), east.getLongitude()));
        points.add(new GeoPoint(south.getLatitude(), westLon));
        points.add(new GeoPoint(northLat, westLon));
        points.add(new GeoPoint(northLat, east.getLongitude()));
        return points;
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        Projection pj = mapView.getProjection();
        this.mPath.rewind();
        this.mOutline.setClipArea(mapView);
        PointL offset = this.mOutline.buildPathPortion(pj, null, this.mMilestoneManagers.size() > 0);
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.init();
            milestoneManager.setDistances(this.mOutline.getDistances());
            for (PointL point : this.mOutline.getPointsForMilestones()) {
                milestoneManager.add(point.x, point.y);
            }
            milestoneManager.end();
        }
        for (LinearRing hole : this.mHoles) {
            hole.setClipArea(mapView);
            hole.buildPathPortion(pj, offset, this.mMilestoneManagers.size() > 0);
        }
        this.mPath.setFillType(Path.FillType.EVEN_ODD);
        canvas.drawPath(this.mPath, this.mFillPaint);
        canvas.drawPath(this.mPath, this.mOutlinePaint);
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.draw(canvas);
        }
        if (this.isInfoWindowOpen() && this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.mInfoWindow.draw();
        }
    }

    public void showInfoWindow() {
        if (this.mInfoWindow != null && this.mInfoWindowLocation != null) {
            this.mInfoWindow.open(this, this.mInfoWindowLocation, 0, 0);
        }
    }

    public boolean contains(MotionEvent event) {
        if (this.mPath.isEmpty()) {
            return false;
        }
        RectF bounds = new RectF();
        this.mPath.computeBounds(bounds, true);
        Region region = new Region();
        region.setPath(this.mPath, new Region((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom));
        return region.contains((int)event.getX(), (int)event.getY());
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        Projection pj = mapView.getProjection();
        GeoPoint eventPos = (GeoPoint)pj.fromPixels((int)event.getX(), (int)event.getY());
        boolean tapped = this.contains(event);
        if (tapped) {
            if (this.mOnClickListener == null) {
                return this.onClickDefault(this, mapView, eventPos);
            }
            return this.mOnClickListener.onClick(this, mapView, eventPos);
        }
        return tapped;
    }

    public GeoPoint getInfoWindowLocation() {
        return this.mInfoWindowLocation;
    }

    protected void setDefaultInfoWindowLocation() {
        int s = this.mOutline.getPoints().size();
        if (s == 0) {
            this.mInfoWindowLocation = new GeoPoint(0.0, 0.0);
            return;
        }
        this.mInfoWindowLocation = this.mOutline.getCenter(null);
    }

    public void setInfoWindowLocation(GeoPoint location) {
        this.mInfoWindowLocation = location;
    }

    @Override
    public void onDetach(MapView mapView) {
        this.mOutline = null;
        this.mHoles.clear();
        this.mMilestoneManagers.clear();
        this.onDestroy();
    }

    public void setMilestoneManagers(List<MilestoneManager> pMilestoneManagers) {
        if (pMilestoneManagers == null) {
            if (this.mMilestoneManagers.size() > 0) {
                this.mMilestoneManagers.clear();
            }
        } else {
            this.mMilestoneManagers = pMilestoneManagers;
        }
    }

    public boolean onClickDefault(Polygon polygon, MapView mapView, GeoPoint eventPos) {
        polygon.setInfoWindowLocation(eventPos);
        polygon.showInfoWindow();
        return true;
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public static interface OnClickListener {
        public boolean onClick(Polygon var1, MapView var2, GeoPoint var3);
    }
}

