/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

public class Distance {
    public static double getSquaredDistanceToPoint(double pFromX, double pFromY, double pToX, double pToY) {
        double dX = pFromX - pToX;
        double dY = pFromY - pToY;
        return dX * dX + dY * dY;
    }

    public static double getSquaredDistanceToLine(double pFromX, double pFromY, double pAX, double pAY, double pBX, double pBY) {
        if (pAX == pBX && pAY == pBY) {
            return Distance.getSquaredDistanceToPoint(pAX, pAY, pFromX, pFromY);
        }
        double cross = Distance.crossProduct(pAX, pAY, pBX, pBY, pFromX, pFromY);
        return cross * cross / Distance.getSquaredDistanceToPoint(pAX, pAY, pBX, pBY);
    }

    public static double getSquaredDistanceToSegment(double pFromX, double pFromY, double pAX, double pAY, double pBX, double pBY) {
        if (pAX == pBX && pAY == pBY) {
            return Distance.getSquaredDistanceToPoint(pAX, pAY, pFromX, pFromY);
        }
        double dot = Distance.dotProduct(pAX, pAY, pBX, pBY, pFromX, pFromY);
        if (dot > 0.0) {
            return Distance.getSquaredDistanceToPoint(pFromX, pFromY, pBX, pBY);
        }
        dot = Distance.dotProduct(pBX, pBY, pAX, pAY, pFromX, pFromY);
        if (dot > 0.0) {
            return Distance.getSquaredDistanceToPoint(pFromX, pFromY, pAX, pAY);
        }
        double cross = Distance.crossProduct(pAX, pAY, pBX, pBY, pFromX, pFromY);
        return cross * cross / Distance.getSquaredDistanceToPoint(pAX, pAY, pBX, pBY);
    }

    private static double crossProduct(double pAX, double pAY, double pBX, double pBY, double pCX, double pCY) {
        return (pBX - pAX) * (pCY - pAY) - (pBY - pAY) * (pCX - pAX);
    }

    private static double dotProduct(double pAX, double pAY, double pBX, double pBY, double pCX, double pCY) {
        return (pBX - pAX) * (pCX - pBX) + (pBY - pAY) * (pCY - pBY);
    }
}

