/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.mylocation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import java.util.LinkedList;
import org.osmdroid.api.IMapController;
import org.osmdroid.api.IMapView;
import org.osmdroid.config.Configuration;
import org.osmdroid.library.R;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointL;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.mylocation.GpsMyLocationProvider;
import org.osmdroid.views.overlay.mylocation.IMyLocationConsumer;
import org.osmdroid.views.overlay.mylocation.IMyLocationProvider;

public class MyLocationNewOverlay
extends Overlay
implements IMyLocationConsumer,
IOverlayMenuProvider,
Overlay.Snappable {
    protected Paint mPaint = new Paint();
    protected Paint mCirclePaint = new Paint();
    protected final float mScale;
    protected Bitmap mPersonBitmap;
    protected Bitmap mDirectionArrowBitmap;
    protected MapView mMapView;
    private IMapController mMapController;
    public IMyLocationProvider mMyLocationProvider;
    private final LinkedList<Runnable> mRunOnFirstFix = new LinkedList();
    private final PointL mMapCoordsProjected = new PointL();
    private final Point mMapCoordsTranslated = new Point();
    private Handler mHandler;
    private Object mHandlerToken = new Object();
    protected boolean enableAutoStop = true;
    private Location mLocation;
    private final GeoPoint mGeoPoint = new GeoPoint(0, 0);
    private boolean mIsLocationEnabled = false;
    protected boolean mIsFollowing = false;
    protected boolean mDrawAccuracyEnabled = true;
    protected final PointF mPersonHotspot;
    protected float mDirectionArrowCenterX;
    protected float mDirectionArrowCenterY;
    public static final int MENU_MY_LOCATION = MyLocationNewOverlay.getSafeMenuId();
    private boolean mOptionsMenuEnabled = true;
    private final float[] mMatrixValues = new float[9];
    private Matrix mMatrix = new Matrix();
    private Rect mMyLocationRect = new Rect();
    private Rect mMyLocationPreviousRect = new Rect();
    private boolean wasEnabledOnPause = false;

    public MyLocationNewOverlay(MapView mapView) {
        this(new GpsMyLocationProvider(mapView.getContext()), mapView);
    }

    public MyLocationNewOverlay(IMyLocationProvider myLocationProvider, MapView mapView) {
        this.mScale = mapView.getContext().getResources().getDisplayMetrics().density;
        this.mMapView = mapView;
        this.mMapController = mapView.getController();
        this.mCirclePaint.setARGB(0, 100, 100, 255);
        this.mCirclePaint.setAntiAlias(true);
        this.mPaint.setFilterBitmap(true);
        this.setDirectionArrow(((BitmapDrawable)mapView.getContext().getResources().getDrawable(R.drawable.person)).getBitmap(), ((BitmapDrawable)mapView.getContext().getResources().getDrawable(R.drawable.direction_arrow)).getBitmap());
        this.mPersonHotspot = new PointF(24.0f * this.mScale + 0.5f, 39.0f * this.mScale + 0.5f);
        this.mHandler = new Handler(Looper.getMainLooper());
        this.setMyLocationProvider(myLocationProvider);
    }

    public void setDirectionArrow(Bitmap personBitmap, Bitmap directionArrowBitmap) {
        this.mPersonBitmap = personBitmap;
        this.mDirectionArrowBitmap = directionArrowBitmap;
        this.mDirectionArrowCenterX = (float)this.mDirectionArrowBitmap.getWidth() / 2.0f - 0.5f;
        this.mDirectionArrowCenterY = (float)this.mDirectionArrowBitmap.getHeight() / 2.0f - 0.5f;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.wasEnabledOnPause) {
            this.enableFollowLocation();
        }
        this.enableMyLocation();
    }

    @Override
    public void onPause() {
        this.wasEnabledOnPause = this.mIsFollowing;
        this.disableMyLocation();
        super.onPause();
    }

    @Override
    public void onDetach(MapView mapView) {
        this.disableMyLocation();
        this.mMapView = null;
        this.mMapController = null;
        this.mHandler = null;
        this.mMatrix = null;
        this.mCirclePaint = null;
        this.mHandlerToken = null;
        this.mLocation = null;
        this.mMapController = null;
        this.mMyLocationPreviousRect = null;
        if (this.mMyLocationProvider != null) {
            this.mMyLocationProvider.destroy();
        }
        this.mMyLocationProvider = null;
        super.onDetach(mapView);
    }

    public void setDrawAccuracyEnabled(boolean drawAccuracyEnabled) {
        this.mDrawAccuracyEnabled = drawAccuracyEnabled;
    }

    public boolean isDrawAccuracyEnabled() {
        return this.mDrawAccuracyEnabled;
    }

    public IMyLocationProvider getMyLocationProvider() {
        return this.mMyLocationProvider;
    }

    protected void setMyLocationProvider(IMyLocationProvider myLocationProvider) {
        if (myLocationProvider == null) {
            throw new RuntimeException("You must pass an IMyLocationProvider to setMyLocationProvider()");
        }
        if (this.isMyLocationEnabled()) {
            this.stopLocationProvider();
        }
        this.mMyLocationProvider = myLocationProvider;
    }

    public void setPersonHotspot(float x, float y) {
        this.mPersonHotspot.set(x, y);
    }

    protected void drawMyLocation(Canvas canvas, MapView mapView, Location lastFix) {
        Projection pj = mapView.getProjection();
        pj.getPixelsFromProjected(this.mMapCoordsProjected, pj.getProjectedPowerDifference(), this.mMapCoordsTranslated);
        if (this.mDrawAccuracyEnabled) {
            float radius = lastFix.getAccuracy() / (float)TileSystem.GroundResolution(lastFix.getLatitude(), mapView.getZoomLevelDouble());
            this.mCirclePaint.setAlpha(50);
            this.mCirclePaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle((float)this.mMapCoordsTranslated.x, (float)this.mMapCoordsTranslated.y, radius, this.mCirclePaint);
            this.mCirclePaint.setAlpha(150);
            this.mCirclePaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle((float)this.mMapCoordsTranslated.x, (float)this.mMapCoordsTranslated.y, radius, this.mCirclePaint);
        }
        canvas.getMatrix(this.mMatrix);
        this.mMatrix.getValues(this.mMatrixValues);
        if (Configuration.getInstance().isDebugMode()) {
            float tx = (-this.mMatrixValues[2] + 20.0f) / this.mMatrixValues[0];
            float ty = (-this.mMatrixValues[5] + 90.0f) / this.mMatrixValues[4];
            canvas.drawText("Lat: " + lastFix.getLatitude(), tx, ty + 5.0f, this.mPaint);
            canvas.drawText("Lon: " + lastFix.getLongitude(), tx, ty + 20.0f, this.mPaint);
            canvas.drawText("Alt: " + lastFix.getAltitude(), tx, ty + 35.0f, this.mPaint);
            canvas.drawText("Acc: " + lastFix.getAccuracy(), tx, ty + 50.0f, this.mPaint);
        }
        float scaleX = (float)Math.sqrt(this.mMatrixValues[0] * this.mMatrixValues[0] + this.mMatrixValues[3] * this.mMatrixValues[3]);
        float scaleY = (float)Math.sqrt(this.mMatrixValues[4] * this.mMatrixValues[4] + this.mMatrixValues[1] * this.mMatrixValues[1]);
        if (lastFix.hasBearing()) {
            canvas.save();
            float mapRotation = mapView.getMapOrientation();
            mapRotation = lastFix.getBearing();
            if (mapRotation >= 360.0f) {
                mapRotation -= 360.0f;
            }
            canvas.rotate(mapRotation, (float)this.mMapCoordsTranslated.x, (float)this.mMapCoordsTranslated.y);
            canvas.scale(1.0f / scaleX, 1.0f / scaleY, (float)this.mMapCoordsTranslated.x, (float)this.mMapCoordsTranslated.y);
            canvas.drawBitmap(this.mDirectionArrowBitmap, (float)this.mMapCoordsTranslated.x - this.mDirectionArrowCenterX, (float)this.mMapCoordsTranslated.y - this.mDirectionArrowCenterY, this.mPaint);
            canvas.restore();
        } else {
            canvas.save();
            canvas.rotate(-this.mMapView.getMapOrientation(), (float)this.mMapCoordsTranslated.x, (float)this.mMapCoordsTranslated.y);
            canvas.scale(1.0f / scaleX, 1.0f / scaleY, (float)this.mMapCoordsTranslated.x, (float)this.mMapCoordsTranslated.y);
            canvas.drawBitmap(this.mPersonBitmap, (float)this.mMapCoordsTranslated.x - this.mPersonHotspot.x, (float)this.mMapCoordsTranslated.y - this.mPersonHotspot.y, this.mPaint);
            canvas.restore();
        }
    }

    protected Rect getMyLocationDrawingBounds(double zoomLevel, Location lastFix, Rect reuse) {
        if (reuse == null) {
            reuse = new Rect();
        }
        Projection pj = this.mMapView.getProjection();
        double powerDifference = pj.getProjectedPowerDifference();
        pj.getPixelsFromProjected(this.mMapCoordsProjected, powerDifference, this.mMapCoordsTranslated);
        if (lastFix.hasBearing()) {
            int widestEdge = (int)Math.ceil((double)Math.max(this.mDirectionArrowBitmap.getWidth(), this.mDirectionArrowBitmap.getHeight()) * Math.sqrt(2.0));
            reuse.set(this.mMapCoordsTranslated.x, this.mMapCoordsTranslated.y, this.mMapCoordsTranslated.x + widestEdge, this.mMapCoordsTranslated.y + widestEdge);
            reuse.offset(-widestEdge / 2, -widestEdge / 2);
        } else {
            reuse.set(this.mMapCoordsTranslated.x, this.mMapCoordsTranslated.y, this.mMapCoordsTranslated.x + this.mPersonBitmap.getWidth(), this.mMapCoordsTranslated.y + this.mPersonBitmap.getHeight());
            reuse.offset((int)(-this.mPersonHotspot.x + 0.5f), (int)(-this.mPersonHotspot.y + 0.5f));
        }
        if (this.mDrawAccuracyEnabled) {
            int radius = (int)Math.ceil(lastFix.getAccuracy() / (float)TileSystem.GroundResolution(lastFix.getLatitude(), zoomLevel));
            reuse.union(this.mMapCoordsTranslated.x - radius, this.mMapCoordsTranslated.y - radius, this.mMapCoordsTranslated.x + radius, this.mMapCoordsTranslated.y + radius);
            int strokeWidth = (int)Math.ceil(this.mCirclePaint.getStrokeWidth() == 0.0f ? 1.0 : (double)this.mCirclePaint.getStrokeWidth());
            reuse.inset(-strokeWidth, -strokeWidth);
        }
        return reuse;
    }

    @Override
    public void draw(Canvas c, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mLocation != null && this.isMyLocationEnabled()) {
            this.drawMyLocation(c, mapView, this.mLocation);
        }
    }

    @Override
    public boolean onSnapToItem(int x, int y, Point snapPoint, IMapView mapView) {
        if (this.mLocation != null) {
            boolean snap;
            Projection pj = this.mMapView.getProjection();
            double powerDifference = pj.getProjectedPowerDifference();
            pj.getPixelsFromProjected(this.mMapCoordsProjected, powerDifference, this.mMapCoordsTranslated);
            snapPoint.x = this.mMapCoordsTranslated.x;
            snapPoint.y = this.mMapCoordsTranslated.y;
            double xDiff = x - this.mMapCoordsTranslated.x;
            double yDiff = y - this.mMapCoordsTranslated.y;
            boolean bl = snap = xDiff * xDiff + yDiff * yDiff < 64.0;
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("snap=" + snap));
            }
            return snap;
        }
        return false;
    }

    public void setEnableAutoStop(boolean value) {
        this.enableAutoStop = value;
    }

    public boolean getEnableAutoStop() {
        return this.enableAutoStop;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (event.getAction() == 2) {
            if (this.enableAutoStop) {
                this.disableFollowLocation();
            } else {
                return true;
            }
        }
        return super.onTouchEvent(event, mapView);
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.add(0, MENU_MY_LOCATION + pMenuIdOffset, 0, (CharSequence)pMapView.getContext().getResources().getString(R.string.my_location)).setIcon(pMapView.getContext().getResources().getDrawable(R.drawable.ic_menu_mylocation)).setCheckable(true);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.findItem(MENU_MY_LOCATION + pMenuIdOffset).setChecked(this.isMyLocationEnabled());
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId == MENU_MY_LOCATION) {
            if (this.isMyLocationEnabled()) {
                this.disableFollowLocation();
                this.disableMyLocation();
            } else {
                this.enableFollowLocation();
                this.enableMyLocation();
            }
            return true;
        }
        return false;
    }

    public GeoPoint getMyLocation() {
        if (this.mLocation == null) {
            return null;
        }
        return new GeoPoint(this.mLocation);
    }

    public Location getLastFix() {
        return this.mLocation;
    }

    public void enableFollowLocation() {
        Location location;
        this.mIsFollowing = true;
        if (this.isMyLocationEnabled() && (location = this.mMyLocationProvider.getLastKnownLocation()) != null) {
            this.setLocation(location);
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    public void disableFollowLocation() {
        this.mIsFollowing = false;
    }

    public boolean isFollowLocationEnabled() {
        return this.mIsFollowing;
    }

    @Override
    public void onLocationChanged(final Location location, IMyLocationProvider source) {
        if (location != null && this.mHandler != null) {
            this.mHandler.postAtTime(new Runnable(){

                @Override
                public void run() {
                    MyLocationNewOverlay.this.setLocation(location);
                    for (Runnable runnable : MyLocationNewOverlay.this.mRunOnFirstFix) {
                        new Thread(runnable).start();
                    }
                    MyLocationNewOverlay.this.mRunOnFirstFix.clear();
                }
            }, this.mHandlerToken, 0L);
        }
    }

    protected void setLocation(Location location) {
        Location oldLocation = this.mLocation;
        if (oldLocation != null) {
            this.getMyLocationDrawingBounds(this.mMapView.getZoomLevelDouble(), oldLocation, this.mMyLocationPreviousRect);
        }
        this.mLocation = location;
        this.mMapView.getProjection().toProjectedPixels(this.mLocation.getLatitude(), this.mLocation.getLongitude(), this.mMapCoordsProjected);
        if (this.mIsFollowing) {
            this.mGeoPoint.setLatitude(this.mLocation.getLatitude());
            this.mGeoPoint.setLongitude(this.mLocation.getLongitude());
            this.mMapController.animateTo(this.mGeoPoint);
        } else {
            this.getMyLocationDrawingBounds(this.mMapView.getZoomLevelDouble(), this.mLocation, this.mMyLocationRect);
            if (oldLocation != null) {
                this.mMyLocationRect.union(this.mMyLocationPreviousRect);
            }
            int left = this.mMyLocationRect.left;
            int top = this.mMyLocationRect.top;
            int right = this.mMyLocationRect.right;
            int bottom = this.mMyLocationRect.bottom;
            this.mMapView.invalidateMapCoordinates(left, top, right, bottom);
        }
    }

    public boolean enableMyLocation(IMyLocationProvider myLocationProvider) {
        Location location;
        boolean success;
        this.setMyLocationProvider(myLocationProvider);
        this.mIsLocationEnabled = success = this.mMyLocationProvider.startLocationProvider(this);
        if (success && (location = this.mMyLocationProvider.getLastKnownLocation()) != null) {
            this.setLocation(location);
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
        return success;
    }

    public boolean enableMyLocation() {
        return this.enableMyLocation(this.mMyLocationProvider);
    }

    public void disableMyLocation() {
        this.mIsLocationEnabled = false;
        this.stopLocationProvider();
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    protected void stopLocationProvider() {
        if (this.mMyLocationProvider != null) {
            this.mMyLocationProvider.stopLocationProvider();
        }
        if (this.mHandler != null && this.mHandlerToken != null) {
            this.mHandler.removeCallbacksAndMessages(this.mHandlerToken);
        }
    }

    public boolean isMyLocationEnabled() {
        return this.mIsLocationEnabled;
    }

    public boolean runOnFirstFix(Runnable runnable) {
        if (this.mMyLocationProvider != null && this.mLocation != null) {
            new Thread(runnable).start();
            return true;
        }
        this.mRunOnFirstFix.addLast(runnable);
        return false;
    }

    public void setPersonIcon(Bitmap icon) {
        this.mPersonBitmap = icon;
    }
}

