/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.milestones;

import org.osmdroid.util.Distance;
import org.osmdroid.views.overlay.milestones.MilestoneLister;
import org.osmdroid.views.overlay.milestones.MilestoneStep;

public class MilestoneMeterDistanceLister
extends MilestoneLister {
    private final double mNbMetersRecurrence;
    private double mDistance;
    private int mIndex;

    public MilestoneMeterDistanceLister(double pNbMetersRecurrence) {
        this.mNbMetersRecurrence = pNbMetersRecurrence;
    }

    @Override
    public void init() {
        super.init();
        this.mDistance = 0.0;
        this.mIndex = 0;
    }

    @Override
    protected void add(long x0, long y0, long x1, long y1) {
        ++this.mIndex;
        double currentDistance = this.getDistance(this.mIndex);
        if (currentDistance == 0.0) {
            return;
        }
        double pixelDistance = Math.sqrt(Distance.getSquaredDistanceToPoint(x0, y0, x1, y1));
        double metersToPixels = pixelDistance / currentDistance;
        double orientation = MilestoneMeterDistanceLister.getOrientation(x0, y0, x1, y1);
        double x = x0;
        double y = y0;
        while (true) {
            double latestMilestone;
            double neededForNext;
            if (currentDistance < (neededForNext = (latestMilestone = Math.floor(this.mDistance / this.mNbMetersRecurrence) * this.mNbMetersRecurrence) + this.mNbMetersRecurrence - this.mDistance)) {
                this.mDistance += currentDistance;
                return;
            }
            this.mDistance += neededForNext;
            currentDistance -= neededForNext;
            this.add(new MilestoneStep((long)(x += neededForNext * Math.cos(Math.PI / 180 * orientation) * metersToPixels), (long)(y += neededForNext * Math.sin(Math.PI / 180 * orientation) * metersToPixels), orientation, this.mDistance));
        }
    }
}

