/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import android.widget.ZoomButtonsController;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.metalev.multitouch.controller.MultiTouchController;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IMapController;
import org.osmdroid.api.IMapView;
import org.osmdroid.config.Configuration;
import org.osmdroid.events.MapListener;
import org.osmdroid.events.ScrollEvent;
import org.osmdroid.events.ZoomEvent;
import org.osmdroid.tileprovider.MapTileProviderArray;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileProviderBasic;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.IStyledTileSource;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.tileprovider.util.SimpleInvalidationHandler;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.GeometryMath;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapController;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.DefaultOverlayManager;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.OverlayManager;
import org.osmdroid.views.overlay.TilesOverlay;

public class MapView
extends ViewGroup
implements IMapView,
MultiTouchController.MultiTouchObjectCanvas<Object> {
    private double mZoomLevel = 0.0;
    private OverlayManager mOverlayManager;
    protected Projection mProjection;
    private TilesOverlay mMapOverlay;
    private final GestureDetector mGestureDetector;
    private final Scroller mScroller;
    protected boolean mIsFlinging;
    private boolean mImpossibleFlinging;
    protected final AtomicBoolean mIsAnimating = new AtomicBoolean(false);
    protected Double mMinimumZoomLevel;
    protected Double mMaximumZoomLevel;
    private final MapController mController;
    private final ZoomButtonsController mZoomController;
    private boolean mEnableZoomController = false;
    private MultiTouchController<Object> mMultiTouchController;
    private final PointF mMultiTouchScaleInitPoint = new PointF();
    private final GeoPoint mMultiTouchScaleGeoPoint = new GeoPoint(0.0, 0.0);
    private PointF mMultiTouchScaleCurrentPoint;
    private float mapOrientation = 0.0f;
    private final Rect mInvalidateRect = new Rect();
    private boolean mScrollableAreaLimitLatitude;
    private double mScrollableAreaLimitNorth;
    private double mScrollableAreaLimitSouth;
    private boolean mScrollableAreaLimitLongitude;
    private double mScrollableAreaLimitWest;
    private double mScrollableAreaLimitEast;
    private int mScrollableAreaLimitExtraPixelWidth;
    private int mScrollableAreaLimitExtraPixelHeight;
    private MapTileProviderBase mTileProvider;
    private Handler mTileRequestCompleteHandler;
    private boolean mTilesScaledToDpi = false;
    private float mTilesScaleFactor = 1.0f;
    final Point mRotateScalePoint = new Point();
    private final Point mLayoutPoint = new Point();
    private final LinkedList<OnFirstLayoutListener> mOnFirstLayoutListeners = new LinkedList();
    private boolean mLayoutOccurred = false;
    private boolean horizontalMapRepetitionEnabled = true;
    private boolean verticalMapRepetitionEnabled = true;
    private GeoPoint mCenter;
    private long mMapScrollX;
    private long mMapScrollY;
    protected List<MapListener> mListners = new ArrayList<MapListener>();
    private double mStartAnimationZoom;
    private boolean enableFling = true;
    private boolean pauseFling = false;

    public MapView(Context context, MapTileProviderBase tileProvider, Handler tileRequestCompleteHandler, AttributeSet attrs) {
        this(context, tileProvider, tileRequestCompleteHandler, attrs, Configuration.getInstance().isMapViewHardwareAccelerated());
    }

    public MapView(Context context, MapTileProviderBase tileProvider, Handler tileRequestCompleteHandler, AttributeSet attrs, boolean hardwareAccelerated) {
        super(context, attrs);
        if (this.isInEditMode()) {
            this.mTileRequestCompleteHandler = null;
            this.mController = null;
            this.mZoomController = null;
            this.mScroller = null;
            this.mGestureDetector = null;
            return;
        }
        if (!hardwareAccelerated && Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.mController = new MapController(this);
        this.mScroller = new Scroller(context);
        if (tileProvider == null) {
            ITileSource tileSource = this.getTileSourceFromAttributes(attrs);
            tileProvider = this.isInEditMode() ? new MapTileProviderArray(tileSource, null, new MapTileModuleProviderBase[0]) : new MapTileProviderBasic(context.getApplicationContext(), tileSource);
        }
        this.mTileRequestCompleteHandler = tileRequestCompleteHandler == null ? new SimpleInvalidationHandler((View)this) : tileRequestCompleteHandler;
        this.mTileProvider = tileProvider;
        this.mTileProvider.setTileRequestCompleteHandler(this.mTileRequestCompleteHandler);
        this.updateTileSizeForDensity(this.mTileProvider.getTileSource());
        this.mMapOverlay = new TilesOverlay(this.mTileProvider, context, this.horizontalMapRepetitionEnabled, this.verticalMapRepetitionEnabled);
        this.mOverlayManager = new DefaultOverlayManager(this.mMapOverlay);
        if (this.isInEditMode()) {
            this.mZoomController = null;
        } else {
            this.mZoomController = new ZoomButtonsController((View)this);
            this.mZoomController.setOnZoomListener((ZoomButtonsController.OnZoomListener)new MapViewZoomListener());
        }
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MapViewGestureDetectorListener());
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)new MapViewDoubleClickListener());
        if (Configuration.getInstance().isMapViewRecyclerFriendly() && Build.VERSION.SDK_INT >= 16) {
            this.setHasTransientState(true);
        }
        this.setBuiltInZoomControls(true);
    }

    public MapView(Context context, AttributeSet attrs) {
        this(context, null, null, attrs);
    }

    public MapView(Context context) {
        this(context, null, null, null);
    }

    public MapView(Context context, MapTileProviderBase aTileProvider) {
        this(context, aTileProvider, null);
    }

    public MapView(Context context, MapTileProviderBase aTileProvider, Handler tileRequestCompleteHandler) {
        this(context, aTileProvider, tileRequestCompleteHandler, null);
    }

    @Override
    public IMapController getController() {
        return this.mController;
    }

    public List<Overlay> getOverlays() {
        return this.getOverlayManager().overlays();
    }

    public OverlayManager getOverlayManager() {
        return this.mOverlayManager;
    }

    public void setOverlayManager(OverlayManager overlayManager) {
        this.mOverlayManager = overlayManager;
    }

    public MapTileProviderBase getTileProvider() {
        return this.mTileProvider;
    }

    public Scroller getScroller() {
        return this.mScroller;
    }

    public Handler getTileRequestCompleteHandler() {
        return this.mTileRequestCompleteHandler;
    }

    @Override
    public double getLatitudeSpanDouble() {
        return this.getBoundingBox().getLatitudeSpan();
    }

    @Override
    public double getLongitudeSpanDouble() {
        return this.getBoundingBox().getLongitudeSpan();
    }

    public BoundingBox getBoundingBox() {
        return this.getProjection().getBoundingBox();
    }

    public Rect getScreenRect(Rect reuse) {
        Rect out = this.getIntrinsicScreenRect(reuse);
        if (this.getMapOrientation() != 0.0f && this.getMapOrientation() != 180.0f) {
            GeometryMath.getBoundingBoxForRotatatedRectangle(out, out.centerX(), out.centerY(), this.getMapOrientation(), out);
        }
        return out;
    }

    public Rect getIntrinsicScreenRect(Rect reuse) {
        Rect out = reuse == null ? new Rect() : reuse;
        out.set(0, 0, this.getWidth(), this.getHeight());
        return out;
    }

    @Override
    public Projection getProjection() {
        if (this.mProjection == null) {
            this.mProjection = new Projection(this);
            this.mProjection.adjustOffsets(this.mMultiTouchScaleGeoPoint, this.mMultiTouchScaleCurrentPoint);
            if (this.mScrollableAreaLimitLatitude) {
                this.mProjection.adjustOffsets(this.mScrollableAreaLimitNorth, this.mScrollableAreaLimitSouth, true, this.mScrollableAreaLimitExtraPixelHeight);
            }
            if (this.mScrollableAreaLimitLongitude) {
                this.mProjection.adjustOffsets(this.mScrollableAreaLimitWest, this.mScrollableAreaLimitEast, false, this.mScrollableAreaLimitExtraPixelWidth);
            }
            this.mImpossibleFlinging = this.mProjection.setMapScroll(this);
        }
        return this.mProjection;
    }

    @Deprecated
    protected void setProjection(Projection p) {
        this.mProjection = p;
    }

    private void resetProjection() {
        this.mProjection = null;
    }

    @Deprecated
    void setMapCenter(IGeoPoint aCenter) {
        this.getController().animateTo(aCenter);
    }

    @Deprecated
    void setMapCenter(int aLatitudeE6, int aLongitudeE6) {
        this.setMapCenter(new GeoPoint(aLatitudeE6, aLongitudeE6));
    }

    @Deprecated
    void setMapCenter(double aLatitude, double aLongitude) {
        this.setMapCenter(new GeoPoint(aLatitude, aLongitude));
    }

    public boolean isTilesScaledToDpi() {
        return this.mTilesScaledToDpi;
    }

    public void setTilesScaledToDpi(boolean tilesScaledToDpi) {
        this.mTilesScaledToDpi = tilesScaledToDpi;
        this.updateTileSizeForDensity(this.getTileProvider().getTileSource());
    }

    public float getTilesScaleFactor() {
        return this.mTilesScaleFactor;
    }

    public void setTilesScaleFactor(float pTilesScaleFactor) {
        this.mTilesScaleFactor = pTilesScaleFactor;
        this.updateTileSizeForDensity(this.getTileProvider().getTileSource());
    }

    public void resetTilesScaleFactor() {
        this.mTilesScaleFactor = 1.0f;
        this.updateTileSizeForDensity(this.getTileProvider().getTileSource());
    }

    private void updateTileSizeForDensity(ITileSource aTileSource) {
        int tile_size = aTileSource.getTileSizePixels();
        float density = this.getResources().getDisplayMetrics().density * 256.0f / (float)tile_size;
        int size = (int)((float)tile_size * (this.isTilesScaledToDpi() ? density * this.mTilesScaleFactor : this.mTilesScaleFactor));
        if (Configuration.getInstance().isDebugMapView()) {
            Log.d((String)"OsmDroid", (String)("Scaling tiles to " + size));
        }
        TileSystem.setTileSize(size);
    }

    public void setTileSource(ITileSource aTileSource) {
        this.mTileProvider.setTileSource(aTileSource);
        this.updateTileSizeForDensity(aTileSource);
        this.checkZoomButtons();
        this.setZoomLevel(this.mZoomLevel);
        this.postInvalidate();
    }

    double setZoomLevel(double aZoomLevel) {
        double curZoomLevel;
        double newZoomLevel = Math.max(this.getMinZoomLevel(), Math.min(this.getMaxZoomLevel(), aZoomLevel));
        if (newZoomLevel != (curZoomLevel = this.mZoomLevel)) {
            if (this.mScroller != null) {
                this.mScroller.forceFinished(true);
            }
            this.mIsFlinging = false;
        }
        GeoPoint centerGeoPoint = this.getProjection().getCurrentCenter();
        this.mZoomLevel = newZoomLevel;
        this.setExpectedCenter(centerGeoPoint);
        this.checkZoomButtons();
        if (this.isLayoutOccurred()) {
            this.getController().setCenter(centerGeoPoint);
            Point snapPoint = new Point();
            Projection pj = this.getProjection();
            if (this.getOverlayManager().onSnapToItem((int)this.mMultiTouchScaleInitPoint.x, (int)this.mMultiTouchScaleInitPoint.y, snapPoint, this)) {
                IGeoPoint geoPoint = pj.fromPixels(snapPoint.x, snapPoint.y, null, false);
                this.getController().animateTo(geoPoint);
            }
            this.mTileProvider.rescaleCache(pj, newZoomLevel, curZoomLevel, this.getScreenRect(null));
            this.pauseFling = true;
        }
        if (newZoomLevel != curZoomLevel) {
            ZoomEvent event = new ZoomEvent(this, newZoomLevel);
            for (MapListener mapListener : this.mListners) {
                mapListener.onZoom(event);
            }
        }
        this.invalidate();
        return this.mZoomLevel;
    }

    public void zoomToBoundingBox(BoundingBox boundingBox, boolean animated) {
        this.zoomToBoundingBox(boundingBox, animated, 0);
    }

    public void zoomToBoundingBox(BoundingBox boundingBox, boolean animated, int borderSizeInPixels) {
        double nextZoom = TileSystem.getBoundingBoxZoom(boundingBox, this.getWidth() - 2 * borderSizeInPixels, this.getHeight() - 2 * borderSizeInPixels);
        if (nextZoom == Double.MIN_VALUE) {
            return;
        }
        nextZoom = Math.min(this.getMaxZoomLevel(), Math.max(nextZoom, this.getMinZoomLevel()));
        GeoPoint center = boundingBox.getCenterWithDateLine();
        if (animated) {
            this.getController().setCenter(center);
            this.getController().zoomTo(nextZoom);
        } else {
            this.getController().setZoom(nextZoom);
            this.getController().setCenter(center);
        }
    }

    @Override
    @Deprecated
    public int getZoomLevel() {
        return (int)this.getZoomLevelDouble();
    }

    @Override
    public double getZoomLevelDouble() {
        return this.mZoomLevel;
    }

    @Deprecated
    public double getZoomLevel(boolean aPending) {
        return this.getZoomLevelDouble();
    }

    public double getMinZoomLevel() {
        return this.mMinimumZoomLevel == null ? (double)this.mMapOverlay.getMinimumZoomLevel() : this.mMinimumZoomLevel;
    }

    @Override
    public double getMaxZoomLevel() {
        return this.mMaximumZoomLevel == null ? (double)this.mMapOverlay.getMaximumZoomLevel() : this.mMaximumZoomLevel;
    }

    public void setMinZoomLevel(Double zoomLevel) {
        this.mMinimumZoomLevel = zoomLevel;
    }

    public void setMaxZoomLevel(Double zoomLevel) {
        this.mMaximumZoomLevel = zoomLevel;
    }

    public boolean canZoomIn() {
        return this.mZoomLevel < this.getMaxZoomLevel();
    }

    public boolean canZoomOut() {
        return this.mZoomLevel > this.getMinZoomLevel();
    }

    @Deprecated
    boolean zoomIn() {
        return this.getController().zoomIn();
    }

    @Deprecated
    boolean zoomInFixing(IGeoPoint point) {
        Point coords = this.getProjection().toPixels(point, null);
        return this.getController().zoomInFixing(coords.x, coords.y);
    }

    @Deprecated
    boolean zoomInFixing(int xPixel, int yPixel) {
        return this.getController().zoomInFixing(xPixel, yPixel);
    }

    @Deprecated
    boolean zoomOut() {
        return this.getController().zoomOut();
    }

    @Deprecated
    boolean zoomOutFixing(IGeoPoint point) {
        Point coords = this.getProjection().toPixels(point, null);
        return this.zoomOutFixing(coords.x, coords.y);
    }

    @Deprecated
    boolean zoomOutFixing(int xPixel, int yPixel) {
        return this.getController().zoomOutFixing(xPixel, yPixel);
    }

    @Override
    public IGeoPoint getMapCenter() {
        return this.getProjection().fromPixels(this.getWidth() / 2, this.getHeight() / 2, null, false);
    }

    public void setMapOrientation(float degrees) {
        this.setMapOrientation(degrees, true);
    }

    public void setMapOrientation(float degrees, boolean forceRedraw) {
        this.mapOrientation = degrees % 360.0f;
        if (forceRedraw) {
            this.invalidate();
        }
    }

    public float getMapOrientation() {
        return this.mapOrientation;
    }

    @Deprecated
    public float getMapScale() {
        return 1.0f;
    }

    public boolean useDataConnection() {
        return this.mMapOverlay.useDataConnection();
    }

    public void setUseDataConnection(boolean aMode) {
        this.mMapOverlay.setUseDataConnection(aMode);
    }

    public void setScrollableAreaLimitDouble(BoundingBox boundingBox) {
        if (boundingBox == null) {
            this.resetScrollableAreaLimitLatitude();
            this.resetScrollableAreaLimitLongitude();
        } else {
            this.setScrollableAreaLimitLatitude(boundingBox.getActualNorth(), boundingBox.getActualSouth(), 0);
            this.setScrollableAreaLimitLongitude(boundingBox.getLonWest(), boundingBox.getLonEast(), 0);
        }
    }

    public void resetScrollableAreaLimitLatitude() {
        this.mScrollableAreaLimitLatitude = false;
    }

    public void resetScrollableAreaLimitLongitude() {
        this.mScrollableAreaLimitLongitude = false;
    }

    public void setScrollableAreaLimitLatitude(double pNorth, double pSouth, int pExtraPixelHeight) {
        this.mScrollableAreaLimitLatitude = true;
        this.mScrollableAreaLimitNorth = pNorth;
        this.mScrollableAreaLimitSouth = pSouth;
        this.mScrollableAreaLimitExtraPixelHeight = pExtraPixelHeight;
    }

    public void setScrollableAreaLimitLongitude(double pWest, double pEast, int pExtraPixelWidth) {
        this.mScrollableAreaLimitLongitude = true;
        this.mScrollableAreaLimitWest = pWest;
        this.mScrollableAreaLimitEast = pEast;
        this.mScrollableAreaLimitExtraPixelWidth = pExtraPixelWidth;
    }

    public boolean isScrollableAreaLimitLatitude() {
        return this.mScrollableAreaLimitLatitude;
    }

    public boolean isScrollableAreaLimitLongitude() {
        return this.mScrollableAreaLimitLongitude;
    }

    public void invalidateMapCoordinates(Rect dirty) {
        this.invalidateMapCoordinates(dirty.left, dirty.top, dirty.right, dirty.bottom, false);
    }

    public void invalidateMapCoordinates(int left, int top, int right, int bottom) {
        this.invalidateMapCoordinates(left, top, right, bottom, false);
    }

    public void postInvalidateMapCoordinates(int left, int top, int right, int bottom) {
        this.invalidateMapCoordinates(left, top, right, bottom, true);
    }

    private void invalidateMapCoordinates(int left, int top, int right, int bottom, boolean post) {
        this.mInvalidateRect.set(left, top, right, bottom);
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        if (this.getMapOrientation() != 0.0f) {
            GeometryMath.getBoundingBoxForRotatatedRectangle(this.mInvalidateRect, centerX, centerY, this.getMapOrientation() + 180.0f, this.mInvalidateRect);
        }
        if (post) {
            super.postInvalidate(this.mInvalidateRect.left, this.mInvalidateRect.top, this.mInvalidateRect.right, this.mInvalidateRect.bottom);
        } else {
            super.invalidate(this.mInvalidateRect);
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, null, 8, 0, 0);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.myOnLayout(changed, l, t, r, b);
    }

    protected void myOnLayout(boolean changed, int l, int t, int r, int b) {
        this.resetProjection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            this.getProjection().toPixels(lp.geoPoint, this.mLayoutPoint);
            if (this.getMapOrientation() != 0.0f) {
                Point p = this.getProjection().rotateAndScalePoint(this.mLayoutPoint.x, this.mLayoutPoint.y, null);
                this.mLayoutPoint.x = p.x;
                this.mLayoutPoint.y = p.y;
            }
            long x = this.mLayoutPoint.x;
            long y = this.mLayoutPoint.y;
            long childLeft = x;
            long childTop = y;
            switch (lp.alignment) {
                case 1: {
                    childLeft = (long)this.getPaddingLeft() + x;
                    childTop = (long)this.getPaddingTop() + y;
                    break;
                }
                case 2: {
                    childLeft = (long)this.getPaddingLeft() + x - (long)(childWidth / 2);
                    childTop = (long)this.getPaddingTop() + y;
                    break;
                }
                case 3: {
                    childLeft = (long)this.getPaddingLeft() + x - (long)childWidth;
                    childTop = (long)this.getPaddingTop() + y;
                    break;
                }
                case 4: {
                    childLeft = (long)this.getPaddingLeft() + x;
                    childTop = (long)this.getPaddingTop() + y - (long)(childHeight / 2);
                    break;
                }
                case 5: {
                    childLeft = (long)this.getPaddingLeft() + x - (long)(childWidth / 2);
                    childTop = (long)this.getPaddingTop() + y - (long)(childHeight / 2);
                    break;
                }
                case 6: {
                    childLeft = (long)this.getPaddingLeft() + x - (long)childWidth;
                    childTop = (long)this.getPaddingTop() + y - (long)(childHeight / 2);
                    break;
                }
                case 7: {
                    childLeft = (long)this.getPaddingLeft() + x;
                    childTop = (long)this.getPaddingTop() + y - (long)childHeight;
                    break;
                }
                case 8: {
                    childLeft = (long)this.getPaddingLeft() + x - (long)(childWidth / 2);
                    childTop = (long)this.getPaddingTop() + y - (long)childHeight;
                    break;
                }
                case 9: {
                    childLeft = (long)this.getPaddingLeft() + x - (long)childWidth;
                    childTop = (long)this.getPaddingTop() + y - (long)childHeight;
                }
            }
            child.layout(TileSystem.truncateToInt(childLeft += (long)lp.offsetX), TileSystem.truncateToInt(childTop += (long)lp.offsetY), TileSystem.truncateToInt(childLeft + (long)childWidth), TileSystem.truncateToInt(childTop + (long)childHeight));
        }
        if (!this.isLayoutOccurred()) {
            this.mLayoutOccurred = true;
            for (OnFirstLayoutListener listener : this.mOnFirstLayoutListeners) {
                listener.onFirstLayout((View)this, l, t, r, b);
            }
            this.mOnFirstLayoutListeners.clear();
        }
        this.resetProjection();
    }

    public void addOnFirstLayoutListener(OnFirstLayoutListener listener) {
        if (!this.isLayoutOccurred()) {
            this.mOnFirstLayoutListeners.add(listener);
        }
    }

    public void removeOnFirstLayoutListener(OnFirstLayoutListener listener) {
        this.mOnFirstLayoutListeners.remove(listener);
    }

    public boolean isLayoutOccurred() {
        return this.mLayoutOccurred;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public void onPause() {
        this.getOverlayManager().onPause();
    }

    public void onResume() {
        this.getOverlayManager().onResume();
    }

    public void onDetach() {
        this.getOverlayManager().onDetach(this);
        this.mTileProvider.detach();
        this.mZoomController.setVisible(false);
        if (this.mTileRequestCompleteHandler instanceof SimpleInvalidationHandler) {
            ((SimpleInvalidationHandler)this.mTileRequestCompleteHandler).destroy();
        }
        this.mTileRequestCompleteHandler = null;
        if (this.mProjection != null) {
            this.mProjection.detach();
        }
        this.mProjection = null;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = this.getOverlayManager().onKeyDown(keyCode, event, this);
        return result || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean result = this.getOverlayManager().onKeyUp(keyCode, event, this);
        return result || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.getOverlayManager().onTrackballEvent(event, this)) {
            return true;
        }
        this.scrollBy((int)(event.getX() * 25.0f), (int)(event.getY() * 25.0f));
        return super.onTrackballEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(MotionEvent event) {
        if (Configuration.getInstance().isDebugMapView()) {
            Log.d((String)"OsmDroid", (String)("dispatchTouchEvent(" + event + ")"));
        }
        if (this.mZoomController.isVisible() && this.mZoomController.onTouch((View)this, event)) {
            return true;
        }
        MotionEvent rotatedEvent = this.rotateTouchEvent(event);
        try {
            if (super.dispatchTouchEvent(event)) {
                if (Configuration.getInstance().isDebugMapView()) {
                    Log.d((String)"OsmDroid", (String)"super handled onTouchEvent");
                }
                boolean bl = true;
                return bl;
            }
            if (this.getOverlayManager().onTouchEvent(rotatedEvent, this)) {
                boolean bl = true;
                return bl;
            }
            boolean handled = false;
            if (this.mMultiTouchController != null && this.mMultiTouchController.onTouchEvent(event)) {
                if (Configuration.getInstance().isDebugMapView()) {
                    Log.d((String)"OsmDroid", (String)"mMultiTouchController handled onTouchEvent");
                }
                handled = true;
            }
            if (this.mGestureDetector.onTouchEvent(rotatedEvent)) {
                if (Configuration.getInstance().isDebugMapView()) {
                    Log.d((String)"OsmDroid", (String)"mGestureDetector handled onTouchEvent");
                }
                handled = true;
            }
            if (handled) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (rotatedEvent != event) {
                rotatedEvent.recycle();
            }
        }
        if (Configuration.getInstance().isDebugMapView()) {
            Log.d((String)"OsmDroid", (String)"no-one handled onTouchEvent");
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    private MotionEvent rotateTouchEvent(MotionEvent ev) {
        if (this.getMapOrientation() == 0.0f) {
            return ev;
        }
        MotionEvent rotatedEvent = MotionEvent.obtain((MotionEvent)ev);
        if (Build.VERSION.SDK_INT < 11) {
            this.getProjection().unrotateAndScalePoint((int)ev.getX(), (int)ev.getY(), this.mRotateScalePoint);
            rotatedEvent.setLocation((float)this.mRotateScalePoint.x, (float)this.mRotateScalePoint.y);
        } else {
            rotatedEvent.transform(this.getProjection().getInvertedScaleRotateCanvasMatrix());
        }
        return rotatedEvent;
    }

    public void computeScroll() {
        if (this.mScroller != null && this.mScroller.computeScrollOffset()) {
            if (this.mScroller.isFinished()) {
                this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
                this.mIsFlinging = false;
            } else {
                this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            }
            this.postInvalidate();
        }
    }

    public void scrollTo(int x, int y) {
        this.setMapScroll(x, y);
        this.resetProjection();
        this.invalidate();
        if (this.getMapOrientation() != 0.0f) {
            this.myOnLayout(true, this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        }
        for (MapListener mapListener : this.mListners) {
            ScrollEvent event = new ScrollEvent(this, x, y);
            mapListener.onScroll(event);
        }
    }

    public void scrollBy(int x, int y) {
        this.scrollTo((int)(this.getMapScrollX() + (long)x), (int)(this.getMapScrollY() + (long)y));
    }

    @Override
    public void setBackgroundColor(int pColor) {
        this.mMapOverlay.setLoadingBackgroundColor(pColor);
        this.invalidate();
    }

    protected void dispatchDraw(Canvas c) {
        long startMs = System.currentTimeMillis();
        this.resetProjection();
        this.getProjection().save(c, true, false);
        try {
            this.getOverlayManager().onDraw(c, this);
            this.getProjection().restore(c, false);
            super.dispatchDraw(c);
        }
        catch (Exception ex) {
            Log.e((String)"OsmDroid", (String)"error dispatchDraw, probably in edit mode", (Throwable)ex);
        }
        if (Configuration.getInstance().isDebugMapView()) {
            long endMs = System.currentTimeMillis();
            Log.d((String)"OsmDroid", (String)("Rendering overall: " + (endMs - startMs) + "ms"));
        }
    }

    protected void onDetachedFromWindow() {
        this.mZoomController.setVisible(false);
        this.onDetach();
        this.mListners.clear();
        super.onDetachedFromWindow();
    }

    public boolean isAnimating() {
        return this.mIsAnimating.get();
    }

    @Override
    public Object getDraggableObjectAtPoint(MultiTouchController.PointInfo pt) {
        if (this.isAnimating()) {
            return null;
        }
        this.setMultiTouchScaleInitPoint(pt.getX(), pt.getY());
        return this;
    }

    @Override
    public void getPositionAndScale(Object obj, MultiTouchController.PositionAndScale objPosAndScaleOut) {
        this.startAnimation();
        objPosAndScaleOut.set(this.mMultiTouchScaleInitPoint.x, this.mMultiTouchScaleInitPoint.y, true, 1.0f, false, 0.0f, 0.0f, false, 0.0f);
    }

    @Override
    public void selectObject(Object obj, MultiTouchController.PointInfo pt) {
        this.resetMultiTouchScale();
    }

    @Override
    public boolean setPositionAndScale(Object obj, MultiTouchController.PositionAndScale aNewObjPosAndScale, MultiTouchController.PointInfo aTouchPoint) {
        this.setMultiTouchScaleCurrentPoint(aNewObjPosAndScale.getXOff(), aNewObjPosAndScale.getYOff());
        this.setMultiTouchScale(aNewObjPosAndScale.getScale());
        this.invalidate();
        return true;
    }

    public void resetMultiTouchScale() {
        this.mMultiTouchScaleCurrentPoint = null;
    }

    protected void setMultiTouchScaleInitPoint(float pX, float pY) {
        this.mMultiTouchScaleInitPoint.set(pX, pY);
        Point unRotatedPixel = this.getProjection().unrotateAndScalePoint((int)pX, (int)pY, null);
        this.getProjection().fromPixels(unRotatedPixel.x, unRotatedPixel.y, this.mMultiTouchScaleGeoPoint);
        this.setMultiTouchScaleCurrentPoint(pX, pY);
    }

    protected void setMultiTouchScaleCurrentPoint(float pX, float pY) {
        this.mMultiTouchScaleCurrentPoint = new PointF(pX, pY);
    }

    protected void setMultiTouchScale(float pMultiTouchScale) {
        this.setZoomLevel(Math.log(pMultiTouchScale) / Math.log(2.0) + this.mStartAnimationZoom);
    }

    protected void startAnimation() {
        this.mStartAnimationZoom = this.getZoomLevelDouble();
    }

    @Deprecated
    public void setMapListener(MapListener ml) {
        this.mListners.add(ml);
    }

    public void addMapListener(MapListener mapListener) {
        this.mListners.add(mapListener);
    }

    public void removeMapListener(MapListener mapListener) {
        this.mListners.remove(mapListener);
    }

    private void checkZoomButtons() {
        this.mZoomController.setZoomInEnabled(this.canZoomIn());
        this.mZoomController.setZoomOutEnabled(this.canZoomOut());
    }

    public void setBuiltInZoomControls(boolean on) {
        this.mEnableZoomController = on;
        this.checkZoomButtons();
    }

    public void setMultiTouchControls(boolean on) {
        this.mMultiTouchController = on ? new MultiTouchController<Object>(this, false) : null;
    }

    public boolean isHorizontalMapRepetitionEnabled() {
        return this.horizontalMapRepetitionEnabled;
    }

    public void setHorizontalMapRepetitionEnabled(boolean horizontalMapRepetitionEnabled) {
        this.horizontalMapRepetitionEnabled = horizontalMapRepetitionEnabled;
        this.mMapOverlay.setHorizontalWrapEnabled(horizontalMapRepetitionEnabled);
        this.resetProjection();
        this.invalidate();
    }

    public boolean isVerticalMapRepetitionEnabled() {
        return this.verticalMapRepetitionEnabled;
    }

    public void setVerticalMapRepetitionEnabled(boolean verticalMapRepetitionEnabled) {
        this.verticalMapRepetitionEnabled = verticalMapRepetitionEnabled;
        this.mMapOverlay.setVerticalWrapEnabled(verticalMapRepetitionEnabled);
        this.resetProjection();
        this.invalidate();
    }

    private ITileSource getTileSourceFromAttributes(AttributeSet aAttributeSet) {
        String tileSourceAttr;
        ITileSource tileSource = TileSourceFactory.DEFAULT_TILE_SOURCE;
        if (aAttributeSet != null && (tileSourceAttr = aAttributeSet.getAttributeValue(null, "tilesource")) != null) {
            try {
                ITileSource r = TileSourceFactory.getTileSource(tileSourceAttr);
                Log.i((String)"OsmDroid", (String)("Using tile source specified in layout attributes: " + r));
                tileSource = r;
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"OsmDroid", (String)("Invalid tile source specified in layout attributes: " + tileSource));
            }
        }
        if (aAttributeSet != null && tileSource instanceof IStyledTileSource) {
            String style = aAttributeSet.getAttributeValue(null, "style");
            if (style == null) {
                Log.i((String)"OsmDroid", (String)"Using default style: 1");
            } else {
                Log.i((String)"OsmDroid", (String)("Using style specified in layout attributes: " + style));
                ((IStyledTileSource)((Object)tileSource)).setStyle(style);
            }
        }
        Log.i((String)"OsmDroid", (String)("Using tile source: " + tileSource.name()));
        return tileSource;
    }

    public void setFlingEnabled(boolean b) {
        this.enableFling = b;
    }

    public boolean isFlingEnabled() {
        return this.enableFling;
    }

    public void setTileProvider(MapTileProviderBase base) {
        this.mTileProvider.detach();
        this.mTileProvider.clearTileCache();
        this.mTileProvider = base;
        this.mTileProvider.setTileRequestCompleteHandler(this.mTileRequestCompleteHandler);
        this.updateTileSizeForDensity(this.mTileProvider.getTileSource());
        this.mMapOverlay = new TilesOverlay(this.mTileProvider, this.getContext(), this.horizontalMapRepetitionEnabled, this.verticalMapRepetitionEnabled);
        this.mOverlayManager.setTilesOverlay(this.mMapOverlay);
        this.invalidate();
    }

    @Deprecated
    public void setInitCenter(IGeoPoint geoPoint) {
        this.setExpectedCenter(geoPoint);
    }

    public long getMapScrollX() {
        return this.mMapScrollX;
    }

    public long getMapScrollY() {
        return this.mMapScrollY;
    }

    void setMapScroll(long pMapScrollX, long pMapScrollY) {
        this.mMapScrollX = pMapScrollX;
        this.mMapScrollY = pMapScrollY;
    }

    GeoPoint getExpectedCenter() {
        return this.mCenter;
    }

    public void setExpectedCenter(IGeoPoint pGeoPoint) {
        this.mCenter = (GeoPoint)pGeoPoint;
        this.setMapScroll(0L, 0L);
        this.resetProjection();
        this.invalidate();
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int TOP_LEFT = 1;
        public static final int TOP_CENTER = 2;
        public static final int TOP_RIGHT = 3;
        public static final int CENTER_LEFT = 4;
        public static final int CENTER = 5;
        public static final int CENTER_RIGHT = 6;
        public static final int BOTTOM_LEFT = 7;
        public static final int BOTTOM_CENTER = 8;
        public static final int BOTTOM_RIGHT = 9;
        public IGeoPoint geoPoint;
        public int alignment;
        public int offsetX;
        public int offsetY;

        public LayoutParams(int width, int height, IGeoPoint geoPoint, int alignment, int offsetX, int offsetY) {
            super(width, height);
            this.geoPoint = geoPoint != null ? geoPoint : new GeoPoint(0.0, 0.0);
            this.alignment = alignment;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.geoPoint = new GeoPoint(0.0, 0.0);
            this.alignment = 8;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    private class MapViewZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private MapViewZoomListener() {
        }

        public void onZoom(boolean zoomIn) {
            if (zoomIn) {
                MapView.this.getController().zoomIn();
            } else {
                MapView.this.getController().zoomOut();
            }
        }

        public void onVisibilityChanged(boolean visible) {
        }
    }

    private class MapViewDoubleClickListener
    implements GestureDetector.OnDoubleTapListener {
        private MapViewDoubleClickListener() {
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (MapView.this.getOverlayManager().onDoubleTap(e, MapView.this)) {
                return true;
            }
            MapView.this.getProjection().rotateAndScalePoint((int)e.getX(), (int)e.getY(), MapView.this.mRotateScalePoint);
            return MapView.this.getController().zoomInFixing(MapView.this.mRotateScalePoint.x, MapView.this.mRotateScalePoint.y);
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return MapView.this.getOverlayManager().onDoubleTapEvent(e, MapView.this);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return MapView.this.getOverlayManager().onSingleTapConfirmed(e, MapView.this);
        }
    }

    private class MapViewGestureDetectorListener
    implements GestureDetector.OnGestureListener {
        private MapViewGestureDetectorListener() {
        }

        public boolean onDown(MotionEvent e) {
            if (MapView.this.mIsFlinging) {
                if (MapView.this.mScroller != null) {
                    MapView.this.mScroller.abortAnimation();
                }
                MapView.this.mIsFlinging = false;
            }
            if (MapView.this.getOverlayManager().onDown(e, MapView.this)) {
                return true;
            }
            MapView.this.mZoomController.setVisible(MapView.this.mEnableZoomController);
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!MapView.this.enableFling || MapView.this.pauseFling) {
                MapView.this.pauseFling = false;
                return false;
            }
            if (MapView.this.getOverlayManager().onFling(e1, e2, velocityX, velocityY, MapView.this)) {
                return true;
            }
            if (MapView.this.mImpossibleFlinging) {
                MapView.this.mImpossibleFlinging = false;
                return false;
            }
            MapView.this.mIsFlinging = true;
            if (MapView.this.mScroller != null) {
                MapView.this.mScroller.fling((int)MapView.this.getMapScrollX(), (int)MapView.this.getMapScrollY(), (int)(-velocityX), (int)(-velocityY), Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            if (MapView.this.mMultiTouchController != null && MapView.this.mMultiTouchController.isPinching()) {
                return;
            }
            MapView.this.getOverlayManager().onLongPress(e, MapView.this);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (MapView.this.getOverlayManager().onScroll(e1, e2, distanceX, distanceY, MapView.this)) {
                return true;
            }
            MapView.this.scrollBy((int)distanceX, (int)distanceY);
            return true;
        }

        public void onShowPress(MotionEvent e) {
            MapView.this.getOverlayManager().onShowPress(e, MapView.this);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return MapView.this.getOverlayManager().onSingleTapUp(e, MapView.this);
        }
    }

    public static interface OnFirstLayoutListener {
        public void onFirstLayout(View var1, int var2, int var3, int var4, int var5);
    }
}

