/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.constants.GeoConstants;
import org.osmdroid.views.util.constants.MathConstants;

public class GeoPoint
implements IGeoPoint,
MathConstants,
GeoConstants,
Parcelable,
Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private double mLongitude;
    private double mLatitude;
    private double mAltitude;
    public static final Parcelable.Creator<GeoPoint> CREATOR = new Parcelable.Creator<GeoPoint>(){

        public GeoPoint createFromParcel(Parcel in) {
            return new GeoPoint(in);
        }

        public GeoPoint[] newArray(int size) {
            return new GeoPoint[size];
        }
    };

    @Deprecated
    public GeoPoint(int aLatitudeE6, int aLongitudeE6) {
        this.mLatitude = (double)aLatitudeE6 / 1000000.0;
        this.mLongitude = (double)aLongitudeE6 / 1000000.0;
    }

    @Deprecated
    public GeoPoint(int aLatitudeE6, int aLongitudeE6, int aAltitude) {
        this.mLatitude = (double)aLatitudeE6 / 1000000.0;
        this.mLongitude = (double)aLongitudeE6 / 1000000.0;
        this.mAltitude = aAltitude;
    }

    public GeoPoint(double aLatitude, double aLongitude) {
        this.mLatitude = aLatitude;
        this.mLongitude = aLongitude;
    }

    public GeoPoint(double aLatitude, double aLongitude, double aAltitude) {
        this.mLatitude = aLatitude;
        this.mLongitude = aLongitude;
        this.mAltitude = aAltitude;
    }

    public GeoPoint(Location aLocation) {
        this(aLocation.getLatitude(), aLocation.getLongitude(), aLocation.getAltitude());
    }

    public GeoPoint(GeoPoint aGeopoint) {
        this.mLatitude = aGeopoint.mLatitude;
        this.mLongitude = aGeopoint.mLongitude;
        this.mAltitude = aGeopoint.mAltitude;
    }

    public static GeoPoint fromDoubleString(String s, char spacer) {
        int spacerPos1 = s.indexOf(spacer);
        int spacerPos2 = s.indexOf(spacer, spacerPos1 + 1);
        if (spacerPos2 == -1) {
            return new GeoPoint(Double.parseDouble(s.substring(0, spacerPos1)), Double.parseDouble(s.substring(spacerPos1 + 1, s.length())));
        }
        return new GeoPoint(Double.parseDouble(s.substring(0, spacerPos1)), Double.parseDouble(s.substring(spacerPos1 + 1, spacerPos2)), Double.parseDouble(s.substring(spacerPos2 + 1, s.length())));
    }

    public static GeoPoint fromInvertedDoubleString(String s, char spacer) {
        int spacerPos1 = s.indexOf(spacer);
        int spacerPos2 = s.indexOf(spacer, spacerPos1 + 1);
        if (spacerPos2 == -1) {
            return new GeoPoint(Double.parseDouble(s.substring(spacerPos1 + 1, s.length())), Double.parseDouble(s.substring(0, spacerPos1)));
        }
        return new GeoPoint(Double.parseDouble(s.substring(spacerPos1 + 1, spacerPos2)), Double.parseDouble(s.substring(0, spacerPos1)), Double.parseDouble(s.substring(spacerPos2 + 1, s.length())));
    }

    @Deprecated
    public static GeoPoint fromIntString(String s) {
        int commaPos1 = s.indexOf(44);
        int commaPos2 = s.indexOf(44, commaPos1 + 1);
        if (commaPos2 == -1) {
            return new GeoPoint(Integer.parseInt(s.substring(0, commaPos1)), Integer.parseInt(s.substring(commaPos1 + 1, s.length())));
        }
        return new GeoPoint(Integer.parseInt(s.substring(0, commaPos1)), Integer.parseInt(s.substring(commaPos1 + 1, commaPos2)), Integer.parseInt(s.substring(commaPos2 + 1, s.length())));
    }

    @Override
    public double getLongitude() {
        return this.mLongitude;
    }

    @Override
    public double getLatitude() {
        return this.mLatitude;
    }

    public double getAltitude() {
        return this.mAltitude;
    }

    public void setLatitude(double aLatitude) {
        this.mLatitude = aLatitude;
    }

    public void setLongitude(double aLongitude) {
        this.mLongitude = aLongitude;
    }

    public void setAltitude(double aAltitude) {
        this.mAltitude = aAltitude;
    }

    public void setCoords(double aLatitude, double aLongitude) {
        this.mLatitude = aLatitude;
        this.mLongitude = aLongitude;
    }

    public GeoPoint clone() {
        return new GeoPoint(this.mLatitude, this.mLongitude, this.mAltitude);
    }

    public String toIntString() {
        return (int)(this.mLatitude * 1000000.0) + "," + (int)(this.mLongitude * 1000000.0) + "," + (int)this.mAltitude;
    }

    public String toString() {
        return this.mLatitude + "," + this.mLongitude + "," + this.mAltitude;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GeoPoint rhs = (GeoPoint)obj;
        return rhs.mLatitude == this.mLatitude && rhs.mLongitude == this.mLongitude && rhs.mAltitude == this.mAltitude;
    }

    public int hashCode() {
        return 37 * (17 * (int)(this.mLatitude * 1.0E-6) + (int)(this.mLongitude * 1.0E-6)) + (int)this.mAltitude;
    }

    private GeoPoint(Parcel in) {
        this.mLatitude = in.readDouble();
        this.mLongitude = in.readDouble();
        this.mAltitude = in.readDouble();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.mLatitude);
        out.writeDouble(this.mLongitude);
        out.writeDouble(this.mAltitude);
    }

    public double distanceToAsDouble(IGeoPoint other) {
        double lat1 = Math.PI / 180 * this.getLatitude();
        double lat2 = Math.PI / 180 * other.getLatitude();
        double lon1 = Math.PI / 180 * this.getLongitude();
        double lon2 = Math.PI / 180 * other.getLongitude();
        return 1.2756274E7 * Math.asin(Math.min(1.0, Math.sqrt(Math.pow(Math.sin((lat2 - lat1) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon2 - lon1) / 2.0), 2.0))));
    }

    public double bearingTo(IGeoPoint other) {
        double lat1 = Math.toRadians(this.mLatitude);
        double long1 = Math.toRadians(this.mLongitude);
        double lat2 = Math.toRadians(other.getLatitude());
        double long2 = Math.toRadians(other.getLongitude());
        double delta_long = long2 - long1;
        double a = Math.sin(delta_long) * Math.cos(lat2);
        double b = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(delta_long);
        double bearing = Math.toDegrees(Math.atan2(a, b));
        double bearing_normalized = (bearing + 360.0) % 360.0;
        return bearing_normalized;
    }

    public GeoPoint destinationPoint(double aDistanceInMeters, double aBearingInDegrees) {
        double dist = aDistanceInMeters / 6378137.0;
        double brng = Math.PI / 180 * aBearingInDegrees;
        double lat1 = Math.PI / 180 * this.getLatitude();
        double lon1 = Math.PI / 180 * this.getLongitude();
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(dist) + Math.cos(lat1) * Math.sin(dist) * Math.cos(brng));
        double lon2 = lon1 + Math.atan2(Math.sin(brng) * Math.sin(dist) * Math.cos(lat1), Math.cos(dist) - Math.sin(lat1) * Math.sin(lat2));
        double lat2deg = lat2 / (Math.PI / 180);
        double lon2deg = lon2 / (Math.PI / 180);
        return new GeoPoint(lat2deg, lon2deg);
    }

    public static GeoPoint fromCenterBetween(GeoPoint geoPointA, GeoPoint geoPointB) {
        return new GeoPoint((geoPointA.getLatitude() + geoPointB.getLatitude()) / 2.0, (geoPointA.getLongitude() + geoPointB.getLongitude()) / 2.0);
    }

    public String toDoubleString() {
        return this.mLatitude + "," + this.mLongitude + "," + this.mAltitude;
    }

    public String toInvertedDoubleString() {
        return this.mLongitude + "," + this.mLatitude + "," + this.mAltitude;
    }

    @Override
    @Deprecated
    public int getLatitudeE6() {
        return (int)(this.getLatitude() * 1000000.0);
    }

    @Override
    @Deprecated
    public int getLongitudeE6() {
        return (int)(this.getLongitude() * 1000000.0);
    }
}

