/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.SqlTileWriter;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.MapTileIndex;

public class SqliteArchiveTileWriter
implements IFilesystemCache {
    final File db_file;
    final SQLiteDatabase db;
    final int questimate = 8000;
    static boolean hasInited = false;
    private static final String[] queryColumns = new String[]{"tile"};

    public SqliteArchiveTileWriter(String outputFile) throws Exception {
        this.db_file = new File(outputFile);
        try {
            this.db = SQLiteDatabase.openOrCreateDatabase((String)this.db_file.getAbsolutePath(), null);
        }
        catch (Exception ex) {
            throw new Exception("Trouble creating database file at " + outputFile, ex);
        }
        try {
            this.db.execSQL("CREATE TABLE IF NOT EXISTS tiles (key INTEGER , provider TEXT, tile BLOB, PRIMARY KEY (key, provider));");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Log.d((String)"OsmDroid", (String)"error setting db schema, it probably exists already", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile(ITileSource pTileSourceInfo, long pMapTileIndex, InputStream pStream, Long pExpirationTime) {
        ByteArrayOutputStream bos = null;
        try {
            int l;
            ContentValues cv = new ContentValues();
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            cv.put("provider", pTileSourceInfo.name());
            byte[] buffer = new byte[512];
            bos = new ByteArrayOutputStream();
            while ((l = pStream.read(buffer)) != -1) {
                bos.write(buffer, 0, l);
            }
            byte[] bits = bos.toByteArray();
            cv.put("key", Long.valueOf(index));
            cv.put("tile", bits);
            this.db.insert("tiles", null, cv);
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("tile inserted " + pTileSourceInfo.name() + MapTileIndex.toString(pMapTileIndex)));
            }
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex)), (Throwable)ex);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException cv) {}
        }
        return false;
    }

    @Override
    public boolean exists(ITileSource pTileSource, long pMapTileIndex) {
        try {
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            Cursor cur = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(index, pTileSource));
            boolean result = cur.getCount() != 0;
            cur.close();
            return result;
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSource.name() + " " + MapTileIndex.toString(pMapTileIndex)), (Throwable)ex);
            return false;
        }
    }

    @Override
    public void onDetach() {
        if (this.db != null) {
            this.db.close();
        }
    }

    @Override
    public boolean remove(ITileSource tileSource, long pMapTileIndex) {
        return false;
    }

    @Override
    public Long getExpirationTimestamp(ITileSource pTileSource, long pMapTileIndex) {
        return null;
    }

    public Cursor getTileCursor(String[] pPrimaryKeyParameters) {
        return this.db.query("tiles", queryColumns, SqlTileWriter.getPrimaryKey(), pPrimaryKeyParameters, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable loadTile(ITileSource pTileSource, long pMapTileIndex) throws Exception {
        Drawable drawable;
        block8: {
            byte[] bits;
            ByteArrayInputStream inputStream;
            block6: {
                Drawable drawable2;
                block7: {
                    inputStream = null;
                    try {
                        long index = SqlTileWriter.getIndex(pMapTileIndex);
                        Cursor cur = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(index, pTileSource));
                        bits = null;
                        if (cur.moveToFirst()) {
                            bits = cur.getBlob(cur.getColumnIndex("tile"));
                        }
                        cur.close();
                        if (bits != null) break block6;
                        if (Configuration.getInstance().isDebugMode()) {
                            Log.d((String)"OsmDroid", (String)("SqlCache - Tile doesn't exist: " + pTileSource.name() + MapTileIndex.toString(pMapTileIndex)));
                        }
                        drawable2 = null;
                        if (inputStream == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            StreamUtils.closeStream(inputStream);
                        }
                        throw throwable;
                    }
                    StreamUtils.closeStream(inputStream);
                }
                return drawable2;
            }
            inputStream = new ByteArrayInputStream(bits);
            drawable = pTileSource.getDrawable(inputStream);
            if (inputStream == null) break block8;
            StreamUtils.closeStream(inputStream);
        }
        return drawable;
    }
}

