/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteFullException;
import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.Counters;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.MapTileIndex;

public class SqlTileWriter
implements IFilesystemCache {
    public static final String DATABASE_FILENAME = "cache.db";
    public static final String COLUMN_EXPIRES = "expires";
    private static boolean cleanOnStartup = true;
    protected File db_file;
    protected SQLiteDatabase db;
    protected long lastSizeCheck = 0L;
    long tileSize = 0L;
    static boolean hasInited = false;
    private static final String primaryKey = "key=? and provider=?";
    private static final String[] queryColumns = new String[]{"tile", "expires"};
    private static final String[] expireQueryColumn = new String[]{"expires"};

    public static void setCleanupOnStart(boolean value) {
        cleanOnStartup = value;
    }

    public SqlTileWriter() {
        Configuration.getInstance().getOsmdroidTileCache().mkdirs();
        this.db_file = new File(Configuration.getInstance().getOsmdroidTileCache().getAbsolutePath() + File.separator + DATABASE_FILENAME);
        try {
            this.db = SQLiteDatabase.openOrCreateDatabase((File)this.db_file, null);
            this.db.execSQL("CREATE TABLE IF NOT EXISTS tiles (key INTEGER , provider TEXT, tile BLOB, expires INTEGER, PRIMARY KEY (key, provider));");
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)"Unable to start the sqlite tile writer. Check external storage availability.", (Throwable)ex);
        }
        if (!hasInited) {
            hasInited = true;
            if (cleanOnStartup) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        SqlTileWriter.this.runCleanupOperation();
                    }
                };
                t.setPriority(1);
                t.start();
            }
        }
    }

    public void runCleanupOperation() {
        block10: {
            if (this.db == null) {
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)"Finished init thread, aborted due to null database reference");
                }
                return;
            }
            try {
                if (this.db_file.length() <= Configuration.getInstance().getTileFileSystemCacheMaxBytes()) break block10;
                long now = System.currentTimeMillis();
                Log.i((String)"OsmDroid", (String)("Local cache is now " + this.db_file.length() + " max size is " + Configuration.getInstance().getTileFileSystemCacheMaxBytes()));
                long diff = this.db_file.length() - Configuration.getInstance().getTileFileSystemCacheTrimBytes();
                if (this.tileSize == 0L) {
                    long count = this.getRowCount(null);
                    long l = this.tileSize = count > 0L ? this.db_file.length() / count : 4000L;
                    if (Configuration.getInstance().isDebugMode()) {
                        Log.d((String)"OsmDroid", (String)("Number of cached tiles is " + count + ", mean size is " + this.tileSize));
                    }
                }
                long tilesToKill = diff / this.tileSize;
                Log.d((String)"OsmDroid", (String)("Local cache purging " + tilesToKill + " tiles."));
                if (tilesToKill > 0L) {
                    try {
                        this.db.execSQL("DELETE FROM tiles WHERE key in (SELECT key FROM tiles ORDER BY expires ASC LIMIT " + tilesToKill + ")");
                    }
                    catch (Throwable t) {
                        Log.e((String)"OsmDroid", (String)"error purging tiles from the tile cache", (Throwable)t);
                    }
                }
                Log.d((String)"OsmDroid", (String)("purge completed in " + (System.currentTimeMillis() - now) + "ms, cache size is " + this.db_file.length() + " bytes"));
            }
            catch (Exception ex) {
                if (!Configuration.getInstance().isDebugMode()) break block10;
                Log.d((String)"OsmDroid", (String)"SqliteTileWriter init thread crash, db is probably not available", (Throwable)ex);
            }
        }
        if (Configuration.getInstance().isDebugMode()) {
            Log.d((String)"OsmDroid", (String)"Finished init thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile(ITileSource pTileSourceInfo, long pMapTileIndex, InputStream pStream, Long pExpirationTime) {
        if (this.db == null || !this.db.isOpen()) {
            Log.d((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex) + ", database not available."));
            ++Counters.fileCacheSaveErrors;
            return false;
        }
        ByteArrayOutputStream bos = null;
        try {
            int l;
            ContentValues cv = new ContentValues();
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            cv.put("provider", pTileSourceInfo.name());
            byte[] buffer = new byte[512];
            bos = new ByteArrayOutputStream();
            while ((l = pStream.read(buffer)) != -1) {
                bos.write(buffer, 0, l);
            }
            byte[] bits = bos.toByteArray();
            cv.put("key", Long.valueOf(index));
            cv.put("tile", bits);
            if (pExpirationTime != null) {
                cv.put(COLUMN_EXPIRES, pExpirationTime);
            }
            this.db.delete("tiles", primaryKey, SqlTileWriter.getPrimaryKeyParameters(index, pTileSourceInfo));
            this.db.insert("tiles", null, cv);
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("tile inserted " + pTileSourceInfo.name() + MapTileIndex.toString(pMapTileIndex)));
            }
            if (System.currentTimeMillis() > this.lastSizeCheck + 300000L) {
                this.lastSizeCheck = System.currentTimeMillis();
                if (this.db_file != null && this.db_file.length() > Configuration.getInstance().getTileFileSystemCacheMaxBytes()) {
                    this.runCleanupOperation();
                }
            }
        }
        catch (SQLiteFullException ex) {
            this.runCleanupOperation();
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex) + " db is " + (this.db == null ? "null" : "not null")), (Throwable)ex);
            ++Counters.fileCacheSaveErrors;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ex) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String pTileSource, long pMapTileIndex) {
        if (this.db == null || !this.db.isOpen()) {
            Log.d((String)"OsmDroid", (String)("Unable to test for tile exists cached tile from " + pTileSource + " " + MapTileIndex.toString(pMapTileIndex) + ", database not available."));
            return false;
        }
        boolean returnValue = false;
        Cursor cur = null;
        try {
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            cur = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(index, pTileSource), expireQueryColumn);
            returnValue = cur.moveToNext();
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSource + " " + MapTileIndex.toString(pMapTileIndex)), (Throwable)ex);
        }
        finally {
            if (cur != null) {
                try {
                    cur.close();
                }
                catch (Throwable index) {}
            }
        }
        return returnValue;
    }

    @Override
    public boolean exists(ITileSource pTileSource, long pMapTileIndex) {
        return this.exists(pTileSource.name(), pMapTileIndex);
    }

    @Override
    public void onDetach() {
        if (this.db != null && this.db.isOpen()) {
            try {
                this.db.close();
                Log.i((String)"OsmDroid", (String)"Database detached");
            }
            catch (Exception ex) {
                Log.e((String)"OsmDroid", (String)"Database detach failed", (Throwable)ex);
            }
        }
        this.db = null;
        this.db_file = null;
    }

    public boolean purgeCache() {
        if (this.db != null && this.db.isOpen()) {
            try {
                this.db.delete("tiles", null, null);
                return true;
            }
            catch (Throwable e) {
                Log.w((String)"OsmDroid", (String)"Error purging the db", (Throwable)e);
            }
        }
        return false;
    }

    public boolean purgeCache(String mTileSourceName) {
        if (this.db != null && this.db.isOpen()) {
            try {
                this.db.delete("tiles", "provider = ?", new String[]{mTileSourceName});
                return true;
            }
            catch (Throwable e) {
                Log.w((String)"OsmDroid", (String)"Error purging the db", (Throwable)e);
            }
        }
        return false;
    }

    public int[] importFromFileCache(boolean removeFromFileSystem) {
        File[] tileSources;
        int[] ret = new int[]{0, 0, 0, 0};
        File tilePathBase = Configuration.getInstance().getOsmdroidTileCache();
        if (tilePathBase.exists() && (tileSources = tilePathBase.listFiles()) != null) {
            for (int i = 0; i < tileSources.length; ++i) {
                if (!tileSources[i].isDirectory() || tileSources[i].isHidden()) continue;
                File[] z = tileSources[i].listFiles();
                if (z != null) {
                    for (int zz = 0; zz < z.length; ++zz) {
                        File[] x;
                        if (z[zz].isDirectory() && !z[zz].isHidden() && (x = z[zz].listFiles()) != null) {
                            for (int xx = 0; xx < x.length; ++xx) {
                                if (x[xx].isDirectory() && !x[xx].isHidden()) {
                                    File[] y = x[xx].listFiles();
                                    if (x != null) {
                                        for (int yy = 0; yy < y.length; ++yy) {
                                            if (y[yy].isHidden() || y[yy].isDirectory()) continue;
                                            try {
                                                ContentValues cv = new ContentValues();
                                                long x1 = Long.parseLong(x[xx].getName());
                                                long y1 = Long.parseLong(y[yy].getName().substring(0, y[yy].getName().indexOf(".")));
                                                long z1 = Long.parseLong(z[zz].getName());
                                                long index = SqlTileWriter.getIndex(x1, y1, z1);
                                                cv.put("provider", tileSources[i].getName());
                                                if (this.exists(tileSources[i].getName(), MapTileIndex.getTileIndex((int)z1, (int)x1, (int)y1))) continue;
                                                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(y[yy]));
                                                ArrayList<Byte> list = new ArrayList<Byte>();
                                                int current = 0;
                                                while ((current = bis.read()) != -1) {
                                                    list.add((byte)current);
                                                }
                                                byte[] bits = new byte[list.size()];
                                                for (int bi = 0; bi < list.size(); ++bi) {
                                                    bits[bi] = (Byte)list.get(bi);
                                                }
                                                cv.put("key", Long.valueOf(index));
                                                cv.put("tile", bits);
                                                long insert = this.db.insert("tiles", null, cv);
                                                if (insert > 0L) {
                                                    if (Configuration.getInstance().isDebugMode()) {
                                                        Log.d((String)"OsmDroid", (String)("tile inserted " + tileSources[i].getName() + "/" + z1 + "/" + x1 + "/" + y1));
                                                    }
                                                    ret[0] = ret[0] + 1;
                                                    if (!removeFromFileSystem) continue;
                                                    try {
                                                        y[yy].delete();
                                                        ret[2] = ret[2] + 1;
                                                    }
                                                    catch (Exception ex) {
                                                        ret[3] = ret[3] + 1;
                                                    }
                                                    continue;
                                                }
                                                Log.w((String)"OsmDroid", (String)("tile NOT inserted " + tileSources[i].getName() + "/" + z1 + "/" + x1 + "/" + y1));
                                                continue;
                                            }
                                            catch (Throwable ex) {
                                                Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + tileSources[i].getName() + " db is " + (this.db == null ? "null" : "not null")), (Throwable)ex);
                                                ret[1] = ret[1] + 1;
                                            }
                                        }
                                    }
                                }
                                if (!removeFromFileSystem) continue;
                                try {
                                    x[xx].delete();
                                    continue;
                                }
                                catch (Exception ex) {
                                    Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + x[xx].getAbsolutePath()), (Throwable)ex);
                                    ret[3] = ret[3] + 1;
                                }
                            }
                        }
                        if (!removeFromFileSystem) continue;
                        try {
                            z[zz].delete();
                            continue;
                        }
                        catch (Exception ex) {
                            Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + z[zz].getAbsolutePath()), (Throwable)ex);
                            ret[3] = ret[3] + 1;
                        }
                    }
                }
                if (!removeFromFileSystem) continue;
                try {
                    tileSources[i].delete();
                    continue;
                }
                catch (Exception ex) {
                    Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + tileSources[i].getAbsolutePath()), (Throwable)ex);
                    ret[3] = ret[3] + 1;
                }
            }
        }
        return ret;
    }

    @Override
    public boolean remove(ITileSource pTileSourceInfo, long pMapTileIndex) {
        if (this.db == null) {
            Log.d((String)"OsmDroid", (String)("Unable to delete cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex) + ", database not available."));
            ++Counters.fileCacheSaveErrors;
            return false;
        }
        try {
            long index = SqlTileWriter.getIndex(pMapTileIndex);
            this.db.delete("tiles", primaryKey, SqlTileWriter.getPrimaryKeyParameters(index, pTileSourceInfo));
            return true;
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to delete cached tile from " + pTileSourceInfo.name() + " " + MapTileIndex.toString(pMapTileIndex) + " db is " + (this.db == null ? "null" : "not null")), (Throwable)ex);
            ++Counters.fileCacheSaveErrors;
            return false;
        }
    }

    public long getRowCount(String tileSourceName) {
        try {
            Cursor mCount = null;
            mCount = tileSourceName == null ? this.db.rawQuery("select count(*) from tiles", null) : this.db.rawQuery("select count(*) from tiles where provider=?", new String[]{tileSourceName});
            mCount.moveToFirst();
            long count = mCount.getLong(0);
            mCount.close();
            return count;
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to query for row count " + tileSourceName), (Throwable)ex);
            return 0L;
        }
    }

    public long getSize() {
        return this.db_file.length();
    }

    public long getFirstExpiry() {
        try {
            Cursor cursor = this.db.rawQuery("select min(expires) from tiles", null);
            cursor.moveToFirst();
            long time = cursor.getLong(0);
            cursor.close();
            return time;
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)"Unable to query for oldest tile", (Throwable)ex);
            return 0L;
        }
    }

    public static long getIndex(long pX, long pY, long pZ) {
        return ((pZ << (int)pZ) + pX << (int)pZ) + pY;
    }

    public static long getIndex(long pMapTileIndex) {
        return SqlTileWriter.getIndex(MapTileIndex.getX(pMapTileIndex), MapTileIndex.getY(pMapTileIndex), MapTileIndex.getZoom(pMapTileIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getExpirationTimestamp(ITileSource pTileSource, long pMapTileIndex) {
        try (Cursor cursor = null;){
            cursor = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(SqlTileWriter.getIndex(pMapTileIndex), pTileSource), expireQueryColumn);
            if (cursor.moveToNext()) {
                Long l = cursor.getLong(0);
                return l;
            }
        }
        return null;
    }

    public static String getPrimaryKey() {
        return primaryKey;
    }

    public static String[] getPrimaryKeyParameters(long pIndex, ITileSource pTileSourceInfo) {
        return SqlTileWriter.getPrimaryKeyParameters(pIndex, pTileSourceInfo.name());
    }

    public static String[] getPrimaryKeyParameters(long pIndex, String pTileSourceInfo) {
        return new String[]{String.valueOf(pIndex), pTileSourceInfo};
    }

    public Cursor getTileCursor(String[] pPrimaryKeyParameters, String[] pColumns) {
        return this.db.query("tiles", pColumns, primaryKey, pPrimaryKeyParameters, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable loadTile(ITileSource pTileSource, long pMapTileIndex) throws Exception {
        Drawable drawable;
        block10: {
            boolean fileExpired;
            long expirationTimestamp;
            byte[] bits;
            ByteArrayInputStream inputStream;
            block8: {
                Drawable drawable2;
                block9: {
                    inputStream = null;
                    try {
                        long index = SqlTileWriter.getIndex(pMapTileIndex);
                        Cursor cur = this.getTileCursor(SqlTileWriter.getPrimaryKeyParameters(index, pTileSource), queryColumns);
                        bits = null;
                        expirationTimestamp = 0L;
                        if (cur.moveToFirst()) {
                            bits = cur.getBlob(cur.getColumnIndex("tile"));
                            expirationTimestamp = cur.getLong(cur.getColumnIndex(COLUMN_EXPIRES));
                        }
                        cur.close();
                        if (bits != null) break block8;
                        if (Configuration.getInstance().isDebugMode()) {
                            Log.d((String)"OsmDroid", (String)("SqlCache - Tile doesn't exist: " + pTileSource.name() + MapTileIndex.toString(pMapTileIndex)));
                        }
                        drawable2 = null;
                        if (inputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            StreamUtils.closeStream(inputStream);
                        }
                        throw throwable;
                    }
                    StreamUtils.closeStream(inputStream);
                }
                return drawable2;
            }
            inputStream = new ByteArrayInputStream(bits);
            Drawable drawable3 = pTileSource.getDrawable(inputStream);
            long now = System.currentTimeMillis();
            boolean bl = fileExpired = expirationTimestamp < now;
            if (fileExpired && drawable3 != null) {
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)("Tile expired: " + pTileSource.name() + MapTileIndex.toString(pMapTileIndex)));
                }
                ExpirableBitmapDrawable.setState(drawable3, -2);
            }
            drawable = drawable3;
            if (inputStream == null) break block10;
            StreamUtils.closeStream(inputStream);
        }
        return drawable;
    }
}

