/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import microsoft.mappoint.TileSystem;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.MapTileIndex;

public class MapTileProviderArray
extends MapTileProviderBase {
    private final HashSet<Long> mWorking = new HashSet();
    private IRegisterReceiver mRegisterReceiver = null;
    protected final List<MapTileModuleProviderBase> mTileProviderList;

    protected MapTileProviderArray(ITileSource pTileSource, IRegisterReceiver pRegisterReceiver) {
        this(pTileSource, pRegisterReceiver, new MapTileModuleProviderBase[0]);
    }

    public MapTileProviderArray(ITileSource pTileSource, IRegisterReceiver aRegisterReceiver, MapTileModuleProviderBase[] pTileProviderArray) {
        super(pTileSource);
        this.mRegisterReceiver = aRegisterReceiver;
        this.mTileProviderList = new ArrayList<MapTileModuleProviderBase>();
        Collections.addAll(this.mTileProviderList, pTileProviderArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        Collection<Object> collection = this.mTileProviderList;
        synchronized (collection) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                tileProvider.detach();
            }
        }
        collection = this.mWorking;
        synchronized (collection) {
            this.mWorking.clear();
        }
        if (this.mRegisterReceiver != null) {
            this.mRegisterReceiver.destroy();
            this.mRegisterReceiver = null;
        }
        super.detach();
    }

    protected boolean isDowngradedMode() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Drawable getMapTile(long pMapTileIndex) {
        Drawable tile = this.mTileCache.getMapTile(pMapTileIndex);
        if (tile != null) {
            if (ExpirableBitmapDrawable.getState(tile) == -1) {
                return tile;
            }
            if (this.isDowngradedMode()) {
                return tile;
            }
        }
        if (this.mWorking.contains(pMapTileIndex)) {
            return tile;
        }
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)("MapTileProviderArray.getMapTile() requested but not in cache, trying from async providers: " + MapTileIndex.toString(pMapTileIndex)));
        }
        HashSet<Long> hashSet = this.mWorking;
        synchronized (hashSet) {
            if (this.mWorking.contains(pMapTileIndex)) {
                return tile;
            }
            this.mWorking.add(pMapTileIndex);
        }
        MapTileRequestState state = new MapTileRequestState(pMapTileIndex, this.mTileProviderList, (IMapTileProviderCallback)this);
        MapTileModuleProviderBase provider = this.findNextAppropriateProvider(state);
        if (provider != null) {
            provider.loadMapTileAsync(state);
        } else {
            this.mapTileRequestFailed(state);
        }
        return tile;
    }

    private void remove(long pMapTileIndex) {
        this.mWorking.remove(pMapTileIndex);
    }

    @Override
    public void mapTileRequestCompleted(MapTileRequestState aState, Drawable aDrawable) {
        this.remove(aState.getMapTile());
        super.mapTileRequestCompleted(aState, aDrawable);
    }

    @Override
    public void mapTileRequestFailed(MapTileRequestState aState) {
        MapTileModuleProviderBase nextProvider = this.findNextAppropriateProvider(aState);
        if (nextProvider != null) {
            nextProvider.loadMapTileAsync(aState);
        } else {
            this.remove(aState.getMapTile());
            super.mapTileRequestFailed(aState);
        }
    }

    @Override
    public void mapTileRequestFailedExceedsMaxQueueSize(MapTileRequestState aState) {
        this.remove(aState.getMapTile());
        super.mapTileRequestFailed(aState);
    }

    @Override
    public void mapTileRequestExpiredTile(MapTileRequestState aState, Drawable aDrawable) {
        super.mapTileRequestExpiredTile(aState, aDrawable);
        MapTileModuleProviderBase nextProvider = this.findNextAppropriateProvider(aState);
        if (nextProvider != null) {
            nextProvider.loadMapTileAsync(aState);
        } else {
            this.remove(aState.getMapTile());
        }
    }

    @Override
    public IFilesystemCache getTileWriter() {
        return null;
    }

    @Override
    public long getQueueSize() {
        if (this.mWorking != null) {
            return this.mWorking.size();
        }
        return -1L;
    }

    protected MapTileModuleProviderBase findNextAppropriateProvider(MapTileRequestState aState) {
        MapTileModuleProviderBase provider;
        boolean providerDoesntExist = false;
        boolean providerCantGetDataConnection = false;
        boolean providerCantServiceZoomlevel = false;
        do {
            if ((provider = aState.getNextProvider()) == null) continue;
            providerDoesntExist = !this.getProviderExists(provider);
            providerCantGetDataConnection = !this.useDataConnection() && provider.getUsesDataConnection();
            int zoomLevel = MapTileIndex.getZoom(aState.getMapTile());
            boolean bl = providerCantServiceZoomlevel = zoomLevel > provider.getMaximumZoomLevel() || zoomLevel < provider.getMinimumZoomLevel();
        } while (provider != null && (providerDoesntExist || providerCantGetDataConnection || providerCantServiceZoomlevel));
        return provider;
    }

    public boolean getProviderExists(MapTileModuleProviderBase provider) {
        return this.mTileProviderList.contains(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinimumZoomLevel() {
        int result = TileSystem.getMaximumZoomLevel();
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                if (tileProvider.getMinimumZoomLevel() >= result) continue;
                result = tileProvider.getMinimumZoomLevel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumZoomLevel() {
        int result = 0;
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                if (tileProvider.getMaximumZoomLevel() <= result) continue;
                result = tileProvider.getMaximumZoomLevel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTileSource(ITileSource aTileSource) {
        super.setTileSource(aTileSource);
        List<MapTileModuleProviderBase> list = this.mTileProviderList;
        synchronized (list) {
            for (MapTileModuleProviderBase tileProvider : this.mTileProviderList) {
                tileProvider.setTileSource(aTileSource);
                this.clearTileCache();
            }
        }
    }
}

