/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.library.R;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointL;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.LineDrawer;
import org.osmdroid.views.overlay.LinearRing;
import org.osmdroid.views.overlay.OverlayWithIW;
import org.osmdroid.views.overlay.infowindow.BasicInfoWindow;
import org.osmdroid.views.overlay.infowindow.InfoWindow;
import org.osmdroid.views.overlay.milestones.MilestoneManager;

public class Polyline
extends OverlayWithIW {
    private boolean mGeodesic;
    private final Paint mPaint = new Paint();
    private final LineDrawer mLineDrawer = new LineDrawer(256);
    private LinearRing mOutline = new LinearRing(this.mLineDrawer);
    private String id = null;
    private List<MilestoneManager> mMilestoneManagers = new ArrayList<MilestoneManager>();
    private GeoPoint mLastGeoPoint = null;
    protected static InfoWindow mDefaultInfoWindow = null;
    protected OnClickListener mOnClickListener;
    private GeoPoint infoWindowLocation = null;
    private float density = 1.0f;
    private ArrayList<GeoPoint> originalPoints = new ArrayList();

    public Polyline() {
        this((MapView)null);
    }

    public Polyline(MapView mapView) {
        if (mapView != null) {
            if (mDefaultInfoWindow == null || mDefaultInfoWindow.getMapView() != mapView) {
                mDefaultInfoWindow = new BasicInfoWindow(R.layout.bonuspack_bubble, mapView);
            }
            this.density = mapView.getContext().getResources().getDisplayMetrics().density;
        }
        this.setInfoWindow(mDefaultInfoWindow);
        this.mPaint.setColor(-16777216);
        this.mPaint.setStrokeWidth(10.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.clearPath();
        this.mGeodesic = false;
        this.mLineDrawer.setPaint(this.mPaint);
    }

    protected void clearPath() {
        this.mOutline.clearPath();
    }

    protected void addPoint(GeoPoint aPoint) {
        this.mOutline.addPoint(aPoint);
    }

    @Deprecated
    protected void addPoint(int aLatitudeE6, int aLongitudeE6) {
        this.addPoint(new GeoPoint(aLatitudeE6, aLongitudeE6));
    }

    public List<GeoPoint> getPoints() {
        return this.mOutline.getPoints();
    }

    public int getNumberOfPoints() {
        return this.getPoints().size();
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    public float getWidth() {
        return this.mPaint.getStrokeWidth();
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public boolean isGeodesic() {
        return this.mGeodesic;
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setWidth(float width) {
        this.mPaint.setStrokeWidth(width);
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    protected void addGreatCircle(GeoPoint startPoint, GeoPoint endPoint, int numberOfPoints) {
        double lat1 = startPoint.getLatitude() * (Math.PI / 180);
        double lon1 = startPoint.getLongitude() * (Math.PI / 180);
        double lat2 = endPoint.getLatitude() * (Math.PI / 180);
        double lon2 = endPoint.getLongitude() * (Math.PI / 180);
        double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
        double bearing = Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) / (-Math.PI / 180);
        bearing = bearing < 0.0 ? 360.0 + bearing : bearing;
        for (int i = 1; i <= numberOfPoints; ++i) {
            double f = 1.0 * (double)i / (double)(numberOfPoints + 1);
            double A = Math.sin((1.0 - f) * d) / Math.sin(d);
            double B = Math.sin(f * d) / Math.sin(d);
            double x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
            double y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
            double z = A * Math.sin(lat1) + B * Math.sin(lat2);
            double latN = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
            double lonN = Math.atan2(y, x);
            this.addPoint(new GeoPoint(latN * 57.29577951308232, lonN * 57.29577951308232));
        }
    }

    public void setPoints(List<GeoPoint> points) {
        this.clearPath();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            GeoPoint p = points.get(i);
            if (!this.mGeodesic) {
                this.addPoint(p);
                continue;
            }
            if (i > 0) {
                GeoPoint prev = points.get(i - 1);
                int greatCircleLength = (int)prev.distanceToAsDouble(p);
                int numberOfPoints = greatCircleLength / 100000;
                this.addGreatCircle(prev, p, numberOfPoints);
            }
            this.addPoint(p);
        }
    }

    public void setGeodesic(boolean geodesic) {
        this.mGeodesic = geodesic;
    }

    @Override
    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        Projection pj = mapView.getProjection();
        this.mLineDrawer.setCanvas(canvas);
        this.mOutline.setClipArea(mapView);
        this.mOutline.buildLinePortion(pj, this.mMilestoneManagers.size() > 0);
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.init();
            milestoneManager.setDistances(this.mOutline.getDistances());
            for (PointL point : this.mOutline.getPointsForMilestones()) {
                milestoneManager.add(point.x, point.y);
            }
            milestoneManager.end();
        }
        for (MilestoneManager milestoneManager : this.mMilestoneManagers) {
            milestoneManager.draw(canvas);
        }
        if (this.isInfoWindowOpen() && this.mInfoWindow != null && this.mInfoWindow.getRelatedObject() == this) {
            this.showInfoWindow(this.mLastGeoPoint);
        }
    }

    public boolean isCloseTo(GeoPoint point, double tolerance, MapView mapView) {
        return this.mOutline.isCloseTo(point, tolerance, mapView.getProjection(), false);
    }

    @Override
    public void setInfoWindow(InfoWindow infoWindow) {
        if (this.mInfoWindow != null) {
            if (this.mInfoWindow.getRelatedObject() == this) {
                this.mInfoWindow.setRelatedObject(null);
            }
            if (this.mInfoWindow != mDefaultInfoWindow) {
                this.mInfoWindow.onDetach();
            }
        }
        this.mInfoWindow = infoWindow;
    }

    public void showInfoWindow(GeoPoint position) {
        if (this.mInfoWindow != null) {
            this.mInfoWindow.open(this, position, 0, 0);
        }
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        double tolerance;
        Projection pj = mapView.getProjection();
        GeoPoint eventPos = (GeoPoint)pj.fromPixels((int)event.getX(), (int)event.getY());
        boolean touched = this.isCloseTo(eventPos, tolerance = (double)(this.mPaint.getStrokeWidth() * this.density), mapView);
        if (touched) {
            if (this.mOnClickListener == null) {
                return this.onClickDefault(this, mapView, eventPos);
            }
            return this.mOnClickListener.onClick(this, mapView, eventPos);
        }
        return touched;
    }

    public GeoPoint getInfoWindowAnchorPoint(GeoPoint eventPos) {
        if (this.infoWindowLocation == null) {
            return this.getPoints().get(0);
        }
        return this.infoWindowLocation;
    }

    public void setInfoWindowLocation(GeoPoint location) {
        this.infoWindowLocation = location;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected boolean onClickDefault(Polyline polyline, MapView mapView, GeoPoint eventPos) {
        this.mLastGeoPoint = eventPos;
        polyline.showInfoWindow(eventPos);
        return true;
    }

    @Override
    public void onDetach(MapView mapView) {
        this.mOutline = null;
        this.mOnClickListener = null;
        this.onDestroy();
    }

    public void setMilestoneManagers(List<MilestoneManager> pMilestoneManagers) {
        if (pMilestoneManagers == null) {
            if (this.mMilestoneManagers.size() > 0) {
                this.mMilestoneManagers.clear();
            }
        } else {
            this.mMilestoneManagers = pMilestoneManagers;
        }
    }

    public static interface OnClickListener {
        public boolean onClick(Polyline var1, MapView var2, GeoPoint var3);
    }
}

