/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

public class RectL {
    public long left;
    public long top;
    public long right;
    public long bottom;

    public RectL() {
    }

    public RectL(long pLeft, long pTop, long pRight, long pBottom) {
        this.set(pLeft, pTop, pRight, pBottom);
    }

    public RectL(RectL pOther) {
        this.set(pOther);
    }

    public void set(long pLeft, long pTop, long pRight, long pBottom) {
        this.left = pLeft;
        this.top = pTop;
        this.right = pRight;
        this.bottom = pBottom;
    }

    public void set(RectL pOther) {
        this.left = pOther.left;
        this.top = pOther.top;
        this.right = pOther.right;
        this.bottom = pOther.bottom;
    }

    public void union(long x, long y) {
        if (x < this.left) {
            this.left = x;
        } else if (x > this.right) {
            this.right = x;
        }
        if (y < this.top) {
            this.top = y;
        } else if (y > this.bottom) {
            this.bottom = y;
        }
    }

    public static boolean intersects(RectL a, RectL b) {
        return a.left < b.right && b.left < a.right && a.top < b.bottom && b.top < a.bottom;
    }

    public boolean contains(long x, long y) {
        return this.left < this.right && this.top < this.bottom && x >= this.left && x < this.right && y >= this.top && y < this.bottom;
    }

    public void inset(long dx, long dy) {
        this.left += dx;
        this.top += dy;
        this.right -= dx;
        this.bottom -= dy;
    }

    public final long width() {
        return this.right - this.left;
    }

    public final long height() {
        return this.bottom - this.top;
    }

    public String toString() {
        return "RectL(" + this.left + ", " + this.top + " - " + this.right + ", " + this.bottom + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RectL r = (RectL)o;
        return this.left == r.left && this.top == r.top && this.right == r.right && this.bottom == r.bottom;
    }

    public int hashCode() {
        long result = this.left;
        result = 31L * result + this.top;
        result = 31L * result + this.right;
        result = 31L * result + this.bottom;
        return (int)(result % Integer.MAX_VALUE);
    }
}

