/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import microsoft.mappoint.TileSystem;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.INetworkAvailablityCheck;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.Counters;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.osmdroid.util.MapTileIndex;

public class MapTileDownloader
extends MapTileModuleProviderBase {
    private final IFilesystemCache mFilesystemCache;
    private final AtomicReference<OnlineTileSourceBase> mTileSource = new AtomicReference();
    private final INetworkAvailablityCheck mNetworkAvailablityCheck;

    public MapTileDownloader(ITileSource pTileSource) {
        this(pTileSource, null, null);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache) {
        this(pTileSource, pFilesystemCache, null);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache, INetworkAvailablityCheck pNetworkAvailablityCheck) {
        this(pTileSource, pFilesystemCache, pNetworkAvailablityCheck, Configuration.getInstance().getTileDownloadThreads(), Configuration.getInstance().getTileDownloadMaxQueueSize());
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache, INetworkAvailablityCheck pNetworkAvailablityCheck, int pThreadPoolSize, int pPendingQueueSize) {
        super(pThreadPoolSize, pPendingQueueSize);
        this.mFilesystemCache = pFilesystemCache;
        this.mNetworkAvailablityCheck = pNetworkAvailablityCheck;
        this.setTileSource(pTileSource);
    }

    public ITileSource getTileSource() {
        return this.mTileSource.get();
    }

    @Override
    public boolean getUsesDataConnection() {
        return true;
    }

    @Override
    protected String getName() {
        return "Online Tile Download Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "downloader";
    }

    @Override
    public TileLoader getTileLoader() {
        return new TileLoader();
    }

    @Override
    public void detach() {
        super.detach();
        if (this.mFilesystemCache != null) {
            this.mFilesystemCache.onDetach();
        }
    }

    @Override
    public int getMinimumZoomLevel() {
        OnlineTileSourceBase tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        OnlineTileSourceBase tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    public void setTileSource(ITileSource tileSource) {
        if (tileSource instanceof OnlineTileSourceBase) {
            this.mTileSource.set((OnlineTileSourceBase)tileSource);
        } else {
            this.mTileSource.set(null);
        }
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
            super(MapTileDownloader.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Drawable loadTile(long pMapTileIndex) throws MapTileModuleProviderBase.CantContinueException {
            Drawable drawable;
            HttpURLConnection c;
            BufferedOutputStream out;
            InputStream in;
            block47: {
                Iterator<Map.Entry<String, String>> iterator;
                block45: {
                    OnlineTileSourceBase tileSource = (OnlineTileSourceBase)MapTileDownloader.this.mTileSource.get();
                    if (tileSource == null) {
                        return null;
                    }
                    in = null;
                    out = null;
                    c = null;
                    try {
                        Drawable result;
                        Long expirationTime;
                        ByteArrayOutputStream dataStream;
                        block46: {
                            if (MapTileDownloader.this.mNetworkAvailablityCheck != null && !MapTileDownloader.this.mNetworkAvailablityCheck.getNetworkAvailable()) {
                                if (Configuration.getInstance().isDebugMode()) {
                                    Log.d((String)"OsmDroid", (String)("Skipping " + MapTileDownloader.this.getName() + " due to NetworkAvailabliltyCheck."));
                                }
                                Drawable drawable2 = null;
                                return drawable2;
                            }
                            String tileURLString = tileSource.getTileURLString(pMapTileIndex);
                            if (Configuration.getInstance().isDebugMode()) {
                                Log.d((String)"OsmDroid", (String)("Downloading Maptile from url: " + tileURLString));
                            }
                            if (TextUtils.isEmpty((CharSequence)tileURLString)) {
                                Drawable drawable3 = null;
                                return drawable3;
                            }
                            c = Configuration.getInstance().getHttpProxy() != null ? (HttpURLConnection)new URL(tileURLString).openConnection(Configuration.getInstance().getHttpProxy()) : (HttpURLConnection)new URL(tileURLString).openConnection();
                            c.setUseCaches(true);
                            c.setRequestProperty(Configuration.getInstance().getUserAgentHttpHeader(), Configuration.getInstance().getUserAgentValue());
                            for (Map.Entry<String, String> entry : Configuration.getInstance().getAdditionalHttpRequestProperties().entrySet()) {
                                c.setRequestProperty(entry.getKey(), entry.getValue());
                            }
                            c.connect();
                            if (c.getResponseCode() != 200) {
                                Log.w((String)"OsmDroid", (String)("Problem downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " HTTP response: " + c.getResponseMessage()));
                                if (Configuration.getInstance().isDebugMapTileDownloader()) {
                                    Log.d((String)"OsmDroid", (String)tileURLString);
                                }
                                ++Counters.tileDownloadErrors;
                                iterator = null;
                                StreamUtils.closeStream(in);
                                break block45;
                            }
                            if (Configuration.getInstance().isDebugMapTileDownloader()) {
                                Log.d((String)"OsmDroid", (String)(tileURLString + " success"));
                            }
                            in = c.getInputStream();
                            dataStream = new ByteArrayOutputStream();
                            out = new BufferedOutputStream(dataStream, 8192);
                            Long override = Configuration.getInstance().getExpirationOverrideDuration();
                            expirationTime = null;
                            if (override != null) {
                                expirationTime = System.currentTimeMillis() + override;
                            } else {
                                expirationTime = System.currentTimeMillis() + 604800000L + Configuration.getInstance().getExpirationExtendedDuration();
                                String expires = c.getHeaderField("Expires");
                                if (expires != null && expires.length() > 0) {
                                    try {
                                        Date dateExpires = Configuration.getInstance().getHttpHeaderDateTimeFormat().parse(expires);
                                        expirationTime = dateExpires.getTime() + Configuration.getInstance().getExpirationExtendedDuration();
                                    }
                                    catch (Exception ex) {
                                        if (!Configuration.getInstance().isDebugMapTileDownloader()) break block46;
                                        Log.d((String)"OsmDroid", (String)("Unable to parse expiration tag for tile, using default, server returned " + expires), (Throwable)ex);
                                    }
                                }
                            }
                        }
                        StreamUtils.copy(in, out);
                        ((OutputStream)out).flush();
                        byte[] data = dataStream.toByteArray();
                        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
                        if (MapTileDownloader.this.mFilesystemCache != null) {
                            MapTileDownloader.this.mFilesystemCache.saveFile(tileSource, pMapTileIndex, byteStream, expirationTime);
                            byteStream.reset();
                        }
                        drawable = result = tileSource.getDrawable(byteStream);
                        StreamUtils.closeStream(in);
                        break block47;
                    }
                    catch (UnknownHostException e) {
                        Log.w((String)"OsmDroid", (String)("UnknownHostException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        ++Counters.tileDownloadErrors;
                        throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileDownloader.this, (Throwable)e);
                    }
                    catch (BitmapTileSourceBase.LowMemoryException e) {
                        ++Counters.countOOM;
                        Log.w((String)"OsmDroid", (String)("LowMemoryException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileDownloader.this, (Throwable)e);
                    }
                    catch (FileNotFoundException e) {
                        ++Counters.tileDownloadErrors;
                        Log.w((String)"OsmDroid", (String)("Tile not found: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        return null;
                    }
                    catch (IOException e) {
                        ++Counters.tileDownloadErrors;
                        Log.w((String)"OsmDroid", (String)("IOException downloading MapTile: " + MapTileIndex.toString(pMapTileIndex) + " : " + e));
                        return null;
                    }
                    catch (Throwable e) {
                        ++Counters.tileDownloadErrors;
                        Log.e((String)"OsmDroid", (String)("Error downloading MapTile: " + MapTileIndex.toString(pMapTileIndex)), (Throwable)e);
                        return null;
                    }
                }
                StreamUtils.closeStream(out);
                try {
                    c.disconnect();
                    return iterator;
                }
                catch (Exception entry) {
                    // empty catch block
                }
                return iterator;
            }
            StreamUtils.closeStream(out);
            try {
                c.disconnect();
                return drawable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return drawable;
            finally {
                StreamUtils.closeStream(in);
                StreamUtils.closeStream(out);
                try {
                    c.disconnect();
                }
                catch (Exception e) {}
            }
        }

        @Override
        protected void tileLoaded(MapTileRequestState pState, Drawable pDrawable) {
            MapTileDownloader.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestCompleted(pState, null);
            BitmapPool.getInstance().asyncRecycle(pDrawable);
        }
    }
}

