/*
 * Decompiled with CFR 0.152.
 */
package microsoft.mappoint;

import android.graphics.Point;
import org.osmdroid.util.GeoPoint;

public final class TileSystem {
    protected static int mTileSize = 256;
    private static final double EarthRadius = 6378137.0;
    private static final double MinLatitude = -85.05112878;
    private static final double MaxLatitude = 85.05112878;
    private static final double MinLongitude = -180.0;
    private static final double MaxLongitude = 180.0;
    private static int mMaxZoomLevel = 22;

    public static void setTileSize(int tileSize) {
        int pow2 = (int)(Math.log(tileSize) / Math.log(2.0));
        mMaxZoomLevel = 31 - pow2 - 1;
        mTileSize = tileSize;
    }

    public static int getTileSize() {
        return mTileSize;
    }

    public static int getMaximumZoomLevel() {
        return mMaxZoomLevel;
    }

    private static double Clip(double n, double minValue, double maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    public static int MapSize(int levelOfDetail) {
        return mTileSize << (levelOfDetail < TileSystem.getMaximumZoomLevel() ? levelOfDetail : TileSystem.getMaximumZoomLevel());
    }

    public static double GroundResolution(double latitude, int levelOfDetail) {
        latitude = TileSystem.Clip(latitude, -85.05112878, 85.05112878);
        return Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / (double)TileSystem.MapSize(levelOfDetail);
    }

    public static double MapScale(double latitude, int levelOfDetail, int screenDpi) {
        return TileSystem.GroundResolution(latitude, levelOfDetail) * (double)screenDpi / 0.0254;
    }

    public static Point LatLongToPixelXY(double latitude, double longitude, int levelOfDetail, Point reuse) {
        Point out = reuse == null ? new Point() : reuse;
        latitude = TileSystem.Clip(latitude, -85.05112878, 85.05112878);
        longitude = TileSystem.Clip(longitude, -180.0, 180.0);
        double x = (longitude + 180.0) / 360.0;
        double sinLatitude = Math.sin(latitude * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        int mapSize = TileSystem.MapSize(levelOfDetail);
        out.x = (int)TileSystem.Clip(x * (double)mapSize + 0.5, 0.0, mapSize - 1);
        out.y = (int)TileSystem.Clip(y * (double)mapSize + 0.5, 0.0, mapSize - 1);
        return out;
    }

    public static GeoPoint PixelXYToLatLong(int pixelX, int pixelY, int levelOfDetail, GeoPoint reuse) {
        GeoPoint out = reuse == null ? new GeoPoint(0, 0) : reuse;
        double mapSize = TileSystem.MapSize(levelOfDetail);
        double x = TileSystem.Clip(pixelX, 0.0, mapSize - 1.0) / mapSize - 0.5;
        double y = 0.5 - TileSystem.Clip(pixelY, 0.0, mapSize - 1.0) / mapSize;
        double latitude = 90.0 - 360.0 * Math.atan(Math.exp(-y * 2.0 * Math.PI)) / Math.PI;
        double longitude = 360.0 * x;
        out.setLatitude(latitude);
        out.setLongitude(longitude);
        return out;
    }

    public static Point PixelXYToTileXY(int pixelX, int pixelY, Point reuse) {
        Point out = reuse == null ? new Point() : reuse;
        out.x = pixelX / mTileSize;
        out.y = pixelY / mTileSize;
        return out;
    }

    public static Point TileXYToPixelXY(int tileX, int tileY, Point reuse) {
        Point out = reuse == null ? new Point() : reuse;
        out.x = tileX * mTileSize;
        out.y = tileY * mTileSize;
        return out;
    }

    public static String TileXYToQuadKey(int tileX, int tileY, int levelOfDetail) {
        StringBuilder quadKey = new StringBuilder();
        for (int i = levelOfDetail; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tileX & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((tileY & mask) != 0) {
                digit = (char)(digit + 1);
                digit = (char)(digit + '\u0001');
            }
            quadKey.append(digit);
        }
        return quadKey.toString();
    }

    public static Point QuadKeyToTileXY(String quadKey, Point reuse) {
        int levelOfDetail;
        Point out = reuse == null ? new Point() : reuse;
        int tileX = 0;
        int tileY = 0;
        block6: for (int i = levelOfDetail = quadKey.length(); i > 0; --i) {
            int mask = 1 << i - 1;
            switch (quadKey.charAt(levelOfDetail - i)) {
                case '0': {
                    continue block6;
                }
                case '1': {
                    tileX |= mask;
                    continue block6;
                }
                case '2': {
                    tileY |= mask;
                    continue block6;
                }
                case '3': {
                    tileX |= mask;
                    tileY |= mask;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Invalid QuadKey digit sequence.");
                }
            }
        }
        out.set(tileX, tileY);
        return out;
    }
}

