/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import java.util.HashMap;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileCache;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.TileLooper;
import org.osmdroid.views.Projection;

public abstract class MapTileProviderBase
implements IMapTileProviderCallback {
    protected final MapTileCache mTileCache = this.createTileCache();
    protected Handler mTileRequestCompleteHandler;
    protected boolean mUseDataConnection = true;
    protected Drawable mTileNotFoundImage = null;
    private ITileSource mTileSource;

    public abstract Drawable getMapTile(MapTile var1);

    public void detach() {
        if (this.mTileNotFoundImage != null) {
            Bitmap bitmap;
            if (Build.VERSION.SDK_INT < 9 && this.mTileNotFoundImage instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)this.mTileNotFoundImage).getBitmap()) != null) {
                bitmap.recycle();
            }
            if (this.mTileNotFoundImage instanceof ReusableBitmapDrawable) {
                BitmapPool.getInstance().returnDrawableToPool((ReusableBitmapDrawable)this.mTileNotFoundImage);
            }
        }
        this.mTileNotFoundImage = null;
    }

    public abstract int getMinimumZoomLevel();

    public abstract int getMaximumZoomLevel();

    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource = pTileSource;
        this.clearTileCache();
    }

    public ITileSource getTileSource() {
        return this.mTileSource;
    }

    public MapTileCache createTileCache() {
        return new MapTileCache();
    }

    public MapTileProviderBase(ITileSource pTileSource) {
        this(pTileSource, null);
    }

    public MapTileProviderBase(ITileSource pTileSource, Handler pDownloadFinishedListener) {
        this.mTileRequestCompleteHandler = pDownloadFinishedListener;
        this.mTileSource = pTileSource;
    }

    public void setTileLoadFailureImage(Drawable drawable) {
        this.mTileNotFoundImage = drawable;
    }

    @Override
    public void mapTileRequestCompleted(MapTileRequestState pState, Drawable pDrawable) {
        this.putTileIntoCache(pState, pDrawable);
        if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(0);
        }
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)("MapTileProviderBase.mapTileRequestCompleted(): " + pState.getMapTile()));
        }
    }

    @Override
    public void mapTileRequestFailed(MapTileRequestState pState) {
        if (this.mTileNotFoundImage != null) {
            this.putTileIntoCache(pState, this.mTileNotFoundImage);
            if (this.mTileRequestCompleteHandler != null) {
                this.mTileRequestCompleteHandler.sendEmptyMessage(0);
            }
        } else if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(1);
        }
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)("MapTileProviderBase.mapTileRequestFailed(): " + pState.getMapTile()));
        }
    }

    @Override
    public void mapTileRequestExpiredTile(MapTileRequestState pState, Drawable pDrawable) {
        this.putExpiredTileIntoCache(pState, pDrawable);
        if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(0);
        }
        if (Configuration.getInstance().isDebugTileProviders()) {
            Log.d((String)"OsmDroid", (String)("MapTileProviderBase.mapTileRequestExpiredTile(): " + pState.getMapTile()));
        }
    }

    protected void putTileIntoCache(MapTileRequestState pState, Drawable pDrawable) {
        MapTile tile = pState.getMapTile();
        if (pDrawable != null) {
            this.mTileCache.putTile(tile, pDrawable);
        }
    }

    protected void putExpiredTileIntoCache(MapTileRequestState pState, Drawable pDrawable) {
        MapTile tile = pState.getMapTile();
        if (pDrawable != null && !this.mTileCache.containsTile(tile)) {
            this.mTileCache.putTile(tile, pDrawable);
        }
    }

    public void setTileRequestCompleteHandler(Handler handler) {
        this.mTileRequestCompleteHandler = handler;
    }

    public void ensureCapacity(int pCapacity) {
        this.mTileCache.ensureCapacity(pCapacity);
    }

    public void clearTileCache() {
        this.mTileCache.clear();
    }

    @Override
    public boolean useDataConnection() {
        return this.mUseDataConnection;
    }

    public void setUseDataConnection(boolean pMode) {
        this.mUseDataConnection = pMode;
    }

    public void rescaleCache(Projection pProjection, int pNewZoomLevel, int pOldZoomLevel, Rect pViewPort) {
        if (pNewZoomLevel == pOldZoomLevel) {
            return;
        }
        long startMs = System.currentTimeMillis();
        Log.i((String)"OsmDroid", (String)("rescale tile cache from " + pOldZoomLevel + " to " + pNewZoomLevel));
        int tileSize = this.getTileSource().getTileSizePixels();
        Point topLeftMercator = pProjection.toMercatorPixels(pViewPort.left, pViewPort.top, null);
        Point bottomRightMercator = pProjection.toMercatorPixels(pViewPort.right, pViewPort.bottom, null);
        Rect viewPort = new Rect(topLeftMercator.x, topLeftMercator.y, bottomRightMercator.x, bottomRightMercator.y);
        ScaleTileLooper tileLooper = pNewZoomLevel > pOldZoomLevel ? new ZoomInTileLooper(pOldZoomLevel) : new ZoomOutTileLooper(pOldZoomLevel);
        tileLooper.loop(null, pNewZoomLevel, tileSize, viewPort);
        long endMs = System.currentTimeMillis();
        Log.i((String)"OsmDroid", (String)("Finished rescale in " + (endMs - startMs) + "ms"));
    }

    public abstract IFilesystemCache getTileWriter();

    public abstract long getQueueSize();

    private class ZoomOutTileLooper
    extends ScaleTileLooper {
        private static final int MAX_ZOOM_OUT_DIFF = 4;

        public ZoomOutTileLooper(int pOldZoomLevel) {
            super(pOldZoomLevel);
        }

        @Override
        protected void handleTile(int pTileSizePx, MapTile pTile, int pX, int pY) {
            if (this.mDiff >= 4) {
                return;
            }
            int xx = pTile.getX() << this.mDiff;
            int yy = pTile.getY() << this.mDiff;
            int numTiles = 1 << this.mDiff;
            Bitmap bitmap = null;
            Canvas canvas = null;
            for (int x = 0; x < numTiles; ++x) {
                for (int y = 0; y < numTiles; ++y) {
                    Bitmap oldBitmap;
                    MapTile oldTile = new MapTile(this.mOldZoomLevel, xx + x, yy + y);
                    Drawable oldDrawable = MapTileProviderBase.this.mTileCache.getMapTile(oldTile);
                    if (!(oldDrawable instanceof BitmapDrawable) || (oldBitmap = ((BitmapDrawable)oldDrawable).getBitmap()) == null) continue;
                    if (bitmap == null) {
                        bitmap = BitmapPool.getInstance().obtainSizedBitmapFromPool(pTileSizePx, pTileSizePx);
                        if (bitmap == null) {
                            bitmap = Bitmap.createBitmap((int)pTileSizePx, (int)pTileSizePx, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        }
                        canvas = new Canvas(bitmap);
                        canvas.drawColor(-3355444);
                    }
                    this.mDestRect.set(x * this.mTileSize_2, y * this.mTileSize_2, (x + 1) * this.mTileSize_2, (y + 1) * this.mTileSize_2);
                    if (oldBitmap == null) continue;
                    canvas.drawBitmap(oldBitmap, null, this.mDestRect, null);
                    MapTileProviderBase.this.mTileCache.mCachedTiles.remove(oldBitmap);
                }
            }
            if (bitmap != null) {
                this.mNewTiles.put(pTile, bitmap);
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)("Created scaled tile: " + pTile));
                    this.mDebugPaint.setTextSize(40.0f);
                    canvas.drawText("scaled", 50.0f, 50.0f, this.mDebugPaint);
                }
            }
        }
    }

    private class ZoomInTileLooper
    extends ScaleTileLooper {
        public ZoomInTileLooper(int pOldZoomLevel) {
            super(pOldZoomLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTile(int pTileSizePx, MapTile pTile, int pX, int pY) {
            MapTile oldTile = new MapTile(this.mOldZoomLevel, pTile.getX() >> this.mDiff, pTile.getY() >> this.mDiff);
            Drawable oldDrawable = MapTileProviderBase.this.mTileCache.getMapTile(oldTile);
            if (oldDrawable instanceof BitmapDrawable) {
                int xx = pX % (1 << this.mDiff) * this.mTileSize_2;
                int yy = pY % (1 << this.mDiff) * this.mTileSize_2;
                this.mSrcRect.set(xx, yy, xx + this.mTileSize_2, yy + this.mTileSize_2);
                this.mDestRect.set(0, 0, pTileSizePx, pTileSizePx);
                Bitmap bitmap = BitmapPool.getInstance().obtainSizedBitmapFromPool(pTileSizePx, pTileSizePx);
                if (bitmap == null) {
                    bitmap = Bitmap.createBitmap((int)pTileSizePx, (int)pTileSizePx, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                Canvas canvas = new Canvas(bitmap);
                boolean isReusable = oldDrawable instanceof ReusableBitmapDrawable;
                ReusableBitmapDrawable reusableBitmapDrawable = isReusable ? (ReusableBitmapDrawable)oldDrawable : null;
                boolean success = false;
                if (isReusable) {
                    reusableBitmapDrawable.beginUsingDrawable();
                }
                try {
                    if (!isReusable || reusableBitmapDrawable.isBitmapValid()) {
                        BitmapDrawable bitmapDrawable = (BitmapDrawable)oldDrawable;
                        Bitmap oldBitmap = bitmapDrawable.getBitmap();
                        canvas.drawBitmap(oldBitmap, this.mSrcRect, this.mDestRect, null);
                        success = true;
                        if (Configuration.getInstance().isDebugMode()) {
                            Log.d((String)"OsmDroid", (String)("Created scaled tile: " + pTile));
                            this.mDebugPaint.setTextSize(40.0f);
                            canvas.drawText("scaled", 50.0f, 50.0f, this.mDebugPaint);
                        }
                    }
                }
                finally {
                    if (isReusable) {
                        reusableBitmapDrawable.finishUsingDrawable();
                    }
                }
                if (success) {
                    this.mNewTiles.put(pTile, bitmap);
                }
            }
        }
    }

    private abstract class ScaleTileLooper
    extends TileLooper {
        protected final HashMap<MapTile, Bitmap> mNewTiles;
        protected final int mOldZoomLevel;
        protected int mDiff;
        protected int mTileSize_2;
        protected Rect mSrcRect;
        protected Rect mDestRect;
        protected Paint mDebugPaint;

        public ScaleTileLooper(int pOldZoomLevel) {
            this.mOldZoomLevel = pOldZoomLevel;
            this.mNewTiles = new HashMap();
            this.mSrcRect = new Rect();
            this.mDestRect = new Rect();
            this.mDebugPaint = new Paint();
        }

        @Override
        public void initialiseLoop(int pZoomLevel, int pTileSizePx) {
            this.mDiff = Math.abs(pZoomLevel - this.mOldZoomLevel);
            this.mTileSize_2 = pTileSizePx >> this.mDiff;
        }

        @Override
        public void handleTile(Canvas pCanvas, int pTileSizePx, MapTile pTile, int pX, int pY) {
            Drawable requestedTile = MapTileProviderBase.this.getMapTile(pTile);
            if (requestedTile == null) {
                try {
                    this.handleTile(pTileSizePx, pTile, pX, pY);
                }
                catch (OutOfMemoryError e) {
                    Log.e((String)"OsmDroid", (String)"OutOfMemoryError rescaling cache");
                }
            }
        }

        @Override
        public void finaliseLoop() {
            while (!this.mNewTiles.isEmpty()) {
                MapTile tile = this.mNewTiles.keySet().iterator().next();
                Bitmap bitmap = this.mNewTiles.remove(tile);
                ReusableBitmapDrawable drawable = new ReusableBitmapDrawable(bitmap);
                ExpirableBitmapDrawable.setDrawableExpired((Drawable)drawable);
                Drawable existingTile = MapTileProviderBase.this.mTileCache.getMapTile(tile);
                if (existingTile != null && !ExpirableBitmapDrawable.isDrawableExpired(existingTile)) continue;
                MapTileProviderBase.this.putExpiredTileIntoCache(new MapTileRequestState(tile, new MapTileModuleProviderBase[0], null), (Drawable)drawable);
            }
        }

        protected abstract void handleTile(int var1, MapTile var2, int var3, int var4);
    }
}

