/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource.bing;

import android.content.Context;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import microsoft.mappoint.TileSystem;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.tilesource.IStyledTileSource;
import org.osmdroid.tileprovider.tilesource.QuadTreeTileSource;
import org.osmdroid.tileprovider.tilesource.bing.ImageryMetaData;
import org.osmdroid.tileprovider.tilesource.bing.ImageryMetaDataResource;
import org.osmdroid.tileprovider.util.ManifestUtil;
import org.osmdroid.tileprovider.util.StreamUtils;

public class BingMapTileSource
extends QuadTreeTileSource
implements IStyledTileSource<String> {
    private static final String BING_KEY = "BING_KEY";
    public static final String IMAGERYSET_AERIAL = "Aerial";
    public static final String IMAGERYSET_AERIALWITHLABELS = "AerialWithLabels";
    public static final String IMAGERYSET_ROAD = "Road";
    private static final String FILENAME_ENDING = ".jpeg";
    private static final String BASE_URL_PATTERN = "http://dev.virtualearth.net/REST/V1/Imagery/Metadata/%s?mapVersion=v1&output=json&key=%s";
    private static String mBingMapKey = "";
    private String mStyle = "Road";
    private ImageryMetaDataResource mImageryData = ImageryMetaDataResource.getDefaultInstance();
    private String mLocale;
    private String mBaseUrl;
    private String mUrl;

    public BingMapTileSource(String aLocale) {
        super("BingMaps", 0, 19, 256, FILENAME_ENDING, (String[])null);
        this.mLocale = aLocale;
        if (this.mLocale == null) {
            this.mLocale = Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
        }
    }

    public static void retrieveBingKey(Context aContext) {
        mBingMapKey = ManifestUtil.retrieveKey(aContext, BING_KEY);
    }

    public static String getBingKey() {
        return mBingMapKey;
    }

    public static void setBingKey(String key) {
        mBingMapKey = key;
    }

    @Override
    public String getBaseUrl() {
        if (!this.mImageryData.m_isInitialised) {
            this.initMetaData();
        }
        return this.mBaseUrl;
    }

    @Override
    public String getTileURLString(MapTile pTile) {
        if (!this.mImageryData.m_isInitialised) {
            this.initMetaData();
        }
        return String.format(this.mUrl, this.quadTree(pTile));
    }

    @Override
    public int getMinimumZoomLevel() {
        return this.mImageryData.m_zoomMin;
    }

    @Override
    public int getMaximumZoomLevel() {
        return this.mImageryData.m_zoomMax;
    }

    @Override
    public int getTileSizePixels() {
        return this.mImageryData.m_imageHeight;
    }

    @Override
    public String pathBase() {
        return this.mName + this.mStyle;
    }

    @Override
    public String getCopyrightNotice() {
        return this.mImageryData.copyright;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStyle(String pStyle) {
        if (!pStyle.equals(this.mStyle)) {
            String string = this.mStyle;
            synchronized (string) {
                this.mUrl = null;
                this.mBaseUrl = null;
                this.mImageryData.m_isInitialised = false;
            }
        }
        this.mStyle = pStyle;
        this.mName = this.pathBase();
    }

    @Override
    public String getStyle() {
        return this.mStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageryMetaDataResource initMetaData() {
        if (!this.mImageryData.m_isInitialised) {
            BingMapTileSource bingMapTileSource = this;
            synchronized (bingMapTileSource) {
                ImageryMetaDataResource imageryData;
                if (!this.mImageryData.m_isInitialised && (imageryData = this.getMetaData()) != null) {
                    this.mImageryData = imageryData;
                    TileSystem.setTileSize(this.getTileSizePixels());
                    this.updateBaseUrl();
                }
            }
        }
        return this.mImageryData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageryMetaDataResource getMetaData() {
        Log.d((String)"OsmDroid", (String)"getMetaData");
        HttpURLConnection client = null;
        try {
            client = (HttpURLConnection)new URL(String.format(BASE_URL_PATTERN, this.mStyle, mBingMapKey)).openConnection();
            Log.d((String)"OsmDroid", (String)("make request " + client.getURL().toString().toString()));
            client.setRequestProperty(Configuration.getInstance().getUserAgentHttpHeader(), Configuration.getInstance().getUserAgentValue());
            client.connect();
            if (client.getResponseCode() != 200) {
                Log.e((String)"OsmDroid", (String)("Cannot get response for url " + client.getURL().toString() + " " + client.getResponseMessage()));
                ImageryMetaDataResource imageryMetaDataResource = null;
                return imageryMetaDataResource;
            }
            InputStream in = client.getInputStream();
            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
            BufferedOutputStream out = new BufferedOutputStream(dataStream, 8192);
            StreamUtils.copy(in, out);
            out.flush();
            ImageryMetaDataResource imageryMetaDataResource = ImageryMetaData.getInstanceFromJSON(dataStream.toString());
            return imageryMetaDataResource;
        }
        catch (Exception e) {
            Log.e((String)"OsmDroid", (String)"Error getting imagery meta data", (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.disconnect();
                }
            }
            catch (Exception exception) {}
            Log.d((String)"OsmDroid", (String)"end getMetaData");
        }
        return null;
    }

    protected void updateBaseUrl() {
        Log.d((String)"OsmDroid", (String)"updateBaseUrl");
        String subDomain = this.mImageryData.getSubDomain();
        int idx = this.mImageryData.m_imageUrl.lastIndexOf("/");
        this.mBaseUrl = idx > 0 ? this.mImageryData.m_imageUrl.substring(0, idx) : this.mImageryData.m_imageUrl;
        this.mUrl = this.mImageryData.m_imageUrl;
        if (subDomain != null) {
            this.mBaseUrl = String.format(this.mBaseUrl, subDomain);
            this.mUrl = String.format(this.mUrl, subDomain, "%s", this.mLocale);
        }
        Log.d((String)"OsmDroid", (String)("updated url = " + this.mUrl));
        Log.d((String)"OsmDroid", (String)"end updateBaseUrl");
    }
}

