/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import microsoft.mappoint.TileSystem;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IProjection;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.util.constants.MapViewConstants;

public class Projection
implements IProjection,
MapViewConstants {
    private final int mMapViewWidth;
    private final int mMapViewHeight;
    protected final int mOffsetX;
    protected final int mOffsetY;
    protected final float mMultiTouchScale;
    private final Matrix mRotateAndScaleMatrix = new Matrix();
    private final Matrix mUnrotateAndScaleMatrix = new Matrix();
    private final float[] mRotateScalePoints = new float[2];
    private final BoundingBox mBoundingBoxProjection;
    private final int mZoomLevelProjection;
    private final Rect mScreenRectProjection;
    private final Rect mIntrinsicScreenRectProjection;
    private MapView mapView;

    Projection(MapView mapView) {
        this.mapView = mapView;
        this.mZoomLevelProjection = mapView.getZoomLevel(false);
        this.mScreenRectProjection = mapView.getScreenRect(null);
        this.mIntrinsicScreenRectProjection = mapView.getIntrinsicScreenRect(null);
        this.mMapViewWidth = mapView.getWidth();
        this.mMapViewHeight = mapView.getHeight();
        this.mOffsetX = -mapView.getScrollX();
        this.mOffsetY = -mapView.getScrollY();
        this.mRotateAndScaleMatrix.set(mapView.mRotateScaleMatrix);
        this.mRotateAndScaleMatrix.invert(this.mUnrotateAndScaleMatrix);
        this.mMultiTouchScale = mapView.mMultiTouchScale;
        IGeoPoint neGeoPoint = this.fromPixels(this.mMapViewWidth, 0, null);
        IGeoPoint swGeoPoint = this.fromPixels(0, this.mMapViewHeight, null);
        this.mBoundingBoxProjection = new BoundingBox(neGeoPoint.getLatitude(), neGeoPoint.getLongitude(), swGeoPoint.getLatitude(), swGeoPoint.getLongitude());
    }

    public int getZoomLevel() {
        return this.mZoomLevelProjection;
    }

    public BoundingBox getBoundingBox() {
        return this.mBoundingBoxProjection;
    }

    @Deprecated
    public BoundingBoxE6 getBoundingBoxE6() {
        BoundingBoxE6 x = new BoundingBoxE6(this.mBoundingBoxProjection.getLatNorth(), this.mBoundingBoxProjection.getLonEast(), this.mBoundingBoxProjection.getLatSouth(), this.mBoundingBoxProjection.getLonWest());
        return x;
    }

    public Rect getScreenRect() {
        return this.mScreenRectProjection;
    }

    public Rect getIntrinsicScreenRect() {
        return this.mIntrinsicScreenRectProjection;
    }

    public float getMapOrientation() {
        return this.mapView.getMapOrientation();
    }

    @Override
    public IGeoPoint fromPixels(int x, int y) {
        return this.fromPixels(x, y, null);
    }

    public IGeoPoint fromPixels(int x, int y, GeoPoint reuse) {
        Point point = this.unrotateAndScalePoint(x, y, null);
        return org.osmdroid.util.TileSystem.PixelXYToLatLong(point.x - this.mOffsetX, point.y - this.mOffsetY, this.mZoomLevelProjection, reuse);
    }

    @Override
    public Point toPixels(IGeoPoint in, Point reuse) {
        Point out = org.osmdroid.util.TileSystem.LatLongToPixelXY(in.getLatitude(), in.getLongitude(), this.getZoomLevel(), reuse);
        out = this.toPixelsFromMercator(out.x, out.y, out);
        out = this.adjustForDateLine(out.x, out.y, out);
        return out;
    }

    protected Point adjustForDateLine(int x, int y, Point reuse) {
        int yCompare;
        Point out = reuse != null ? reuse : new Point();
        out.set(x, y);
        out.offset(-this.mMapViewWidth / 2, -this.mMapViewHeight / 2);
        int mapSize = org.osmdroid.util.TileSystem.MapSize(this.getZoomLevel());
        int absX = Math.abs(out.x);
        int absY = Math.abs(out.y);
        int n = yCompare = mapSize > this.mMapViewHeight ? mapSize : this.mMapViewHeight;
        if (absX > Math.abs(out.x - mapSize)) {
            out.x -= mapSize;
        }
        if (absX > Math.abs(out.x + mapSize)) {
            out.x += mapSize;
        }
        if (absY > Math.abs(out.y - yCompare) && this.mMapViewHeight / 2 < mapSize) {
            out.y -= mapSize;
        }
        if (absY > Math.abs(out.y + yCompare) || this.mMapViewHeight / 2 >= mapSize) {
            out.y += mapSize;
        }
        out.offset(this.mMapViewWidth / 2, this.mMapViewHeight / 2);
        return out;
    }

    public Point toProjectedPixels(GeoPoint geoPoint, Point reuse) {
        return this.toProjectedPixels(geoPoint.getLatitude(), geoPoint.getLongitude(), reuse);
    }

    public Point toProjectedPixels(int latituteE6, int longitudeE6, Point reuse) {
        return org.osmdroid.util.TileSystem.LatLongToPixelXY((double)latituteE6 * 1.0E-6, (double)longitudeE6 * 1.0E-6, TileSystem.getMaximumZoomLevel(), reuse);
    }

    public Point toProjectedPixels(double latitude, double longitude, Point reuse) {
        return org.osmdroid.util.TileSystem.LatLongToPixelXY(latitude, longitude, TileSystem.getMaximumZoomLevel(), reuse);
    }

    public Point toPixelsFromProjected(Point in, Point reuse) {
        Point out = reuse != null ? reuse : new Point();
        int zoomDifference = TileSystem.getMaximumZoomLevel() - this.getZoomLevel();
        out.set(in.x >> zoomDifference, in.y >> zoomDifference);
        out = this.toPixelsFromMercator(out.x, out.y, out);
        out = this.adjustForDateLine(out.x, out.y, out);
        return out;
    }

    public Point toPixelsFromMercator(int x, int y, Point reuse) {
        Point out = reuse != null ? reuse : new Point();
        out.set(x, y);
        out.offset(this.mOffsetX, this.mOffsetY);
        return out;
    }

    public Point toMercatorPixels(int x, int y, Point reuse) {
        Point out = reuse != null ? reuse : new Point();
        out.set(x, y);
        out.offset(-this.mOffsetX, -this.mOffsetY);
        return out;
    }

    @Override
    public float metersToEquatorPixels(float meters) {
        return meters / (float)org.osmdroid.util.TileSystem.GroundResolution(0.0, this.mZoomLevelProjection);
    }

    public float metersToPixels(float meters) {
        return meters / (float)org.osmdroid.util.TileSystem.GroundResolution(this.getBoundingBox().getCenter().getLatitude(), this.mZoomLevelProjection);
    }

    @Override
    public IGeoPoint getNorthEast() {
        return this.fromPixels(this.mMapViewWidth, 0, null);
    }

    @Override
    public IGeoPoint getSouthWest() {
        return this.fromPixels(0, this.mMapViewHeight, null);
    }

    public Matrix getInvertedScaleRotateCanvasMatrix() {
        return this.mUnrotateAndScaleMatrix;
    }

    public Point unrotateAndScalePoint(int x, int y, Point reuse) {
        if (reuse == null) {
            reuse = new Point();
        }
        if (this.getMapOrientation() != 0.0f || this.mMultiTouchScale != 1.0f) {
            this.mRotateScalePoints[0] = x;
            this.mRotateScalePoints[1] = y;
            this.mUnrotateAndScaleMatrix.mapPoints(this.mRotateScalePoints);
            reuse.set((int)this.mRotateScalePoints[0], (int)this.mRotateScalePoints[1]);
        } else {
            reuse.set(x, y);
        }
        return reuse;
    }

    public Point rotateAndScalePoint(int x, int y, Point reuse) {
        if (reuse == null) {
            reuse = new Point();
        }
        if (this.getMapOrientation() != 0.0f || this.mMultiTouchScale != 1.0f) {
            this.mRotateScalePoints[0] = x;
            this.mRotateScalePoints[1] = y;
            this.mRotateAndScaleMatrix.mapPoints(this.mRotateScalePoints);
            reuse.set((int)this.mRotateScalePoints[0], (int)this.mRotateScalePoints[1]);
        } else {
            reuse.set(x, y);
        }
        return reuse;
    }

    public void detach() {
        this.mapView = null;
    }
}

