/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import android.util.Log;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.tilesource.IStyledTileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.CloudmadeUtil;

public class CloudmadeTileSource
extends OnlineTileSourceBase
implements IStyledTileSource<Integer> {
    private Integer mStyle = 1;

    public CloudmadeTileSource(String pName, int pZoomMinLevel, int pZoomMaxLevel, int pTileSizePixels, String pImageFilenameEnding, String[] pBaseUrl) {
        super(pName, pZoomMinLevel, pZoomMaxLevel, pTileSizePixels, pImageFilenameEnding, pBaseUrl);
    }

    @Override
    public String pathBase() {
        if (this.mStyle == null || this.mStyle <= 1) {
            return this.mName;
        }
        return this.mName + this.mStyle;
    }

    @Override
    public String getTileURLString(MapTile pTile) {
        String key = CloudmadeUtil.getCloudmadeKey();
        if (key.length() == 0) {
            Log.e((String)"OsmDroid", (String)"CloudMade key is not set. You should enter it in the manifest and call CloudmadeUtil.retrieveCloudmadeKey()");
        }
        String token = CloudmadeUtil.getCloudmadeToken();
        return String.format(this.getBaseUrl(), key, this.mStyle, this.getTileSizePixels(), pTile.getZoomLevel(), pTile.getX(), pTile.getY(), this.mImageFilenameEnding, token);
    }

    @Override
    public void setStyle(Integer pStyle) {
        this.mStyle = pStyle;
    }

    @Override
    public void setStyle(String pStyle) {
        try {
            this.mStyle = Integer.parseInt(pStyle);
        }
        catch (NumberFormatException e) {
            Log.e((String)"OsmDroid", (String)("Error setting integer style: " + pStyle));
        }
    }

    @Override
    public Integer getStyle() {
        return this.mStyle;
    }
}

