/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import microsoft.mappoint.TileSystem;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.modules.ArchiveFileFactory;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.StreamUtils;

public class MapTileFileArchiveProvider
extends MapTileFileStorageProviderBase {
    private final ArrayList<IArchiveFile> mArchiveFiles = new ArrayList();
    private final AtomicReference<ITileSource> mTileSource = new AtomicReference();
    private final boolean mSpecificArchivesProvided;

    public MapTileFileArchiveProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, IArchiveFile[] pArchives) {
        super(pRegisterReceiver, 8, 40);
        this.setTileSource(pTileSource);
        if (pArchives == null) {
            this.mSpecificArchivesProvided = false;
            this.findArchiveFiles();
        } else {
            this.mSpecificArchivesProvided = true;
            for (int i = pArchives.length - 1; i >= 0; --i) {
                this.mArchiveFiles.add(pArchives[i]);
            }
        }
    }

    public MapTileFileArchiveProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource) {
        this(pRegisterReceiver, pTileSource, null);
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "File Archive Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "filearchive";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    protected void onMediaMounted() {
        if (!this.mSpecificArchivesProvided) {
            this.findArchiveFiles();
        }
    }

    @Override
    protected void onMediaUnmounted() {
        if (!this.mSpecificArchivesProvided) {
            this.findArchiveFiles();
        }
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource.set(pTileSource);
    }

    @Override
    public void detach() {
        while (!this.mArchiveFiles.isEmpty()) {
            IArchiveFile t = this.mArchiveFiles.get(0);
            if (t != null) {
                this.mArchiveFiles.get(0).close();
            }
            this.mArchiveFiles.remove(0);
        }
        super.detach();
    }

    private void findArchiveFiles() {
        this.mArchiveFiles.clear();
        if (!this.getSdCardAvailable()) {
            return;
        }
        File cachePaths = OpenStreetMapTileProviderConstants.getBasePath();
        File[] files = cachePaths.listFiles();
        if (files != null) {
            for (File file : files) {
                IArchiveFile archiveFile = ArchiveFileFactory.getArchiveFile(file);
                if (archiveFile == null) continue;
                this.mArchiveFiles.add(archiveFile);
            }
        }
    }

    private synchronized InputStream getInputStream(MapTile pTile, ITileSource tileSource) {
        for (IArchiveFile archiveFile : this.mArchiveFiles) {
            InputStream in;
            if (archiveFile == null || (in = archiveFile.getInputStream(tileSource, pTile)) == null) continue;
            if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                Log.d((String)"OsmDroid", (String)("Found tile " + pTile + " in " + archiveFile));
            }
            return in;
        }
        return null;
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
            super(MapTileFileArchiveProvider.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Drawable loadTile(MapTileRequestState pState) {
            InputStream inputStream;
            block8: {
                Drawable drawable;
                ITileSource tileSource = (ITileSource)MapTileFileArchiveProvider.this.mTileSource.get();
                if (tileSource == null) {
                    return null;
                }
                MapTile pTile = pState.getMapTile();
                if (!MapTileFileArchiveProvider.this.getSdCardAvailable()) {
                    if (!OpenStreetMapTileProviderConstants.DEBUGMODE) return null;
                    Log.d((String)"OsmDroid", (String)("No sdcard - do nothing for tile: " + pTile));
                    return null;
                }
                inputStream = null;
                try {
                    Drawable drawable2;
                    if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                        Log.d((String)"OsmDroid", (String)("Tile doesn't exist: " + pTile));
                    }
                    if ((inputStream = MapTileFileArchiveProvider.this.getInputStream(pTile, tileSource)) == null) break block8;
                    if (OpenStreetMapTileProviderConstants.DEBUGMODE) {
                        Log.d((String)"OsmDroid", (String)("Use tile from archive: " + pTile));
                    }
                    drawable = drawable2 = tileSource.getDrawable(inputStream);
                    if (inputStream == null) return drawable;
                }
                catch (Throwable e) {
                    try {
                        Log.e((String)"OsmDroid", (String)"Error loading tile", (Throwable)e);
                        if (inputStream == null) return null;
                    }
                    catch (Throwable throwable) {
                        if (inputStream == null) throw throwable;
                        StreamUtils.closeStream(inputStream);
                        throw throwable;
                    }
                    StreamUtils.closeStream(inputStream);
                    return null;
                }
                StreamUtils.closeStream(inputStream);
                return drawable;
            }
            if (inputStream == null) return null;
            StreamUtils.closeStream(inputStream);
            return null;
        }
    }
}

