/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.osmdroid.ResourceProxy;
import org.osmdroid.views.util.constants.MapViewConstants;

public class DefaultResourceProxyImpl
implements ResourceProxy,
MapViewConstants {
    private Resources mResources;
    private DisplayMetrics mDisplayMetrics;

    public DefaultResourceProxyImpl(Context pContext) {
        if (pContext != null) {
            this.mResources = pContext.getResources();
            this.mDisplayMetrics = this.mResources.getDisplayMetrics();
        }
    }

    @Override
    public String getString(ResourceProxy.string pResId) {
        switch (pResId) {
            case unknown: {
                return "Unknown";
            }
            case format_distance_meters: {
                return "%s m";
            }
            case format_distance_kilometers: {
                return "%s km";
            }
            case format_distance_miles: {
                return "%s mi";
            }
            case format_distance_nautical_miles: {
                return "%s nm";
            }
            case format_distance_feet: {
                return "%s ft";
            }
            case online_mode: {
                return "Online mode";
            }
            case offline_mode: {
                return "Offline mode";
            }
            case my_location: {
                return "My location";
            }
            case compass: {
                return "Compass";
            }
            case map_mode: {
                return "Map mode";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getString(ResourceProxy.string pResId, Object ... formatArgs) {
        return String.format(this.getString(pResId), formatArgs);
    }

    @Override
    public Bitmap getBitmap(ResourceProxy.bitmap pResId) {
        InputStream is = null;
        try {
            String resName = pResId.name() + ".png";
            is = ResourceProxy.class.getResourceAsStream(resName);
            if (is == null) {
                throw new IllegalArgumentException("Resource not found: " + resName);
            }
            BitmapFactory.Options options = null;
            if (this.mDisplayMetrics != null) {
                options = this.getBitmapOptions();
            }
            Bitmap bitmap2 = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            return bitmap2;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)"OsmDroid", (String)("OutOfMemoryError getting bitmap resource: " + (Object)((Object)pResId)));
            System.gc();
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private BitmapFactory.Options getBitmapOptions() {
        try {
            Field density = DisplayMetrics.class.getDeclaredField("DENSITY_DEFAULT");
            Field inDensity = BitmapFactory.Options.class.getDeclaredField("inDensity");
            Field inTargetDensity = BitmapFactory.Options.class.getDeclaredField("inTargetDensity");
            Field targetDensity = DisplayMetrics.class.getDeclaredField("densityDpi");
            BitmapFactory.Options options = new BitmapFactory.Options();
            inDensity.setInt(options, density.getInt(null));
            inTargetDensity.setInt(options, targetDensity.getInt(this.mDisplayMetrics));
            return options;
        }
        catch (IllegalAccessException ex) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Drawable getDrawable(ResourceProxy.bitmap pResId) {
        return this.mResources != null ? new BitmapDrawable(this.mResources, this.getBitmap(pResId)) : new BitmapDrawable(this.getBitmap(pResId));
    }

    @Override
    public float getDisplayMetricsDensity() {
        return this.mDisplayMetrics.density;
    }

    @Override
    public DisplayMetrics getDisplayMetrics() {
        return this.mDisplayMetrics;
    }
}

